/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.pipes;

import buildcraft.api.APIProxy;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.IProvideItems;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsTransaction;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.BaseChassiLogic;
import buildcraft.krapht.network.PacketCoordinates;
import buildcraft.krapht.pipes.ChassiPipeProxy;
import buildcraft.krapht.routing.IRouter;
import buildcraft.logisticspipes.ChassiModule;
import buildcraft.logisticspipes.ChassiTransportLayer;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.ItemModuleInformationManager;
import buildcraft.logisticspipes.SidedInventoryAdapter;
import buildcraft.logisticspipes.TransportLayer;
import buildcraft.logisticspipes.items.ItemModule;
import buildcraft.logisticspipes.modules.ILegacyActiveModule;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.transport.TileGenericPipe;
import forge.ISidedInventory;
import forge.NetworkMod;
import java.util.HashMap;
import java.util.UUID;
import krapht.ISimpleInventoryEventHandler;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;

public abstract class PipeLogisticsChassi
extends RoutedPipe
implements ISimpleInventoryEventHandler,
IInventoryProvider,
ISendRoutedItem,
IProvideItems,
IWorldProvider {
    private final ChassiModule _module;
    private final SimpleInventory _moduleInventory;
    private boolean switchOrientationOnTick = false;
    private boolean init = false;
    private long tick = 0L;
    BaseChassiLogic ChassiLogic = (BaseChassiLogic)this.logic;
    private boolean convertFromMeta = false;

    public PipeLogisticsChassi(int itemID) {
        super(new BaseChassiLogic(), itemID);
        this._moduleInventory = new SimpleInventory(this.getChassiSize(), "Chassi pipe", 1);
        this._moduleInventory.addListener(this);
        this._module = new ChassiModule(this.getChassiSize(), this);
    }

    public Orientations getPointedOrientation() {
        return this.ChassiLogic.orientation;
    }

    public qj getPointedTileEntity() {
        Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, this.ChassiLogic.orientation);
        pos.moveForwards(1.0);
        return this.worldObj.b((int)pos.x, (int)pos.y, (int)pos.z);
    }

    public void nextOrientation() {
        for (int l = 0; l < 6; ++l) {
            this.ChassiLogic.orientation = Orientations.values()[(this.ChassiLogic.orientation.ordinal() + 1) % 6];
            if (!this.isValidOrientation(this.ChassiLogic.orientation)) continue;
            return;
        }
    }

    private boolean isValidOrientation(Orientations connection) {
        if (this.getRouter().isRoutedExit(connection)) {
            return false;
        }
        Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, connection);
        pos.moveForwards(1.0);
        qj tile = this.worldObj.b((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile == null) {
            return false;
        }
        return SimpleServiceLocator.buildCraftProxy.checkPipesConnections((qj)this.container, tile);
    }

    public ni getModuleInventory() {
        return this._moduleInventory;
    }

    @Override
    public int getCenterTexture() {
        return core_LogisticsPipes.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public int getRoutedTexture(Orientations connection) {
        return core_LogisticsPipes.LOGISTICSPIPE_CHASSI_ROUTED_TEXTURE;
    }

    @Override
    public int getNonRoutedTexture(Orientations connection) {
        if (connection.equals((Object)this.ChassiLogic.orientation)) {
            return core_LogisticsPipes.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE;
        }
        return core_LogisticsPipes.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE;
    }

    @Override
    public void onNeighborBlockChange_Logistics() {
        if (!this.isValidOrientation(this.ChassiLogic.orientation)) {
            this.nextOrientation();
        }
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        this.switchOrientationOnTick = true;
    }

    @Override
    public ni getRawInventory() {
        qj tile = this.getPointedTileEntity();
        if (tile instanceof TileGenericPipe) {
            return null;
        }
        if (!(tile instanceof ni)) {
            return null;
        }
        return Utils.getInventory((ni)((ni)tile));
    }

    @Override
    public ni getInventory() {
        ni rawInventory = this.getRawInventory();
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryAdapter((ISidedInventory)rawInventory, this.getPointedOrientation().reverse());
        }
        return rawInventory;
    }

    @Override
    public Orientations inventoryOrientation() {
        return this.getPointedOrientation();
    }

    @Override
    public UUID getSourceUUID() {
        return this.getRouter().getId();
    }

    @Override
    public void sendStack(kp stack) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Passive);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation());
    }

    @Override
    public void sendStack(kp stack, UUID destination) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setSource(this.getRouter().getId());
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Active);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation());
    }

    @Override
    public void readFromNBT(ph nbttagcompound) {
        try {
            super.readFromNBT(nbttagcompound);
            this._moduleInventory.readFromNBT(nbttagcompound, "chassi");
            this.InventoryChanged(this._moduleInventory);
            this._module.readFromNBT(nbttagcompound, "");
            this.ChassiLogic.orientation = Orientations.values()[nbttagcompound.f("Orientation") % 6];
            if (nbttagcompound.f("Orientation") == 0) {
                this.convertFromMeta = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this._moduleInventory.writeToNBT(nbttagcompound, "chassi");
        this._module.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("Orientation", this.ChassiLogic.orientation.ordinal());
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this._moduleInventory.removeListener(this);
        if (!APIProxy.isRemote()) {
            for (int i = 0; i < this._moduleInventory.c(); ++i) {
                if (this._moduleInventory.g_(i) == null) continue;
                ItemModuleInformationManager.saveInfotmation(this._moduleInventory.g_(i), this.getLogisticsModule().getSubModule(i));
            }
            this._moduleInventory.dropContents(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        boolean reInitGui = false;
        for (int i = 0; i < inventory.c(); ++i) {
            ILogisticsModule next;
            ILogisticsModule current;
            kp stack = inventory.g_(i);
            if (stack == null) {
                if (!this._module.hasModule(i)) continue;
                this._module.removeModule(i);
                reInitGui = true;
                continue;
            }
            if (!(stack.a() instanceof ItemModule) || (current = this._module.getModule(i)) == (next = ((ItemModule)stack.a()).getModuleForItem(stack, this._module.getModule(i), this, this, this))) continue;
            this._module.installModule(i, next);
            ItemModuleInformationManager.readInformation(stack, next);
            ItemModuleInformationManager.removeInformation(stack);
        }
        if (reInitGui) {
            ChassiPipeProxy.refreshGui();
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.switchOrientationOnTick) {
            this.switchOrientationOnTick = false;
            if (!APIProxy.isRemote()) {
                this.nextOrientation();
                CoreProxy.sendToPlayers((lx)this.container.getUpdatePacket(), (ge)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (int)DefaultProps.NETWORK_UPDATE_RANGE, (NetworkMod)mod_BuildCraftCore.instance);
            }
        }
        if (this.convertFromMeta && this.worldObj.c(this.xCoord, this.yCoord, this.zCoord) != 0) {
            this.ChassiLogic.orientation = Orientations.values()[this.worldObj.c(this.xCoord, this.yCoord, this.zCoord) % 6];
            this.worldObj.d(this.xCoord, this.yCoord, this.zCoord, 0);
        }
        if (!this.init) {
            this.init = true;
            if (APIProxy.isRemote()) {
                CoreProxy.sendToServer((lx)new PacketCoordinates(33, this.xCoord, this.yCoord, this.zCoord).getPacket());
            }
        }
    }

    public abstract int getChassiSize();

    @Override
    public final ILogisticsModule getLogisticsModule() {
        return this._module;
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new ChassiTransportLayer(this);
        }
        return this._transportLayer;
    }

    @Override
    public boolean blockActivated(ge world, int i, int j, int k, ih entityplayer) {
        if (entityplayer.U() == null) {
            return super.blockActivated(world, i, j, k, entityplayer);
        }
        if (entityplayer.U().a() == BuildCraftCore.wrenchItem && entityplayer.aY()) {
            ((PipeLogisticsChassi)this.container.pipe).nextOrientation();
            return true;
        }
        return super.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public void canProvide(LogisticsTransaction transaction) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ((ILegacyActiveModule)((Object)x)).canProvide(transaction);
        }
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ((ILegacyActiveModule)((Object)x)).fullFill(promise, destination);
        }
    }

    @Override
    public int getAvailableItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            return ((ILegacyActiveModule)((Object)x)).getAvailableItemCount(item);
        }
        return 0;
    }

    @Override
    public HashMap getAllItems() {
        if (!this.isEnabled()) {
            return new HashMap();
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            return ((ILegacyActiveModule)((Object)x)).getAllItems();
        }
        return new HashMap();
    }

    @Override
    public IRouter getRouter() {
        return super.getRouter();
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public ge getWorld() {
        return this.worldObj;
    }
}

