/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.pipes;

import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.IProvideItems;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.LogisticsOrderManager;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.LogisticsTransaction;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.LogicProvider;
import buildcraft.logisticspipes.ExtractionMode;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import krapht.CroppedInventory;
import krapht.InventoryUtil;
import krapht.ItemIdentifier;

public class PipeItemsProviderLogistics
extends RoutedPipe
implements IProvideItems {
    protected LogisticsOrderManager _orderManager = new LogisticsOrderManager();

    public PipeItemsProviderLogistics(int itemID) {
        super(new LogicProvider(), itemID);
    }

    public PipeItemsProviderLogistics(int itemID, LogisticsOrderManager logisticsOrderManager) {
        this(itemID);
        this._orderManager = logisticsOrderManager;
    }

    public int getTotalItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        LogicProvider logicProvider = (LogicProvider)this.logic;
        if (logicProvider.hasFilter() && (logicProvider.isExcludeFilter() && logicProvider.itemIsFiltered(item) || !logicProvider.isExcludeFilter() && !logicProvider.itemIsFiltered(item))) {
            return 0;
        }
        int count = 0;
        for (Orientations o : Orientations.values()) {
            Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            p.moveForwards(1.0);
            qj tile = this.worldObj.b((int)p.x, (int)p.y, (int)p.z);
            if (!(tile instanceof ni) || tile instanceof TileGenericPipe) continue;
            InventoryUtil inv = this.getAdaptedInventoryUtil((ni)tile);
            count += inv.itemCount(item);
        }
        return count;
    }

    protected int sendItem(ItemIdentifier item, int maxCount, UUID destination) {
        int sent = 0;
        for (Orientations o : Orientations.values()) {
            InventoryUtil inv;
            Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            p.moveForwards(1.0);
            qj tile = this.worldObj.b((int)p.x, (int)p.y, (int)p.z);
            if (!(tile instanceof ni) || tile instanceof TileGenericPipe || (inv = this.getAdaptedInventoryUtil((ni)tile)).itemCount(item) <= 0) continue;
            kp removed = inv.getSingleItem(item);
            IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(removed, this.worldObj);
            routedItem.setSource(this.getRouter().getId());
            routedItem.setDestination(destination);
            routedItem.setTransportMode(IRoutedItem.TransportMode.Active);
            super.queueRoutedItem(routedItem, p.orientation);
            ++sent;
            if (--maxCount < 1) break;
        }
        return sent;
    }

    private InventoryUtil getAdaptedInventoryUtil(ni base) {
        ExtractionMode mode = ((LogicProvider)this.logic).getExtractionMode();
        switch (mode) {
            case LeaveFirst: {
                base = new CroppedInventory(base, 1, 0);
                break;
            }
            case LeaveLast: {
                base = new CroppedInventory(base, 0, 1);
                break;
            }
            case LeaveFirstAndLast: {
                base = new CroppedInventory(base, 1, 1);
                break;
            }
            case Leave1PerStack: {
                return SimpleServiceLocator.inventoryUtilFactory.getOneHiddenInventoryUtil(base);
            }
        }
        return SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(base);
    }

    @Override
    public int getCenterTexture() {
        return core_LogisticsPipes.LOGISTICSPIPE_PROVIDER_TEXTURE;
    }

    @Override
    public int getAvailableItemCount(ItemIdentifier item) {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.getTotalItemCount(item) - this._orderManager.totalItemsCountInOrders(item);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this._orderManager.hasOrders() || this.worldObj.o() % 6L != 0L) {
            return;
        }
        LogisticsRequest order = this._orderManager.getNextRequest();
        int sent = this.sendItem(order.getItem(), order.numberLeft(), order.getDestination().getRouter().getId());
        if (sent > 0) {
            this._orderManager.sendSuccessfull(sent);
        } else {
            this._orderManager.sendFailed();
        }
    }

    @Override
    public void canProvide(LogisticsTransaction transaction) {
        if (!this.isEnabled()) {
            return;
        }
        HashMap commited = transaction.getTotalPromised(this);
        for (LogisticsRequest request : transaction.getRemainingRequests()) {
            int canProvide = this.getAvailableItemCount(request.getItem());
            if (commited.containsKey(request.getItem())) {
                canProvide -= ((Integer)commited.get(request.getItem())).intValue();
            }
            if (canProvide < 1) continue;
            LogisticsPromise promise = new LogisticsPromise();
            promise.item = request.getItem();
            promise.numberOfItems = Math.min(canProvide, request.notYetAllocated());
            promise.sender = this;
            request.addPromise(promise);
            commited = transaction.getTotalPromised(this);
        }
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        this._orderManager.addOrder(new LogisticsRequest(promise.item, promise.numberOfItems, destination));
    }

    @Override
    public HashMap getAllItems() {
        LogicProvider providerLogic = (LogicProvider)this.logic;
        HashMap allItems = new HashMap();
        if (!this.isEnabled()) {
            return allItems;
        }
        for (Orientations o : Orientations.values()) {
            Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, o);
            p.moveForwards(1.0);
            qj tile = this.worldObj.b((int)p.x, (int)p.y, (int)p.z);
            if (!(tile instanceof ni) || tile instanceof TileGenericPipe) continue;
            InventoryUtil inv = this.getAdaptedInventoryUtil((ni)tile);
            HashMap currentInv = inv.getItemsAndCount();
            for (ItemIdentifier currItem : currentInv.keySet()) {
                if (providerLogic.hasFilter() && (providerLogic.isExcludeFilter() && providerLogic.itemIsFiltered(currItem) || !providerLogic.isExcludeFilter() && !providerLogic.itemIsFiltered(currItem))) continue;
                if (!allItems.containsKey(currItem)) {
                    allItems.put(currItem, currentInv.get(currItem));
                    continue;
                }
                allItems.put(currItem, (Integer)allItems.get(currItem) + (Integer)currentInv.get(currItem));
            }
        }
        Iterator iterator = allItems.keySet().iterator();
        while (iterator.hasNext()) {
            ItemIdentifier item = (ItemIdentifier)iterator.next();
            int remaining = (Integer)allItems.get(item) - this._orderManager.totalItemsCountInOrders(item);
            if (remaining < 1) {
                iterator.remove();
                continue;
            }
            allItems.put(item, remaining);
        }
        return allItems;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }
}

