/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.pipes;

import buildcraft.api.BuildCraftAPI;
import buildcraft.api.ILiquidContainer;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.LogicLiquidSupplier;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;

public class PipeItemsLiquidSupplier
extends RoutedPipe
implements IRequestItems,
IItemTravelingHook {
    public PipeItemsLiquidSupplier(int itemID) {
        super(new LogicLiquidSupplier(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
    }

    @Override
    public int getCenterTexture() {
        return mod_LogisticsPipes.LOGISTICSPIPE_LIQUIDSUPPLIER_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    public void endReached(PipeTransportItems pipe, EntityData data, qj tile) {
        if (!(tile instanceof ILiquidContainer)) {
            return;
        }
        if (tile instanceof TileGenericPipe) {
            return;
        }
        ILiquidContainer container = (ILiquidContainer)tile;
        container.getLiquidSlots()[0].getLiquidQty();
        if (data.item == null) {
            return;
        }
        if (data.item.item == null) {
            return;
        }
        int liquidId = BuildCraftAPI.getLiquidForFilledItem((kp)data.item.item);
        if (liquidId == 0) {
            return;
        }
        while (data.item.item.a > 0 && container.fill(data.orientation.reverse(), 1000, liquidId, false) == 1000) {
            id item;
            container.fill(data.orientation.reverse(), 1000, liquidId, true);
            --data.item.item.a;
            if (data.item.item.c < 0 || data.item.item.c >= id.d.length || !(item = id.d[data.item.item.c]).k()) continue;
            id containerItem = item.j();
            IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(new kp(containerItem, 1), this.worldObj);
            itemToSend.setSource(this.getRouter().getId());
            this.queueRoutedItem(itemToSend, data.orientation);
        }
        if (data.item.item.a < 1) {
            ((PipeTransportItems)this.transport).scheduleRemoval(data.item);
        }
    }

    public void drop(PipeTransportItems pipe, EntityData data) {
    }

    public void centerReached(PipeTransportItems pipe, EntityData data) {
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }
}

