/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.pipes;

import buildcraft.api.APIProxy;
import buildcraft.api.EntityPassiveItem;
import buildcraft.api.ISpecialInventory;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.core.CoreProxy;
import buildcraft.core.Utils;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.CraftingTemplate;
import buildcraft.krapht.ICraftItems;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.LogisticsOrderManager;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.LogisticsTransaction;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.LogicCrafting;
import buildcraft.krapht.network.PacketCoordinates;
import buildcraft.krapht.pipes.PipeItemsCraftingLogisticsMk2;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.blocks.LogisticsTileEntiy;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import java.util.LinkedList;
import krapht.AdjacentTile;
import krapht.InventoryUtil;
import krapht.ItemIdentifier;
import krapht.ItemIdentifierStack;
import krapht.WorldUtil;

public class PipeItemsCraftingLogistics
extends RoutedPipe
implements ICraftItems {
    protected LogisticsOrderManager _orderManager = new LogisticsOrderManager();
    protected int _extras;
    private boolean init = false;

    public PipeItemsCraftingLogistics(int itemID) {
        super(new LogicCrafting(), itemID);
    }

    protected LinkedList locateCrafters() {
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        LinkedList<AdjacentTile> crafters = new LinkedList<AdjacentTile>();
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities()) {
            if (tile.tile instanceof TileGenericPipe || !(tile.tile instanceof ni)) continue;
            crafters.add(tile);
        }
        return crafters;
    }

    protected kp extractFromISpecialInventory(ISpecialInventory inv) {
        return inv.extractItem(true, Orientations.Unknown);
    }

    protected kp extractFromIInventory(ni inv) {
        InventoryUtil invUtil = new InventoryUtil(inv, false);
        LogicCrafting craftingLogic = (LogicCrafting)this.logic;
        kp itemstack = craftingLogic.getCraftedItem();
        if (itemstack == null) {
            return null;
        }
        ItemIdentifierStack targetItemStack = ItemIdentifierStack.GetFromStack(itemstack);
        return invUtil.getSingleItem(targetItemStack.getItem());
    }

    public void enableUpdateRequest() {
        this.init = false;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.init) {
            this.init = true;
            if (APIProxy.isRemote()) {
                CoreProxy.sendToServer((lx)new PacketCoordinates(34, this.xCoord, this.yCoord, this.zCoord).getPacket());
            }
        }
        if (this instanceof PipeItemsCraftingLogisticsMk2) {
            return;
        }
        if (!this._orderManager.hasOrders() && this._extras < 1 || this.worldObj.o() % 6L != 0L) {
            return;
        }
        LinkedList crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            this._orderManager.sendFailed();
            return;
        }
        for (AdjacentTile tile : this.locateCrafters()) {
            kp extracted = null;
            if (tile.tile instanceof ISpecialInventory) {
                extracted = this.extractFromISpecialInventory((ISpecialInventory)tile.tile);
            } else if (tile.tile instanceof ni) {
                extracted = this.extractFromIInventory((ni)tile.tile);
            }
            if (extracted == null) continue;
            while (extracted.a > 0) {
                kp stackToSend = extracted.a(1);
                Position p = new Position((double)tile.tile.l, (double)tile.tile.m, (double)tile.tile.n, tile.orientation);
                if (this._orderManager.hasOrders()) {
                    LogisticsRequest order = this._orderManager.getNextRequest();
                    IRoutedItem item = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stackToSend, this.worldObj);
                    item.setSource(this.getRouter().getId());
                    item.setDestination(order.getDestination().getRouter().getId());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    super.queueRoutedItem(item, tile.orientation);
                    this._orderManager.sendSuccessfull(1);
                    continue;
                }
                --this._extras;
                if (mod_LogisticsPipes.DisplayRequests) {
                    System.out.println("Extra dropped, " + this._extras + " remaining");
                }
                Position entityPos = new Position(p.x + 0.5, p.y + (double)Utils.getPipeFloorOf((kp)stackToSend), p.z + 0.5, p.orientation.reverse());
                entityPos.moveForwards(0.5);
                EntityPassiveItem entityItem = new EntityPassiveItem(this.worldObj, entityPos.x, entityPos.y, entityPos.z, stackToSend);
                entityItem.speed = Utils.pipeNormalSpeed * 10.0f;
                ((PipeTransportItems)this.transport).entityEntering(entityItem, entityPos.orientation);
            }
        }
    }

    private ItemIdentifier providedItem() {
        LogicCrafting craftingLogic = (LogicCrafting)this.logic;
        kp stack = craftingLogic.getCraftedItem();
        if (stack == null) {
            return null;
        }
        return ItemIdentifier.get(stack);
    }

    @Override
    public int getCenterTexture() {
        return core_LogisticsPipes.LOGISTICSPIPE_CRAFTER_TEXTURE;
    }

    @Override
    public void canProvide(LogisticsTransaction transaction) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._extras < 1) {
            return;
        }
        for (LogisticsRequest request : transaction.getRemainingRequests()) {
            int alreadyPromised;
            ItemIdentifier providedItem = this.providedItem();
            if (request.getItem() != providedItem) continue;
            HashMap promised = transaction.getTotalPromised(this);
            int n = alreadyPromised = promised.containsKey(providedItem) ? (Integer)promised.get(providedItem) : 0;
            if (alreadyPromised >= this._extras) continue;
            int remaining = this._extras - alreadyPromised;
            LogisticsPromise promise = new LogisticsPromise();
            promise.item = providedItem;
            promise.numberOfItems = Math.min(remaining, request.notYetAllocated());
            promise.sender = this;
            promise.extra = true;
            request.addPromise(promise);
        }
    }

    @Override
    public void canCraft(LogisticsTransaction transaction) {
        if (!this.isEnabled()) {
            return;
        }
        LogicCrafting craftingLogic = (LogicCrafting)this.logic;
        kp stack = craftingLogic.getCraftedItem();
        if (stack == null) {
            return;
        }
        CraftingTemplate template = new CraftingTemplate(ItemIdentifierStack.GetFromStack(stack), this);
        boolean hasSatellite = craftingLogic.isSatelliteConnected();
        for (int i = 0; i < 9; ++i) {
            kp resourceStack = craftingLogic.getMaterials(i);
            if (resourceStack == null || resourceStack.a == 0) continue;
            if (i < 6 || !hasSatellite) {
                template.addRequirement(ItemIdentifierStack.GetFromStack(resourceStack), this);
                continue;
            }
            template.addRequirement(ItemIdentifierStack.GetFromStack(resourceStack), craftingLogic.getSatelliteRouter().getPipe());
        }
        transaction.addCraftingTemplate(template);
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        if (promise.extra) {
            this._extras -= promise.numberOfItems;
        }
        this._orderManager.addOrder(new LogisticsRequest(promise.item, promise.numberOfItems, destination));
    }

    @Override
    public int getAvailableItemCount(ItemIdentifier item) {
        return 0;
    }

    @Override
    public void registerExtras(int count) {
        this._extras += count;
        if (mod_LogisticsPipes.DisplayRequests) {
            System.out.println(count + " extras registered");
        }
    }

    @Override
    public HashMap getAllItems() {
        return new HashMap();
    }

    @Override
    public ItemIdentifier getCraftedItem() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.providedItem();
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    public boolean isAttachedSign(qj entity) {
        return entity.l == ((LogicCrafting)this.logic).signEntityX && entity.m == ((LogicCrafting)this.logic).signEntityY && entity.n == ((LogicCrafting)this.logic).signEntityZ;
    }

    public void addSign(LogisticsTileEntiy entity) {
        if (((LogicCrafting)this.logic).signEntityX == 0 && ((LogicCrafting)this.logic).signEntityY == 0 && ((LogicCrafting)this.logic).signEntityZ == 0) {
            ((LogicCrafting)this.logic).signEntityX = entity.l;
            ((LogicCrafting)this.logic).signEntityY = entity.m;
            ((LogicCrafting)this.logic).signEntityZ = entity.n;
        }
    }

    public boolean canRegisterSign() {
        return ((LogicCrafting)this.logic).signEntityX == 0 && ((LogicCrafting)this.logic).signEntityY == 0 && ((LogicCrafting)this.logic).signEntityZ == 0;
    }

    public void removeRegisteredSign() {
        ((LogicCrafting)this.logic).signEntityX = 0;
        ((LogicCrafting)this.logic).signEntityY = 0;
        ((LogicCrafting)this.logic).signEntityZ = 0;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }
}

