/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.network;

import buildcraft.api.EntityPassiveItem;
import buildcraft.api.Orientations;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketPipeTransportContent;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.routing.RoutedEntityItem;
import buildcraft.krapht.routing.Router;
import buildcraft.krapht.routing.RouterManager;
import buildcraft.transport.TileGenericPipe;
import java.util.UUID;

public class PacketPipeLogisticsContent
extends PacketPipeTransportContent {
    public PacketPipeLogisticsContent() {
    }

    public PacketPipeLogisticsContent(PacketPipeTransportContent packet) {
        this.payload = packet.payload;
        this.posX = packet.posX;
        this.posY = packet.posY;
        this.posZ = packet.posZ;
    }

    public PacketPipeLogisticsContent(int x, int y, int z, RoutedEntityItem item, Orientations orientation) {
        super(x, y, z, (EntityPassiveItem)item, orientation);
        Router routerSource = RouterManager.get(item.getSource());
        Router routerDest = RouterManager.get(item.getDestination());
        if (routerDest == null) {
            return;
        }
        CoreRoutedPipe pipeSource = routerSource != null ? routerSource.getPipe() : null;
        CoreRoutedPipe pipeDest = routerDest.getPipe();
        if (pipeDest == null) {
            return;
        }
        PacketPayload additions = new PacketPayload(6, 0, 0);
        if (pipeSource != null) {
            additions.intPayload[0] = pipeSource.xCoord;
            additions.intPayload[1] = pipeSource.yCoord;
            additions.intPayload[2] = pipeSource.zCoord;
        }
        additions.intPayload[3] = pipeDest.xCoord;
        additions.intPayload[4] = pipeDest.yCoord;
        additions.intPayload[5] = pipeDest.zCoord;
        if (this.payload == null) {
            this.payload = new PacketPayload(6, 4, 0);
            this.payload.intPayload[0] = item.entityId;
            this.payload.intPayload[1] = orientation.ordinal();
            this.payload.intPayload[2] = item.item.c;
            this.payload.intPayload[3] = item.item.a;
            this.payload.intPayload[4] = item.item.h();
            this.payload.intPayload[5] = item.deterministicRandomization;
            this.payload.floatPayload[0] = (float)item.posX;
            this.payload.floatPayload[1] = (float)item.posY;
            this.payload.floatPayload[2] = (float)item.posZ;
            this.payload.floatPayload[3] = item.speed;
        }
        this.payload.append(additions);
    }

    public static boolean isPacket(PacketPipeTransportContent packet) {
        return packet.payload.intPayload.length >= 12;
    }

    public UUID getSourceUUID(ge world) {
        if (this.payload.intPayload.length < 12) {
            return null;
        }
        TileGenericPipe tile = this.getPipe(world, this.payload.intPayload[6], this.payload.intPayload[7], this.payload.intPayload[8]);
        if (tile != null && tile.pipe instanceof CoreRoutedPipe) {
            return ((CoreRoutedPipe)tile.pipe).getRouter().getId();
        }
        return null;
    }

    public UUID getDestUUID(ge world) {
        if (this.payload.intPayload.length < 12) {
            return null;
        }
        TileGenericPipe tile = this.getPipe(world, this.payload.intPayload[9], this.payload.intPayload[10], this.payload.intPayload[11]);
        if (tile != null && tile.pipe instanceof CoreRoutedPipe) {
            return ((CoreRoutedPipe)tile.pipe).getRouter().getId();
        }
        return null;
    }

    private TileGenericPipe getPipe(ge world, int x, int y, int z) {
        if (!world.i(x, y, z)) {
            return null;
        }
        qj tile = world.b(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }
}

