/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logic;

import buildcraft.api.APIProxy;
import buildcraft.core.CoreProxy;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.krapht.logic.BaseRoutingLogic;
import buildcraft.krapht.network.PacketPipeInteger;
import buildcraft.logisticspipes.ExtractionMode;
import krapht.InventoryUtil;
import krapht.InventoryUtilFactory;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;

public class LogicProvider
extends BaseRoutingLogic {
    private SimpleInventory dummyInventory = new SimpleInventory(9, "Items to provide (or empty for all)", 1);
    private boolean _filterIsExclude;
    private ExtractionMode _extractionMode = ExtractionMode.Normal;
    private final InventoryUtilFactory _invUtilFactory;
    private final InventoryUtil _dummyInvUtil;

    public LogicProvider() {
        this(new InventoryUtilFactory());
    }

    public LogicProvider(InventoryUtilFactory invUtilFactory) {
        this._invUtilFactory = invUtilFactory;
        this._dummyInvUtil = this._invUtilFactory.getInventoryUtil(this.dummyInventory);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onWrenchClicked(ih entityplayer) {
        if (!APIProxy.isClient((ge)entityplayer.bi)) {
            entityplayer.openGui((BaseMod)mod_LogisticsPipes.instance, 12, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            CoreProxy.sendToPlayer((ih)entityplayer, (BuildCraftPacket)new PacketPipeInteger(20, this.xCoord, this.yCoord, this.zCoord, this.getExtractionMode().ordinal()));
            CoreProxy.sendToPlayer((ih)entityplayer, (BuildCraftPacket)new PacketPipeInteger(21, this.xCoord, this.yCoord, this.zCoord, this.isExcludeFilter() ? 1 : 0));
        }
    }

    public SimpleInventory getDummyInventory() {
        return this.dummyInventory;
    }

    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._filterIsExclude = nbttagcompound.o("filterisexclude");
        this._extractionMode = ExtractionMode.values()[nbttagcompound.f("extractionMode")];
    }

    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("filterisexclude", this._filterIsExclude);
        nbttagcompound.a("extractionMode", this._extractionMode.ordinal());
    }

    public boolean hasFilter() {
        return this._dummyInvUtil.getItemsAndCount().size() > 0;
    }

    public boolean itemIsFiltered(ItemIdentifier item) {
        return this._dummyInvUtil.getItemsAndCount().containsKey(item);
    }

    public boolean isExcludeFilter() {
        return this._filterIsExclude;
    }

    public void setFilterExcluded(boolean isExcluded) {
        this._filterIsExclude = isExcluded;
    }

    public ExtractionMode getExtractionMode() {
        return this._extractionMode;
    }

    public void nextExtractionMode() {
        this._extractionMode = this._extractionMode.next();
    }
}

