/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logic;

import buildcraft.api.APIProxy;
import buildcraft.api.TileNetworkData;
import buildcraft.core.CoreProxy;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.LogisticsManager;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.BaseLogicSatellite;
import buildcraft.krapht.logic.BaseRoutingLogic;
import buildcraft.krapht.network.PacketCoordinates;
import buildcraft.krapht.recipeproviders.ICraftingRecipeProvider;
import buildcraft.krapht.routing.IRouter;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import krapht.AdjacentTile;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;
import krapht.WorldUtil;

public abstract class BaseLogicCrafting
extends BaseRoutingLogic
implements IRequireReliableTransport {
    @TileNetworkData
    protected final SimpleInventory _dummyInventory = new SimpleInventory(10, "Requested items", 127);
    @TileNetworkData
    public int signEntityX = 0;
    @TileNetworkData
    public int signEntityY = 0;
    @TileNetworkData
    public int signEntityZ = 0;
    protected final LinkedList _lostItems = new LinkedList();
    @TileNetworkData
    public int satelliteId = 0;

    public BaseLogicCrafting() {
        this.throttleTime = 40;
    }

    protected int getNextConnectSatelliteId(boolean prev) {
        HashMap routes = this.getRouter().getRouteTable();
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
            if (!routes.containsKey(satellite.getRouter())) continue;
            if (!prev && satellite.satelliteId > this.satelliteId && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.satelliteId || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            return this.satelliteId;
        }
        return closestIdFound;
    }

    public void setNextSatellite() {
        this.satelliteId = this.getNextConnectSatelliteId(false);
    }

    public void setPrevSatellite() {
        this.satelliteId = this.getNextConnectSatelliteId(true);
    }

    public boolean isSatelliteConnected() {
        for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
            if (satellite.satelliteId != this.satelliteId || !this.getRouter().getRouteTable().containsKey(satellite.getRouter())) continue;
            return true;
        }
        return false;
    }

    public IRouter getSatelliteRouter() {
        for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
            if (satellite.satelliteId != this.satelliteId) continue;
            return satellite.getRouter();
        }
        return null;
    }

    public void readFromNBT(ph nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this._dummyInventory.readFromNBT(nbttagcompound, "");
        this.satelliteId = nbttagcompound.f("satelliteid");
        this.signEntityX = nbttagcompound.f("CraftingSignEntityX");
        this.signEntityY = nbttagcompound.f("CraftingSignEntityY");
        this.signEntityZ = nbttagcompound.f("CraftingSignEntityZ");
    }

    public void writeToNBT(ph nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this._dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("satelliteid", this.satelliteId);
        nbttagcompound.a("CraftingSignEntityX", this.signEntityX);
        nbttagcompound.a("CraftingSignEntityY", this.signEntityY);
        nbttagcompound.a("CraftingSignEntityZ", this.signEntityZ);
    }

    @Override
    public void destroy() {
        if (this.signEntityX != 0 && this.signEntityY != 0 && this.signEntityZ != 0) {
            this.worldObj.e(this.signEntityX, this.signEntityY, this.signEntityZ, 0);
            this.signEntityX = 0;
            this.signEntityY = 0;
            this.signEntityZ = 0;
        }
    }

    @Override
    public void onWrenchClicked(ih entityplayer) {
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        System.out.println("Item lost");
        Iterator iterator = this._lostItems.iterator();
        while (iterator.hasNext()) {
            LogisticsRequest request = new LogisticsRequest((ItemIdentifier)iterator.next(), 1, this.getRoutedPipe());
            if (!LogisticsManager.Request(request, ((RoutedPipe)this.container.pipe).getRouter().getRoutersByCost(), null)) continue;
            iterator.remove();
        }
    }

    @Override
    public void itemArrived(ItemIdentifier item) {
    }

    @Override
    public void itemLost(ItemIdentifier item) {
        this._lostItems.add(item);
    }

    public void openAttachedGui(ih player) {
        if (APIProxy.isRemote()) {
            PacketCoordinates packet = new PacketCoordinates(35, this.xCoord, this.yCoord, this.zCoord);
            CoreProxy.sendToServer((lx)packet.getPacket());
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        boolean found = false;
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities()) {
            vz block;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui(tile.tile)) continue;
                found = true;
                break;
            }
            if (!found) {
                boolean bl = found = tile.tile instanceof ni && !(tile.tile instanceof TileGenericPipe);
            }
            if (!found || (block = this.worldObj.a(tile.tile.l, tile.tile.m, tile.tile.n) < vz.m.length ? vz.m[this.worldObj.a(tile.tile.l, tile.tile.m, tile.tile.n)] : null) == null || !block.a(this.worldObj, tile.tile.l, tile.tile.m, tile.tile.n, player)) continue;
            break;
        }
    }

    public void importFromCraftingTable() {
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities()) {
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.importRecipe(tile.tile, this._dummyInventory)) continue;
                return;
            }
        }
    }

    public kp getCraftedItem() {
        return this._dummyInventory.g_(9);
    }

    public kp getMaterials(int slotnr) {
        return this._dummyInventory.g_(slotnr);
    }

    public SimpleInventory getDummyInventory() {
        return this._dummyInventory;
    }
}

