/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht;

import buildcraft.krapht.CraftingTemplate;
import buildcraft.krapht.IProvideItems;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsRequest;
import java.util.HashMap;
import java.util.LinkedList;
import krapht.ItemIdentifier;

public class LogisticsTransaction {
    private LinkedList _requests = new LinkedList();
    private LinkedList _craftingTemplates = new LinkedList();

    public LogisticsTransaction(LogisticsRequest originalRequest) {
        this._requests.add(originalRequest);
    }

    public LogisticsTransaction() {
    }

    public LinkedList getRequests() {
        return this._requests;
    }

    public void addCraftingTemplate(CraftingTemplate template) {
        this._craftingTemplates.add(template);
    }

    public boolean isDeliverable() {
        boolean allReady = true;
        for (LogisticsRequest request : this._requests) {
            allReady = allReady && request.isReady();
        }
        return allReady;
    }

    public boolean hasCraft(ItemIdentifier item) {
        for (CraftingTemplate template : this._craftingTemplates) {
            if (template.getResultStack().getItem() != item) continue;
            return true;
        }
        return false;
    }

    public LinkedList getCrafts(ItemIdentifier item) {
        LinkedList<CraftingTemplate> templates = new LinkedList<CraftingTemplate>();
        for (CraftingTemplate template : this._craftingTemplates) {
            if (template.getResultStack().getItem() != item) continue;
            templates.add(template);
        }
        return templates;
    }

    public LinkedList getRemainingRequests() {
        LinkedList<LogisticsRequest> ret = new LinkedList<LogisticsRequest>();
        for (LogisticsRequest request : this._requests) {
            if (request.isReady()) continue;
            ret.add(request);
        }
        return ret;
    }

    public HashMap getTotalPromised(IProvideItems sender) {
        HashMap<ItemIdentifier, Integer> ret = new HashMap<ItemIdentifier, Integer>();
        for (LogisticsRequest request : this._requests) {
            for (LogisticsPromise promise : request.getPromises()) {
                if (promise.sender != sender) continue;
                if (!ret.containsKey(promise.item)) {
                    ret.put(promise.item, promise.numberOfItems);
                    continue;
                }
                ret.put(promise.item, (Integer)ret.get(promise.item) + promise.numberOfItems);
            }
        }
        return ret;
    }

    public void addRequest(LogisticsRequest newRequest) {
        if (this._requests.contains(newRequest)) {
            return;
        }
        this._requests.add(newRequest);
    }
}

