/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht;

import buildcraft.krapht.CraftingTemplate;
import buildcraft.krapht.ICraftItems;
import buildcraft.krapht.ILogisticsManager;
import buildcraft.krapht.IProvideItems;
import buildcraft.krapht.ItemMessage;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.LogisticsTransaction;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.pipes.PipeItemsCraftingLogistics;
import buildcraft.krapht.pipes.PipeItemsProviderLogistics;
import buildcraft.krapht.pipes.PipeItemsRequestLogistics;
import buildcraft.krapht.pipes.PipeLogisticsChassi;
import buildcraft.krapht.routing.IRouter;
import buildcraft.krapht.routing.Router;
import buildcraft.logisticspipes.MessageManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import krapht.ItemIdentifier;

public class LogisticsManager
implements ILogisticsManager {
    private static HashMap _logisticsDatabase = new HashMap();
    private static ILogisticsManager _instance = new LogisticsManager();

    public static boolean Request(LogisticsRequest originalRequest, List validDestinations, List errors) {
        return LogisticsManager.Request(originalRequest, validDestinations, errors, null);
    }

    public static boolean Request(LogisticsRequest originalRequest, List validDestinations, List errors, ih player) {
        LogisticsTransaction transaction = new LogisticsTransaction(originalRequest);
        return LogisticsManager.Request(transaction, validDestinations, errors, player);
    }

    public static boolean Request(LogisticsTransaction transaction, List validDestinations, List errors, ih player) {
        return LogisticsManager.Request(transaction, validDestinations, errors, player, true);
    }

    public static boolean Request(LogisticsTransaction transaction, List validDestinations, List errors, ih player, boolean realrequest) {
        for (Router r : validDestinations) {
            if (!(r.getPipe() instanceof ICraftItems)) continue;
            ((ICraftItems)((Object)r.getPipe())).canCraft(transaction);
        }
        boolean added = true;
        while (!transaction.isDeliverable() && added) {
            for (Router r : validDestinations) {
                if (!(r.getPipe() instanceof IProvideItems)) continue;
                ((IProvideItems)((Object)r.getPipe())).canProvide(transaction);
                if (!transaction.isDeliverable()) continue;
                break;
            }
            if (transaction.isDeliverable()) continue;
            added = false;
            block3: for (LogisticsRequest remaining : transaction.getRemainingRequests()) {
                for (LogisticsRequest extras : transaction.getRequests()) {
                    for (LogisticsPromise extraPromise : extras.getExtras()) {
                        if (remaining.isReady() || extraPromise.item != remaining.getItem()) continue;
                        remaining.addPromise(extraPromise);
                        extras.usePromise(extraPromise);
                        added = true;
                    }
                }
                LinkedList possibleCrafts = transaction.getCrafts(remaining.getItem());
                if (possibleCrafts.isEmpty()) continue;
                while (!remaining.isReady()) {
                    for (CraftingTemplate template : possibleCrafts) {
                        int promisedCount;
                        ICraftItems crafter = template.getCrafter();
                        ItemIdentifier ResultItem = template.getResultStack().getItem();
                        HashMap totalPromised = transaction.getTotalPromised(crafter);
                        if (totalPromised.containsKey(ResultItem) && (promisedCount = ((Integer)totalPromised.get(ResultItem)).intValue()) > 800) {
                            if (player == null) continue block3;
                            MessageManager.overflow(player, ResultItem);
                            continue block3;
                        }
                        remaining.addPromise(template.generatePromise());
                        for (LogisticsRequest newRequest : template.generateRequests()) {
                            transaction.addRequest(newRequest);
                            added = true;
                        }
                    }
                }
            }
        }
        if (!transaction.isDeliverable()) {
            if (errors == null) {
                return false;
            }
            HashMap<ItemIdentifier, Integer> remaining = new HashMap<ItemIdentifier, Integer>();
            for (LogisticsRequest request : transaction.getRemainingRequests()) {
                if (!remaining.containsKey(request.getItem())) {
                    remaining.put(request.getItem(), request.notYetAllocated());
                    continue;
                }
                remaining.put(request.getItem(), (Integer)remaining.get(request.getItem()) + request.notYetAllocated());
            }
            for (ItemIdentifier item : remaining.keySet()) {
                errors.add(new ItemMessage(item.itemID, item.itemDamage, (Integer)remaining.get(item), item.tag));
            }
            return false;
        }
        if (!realrequest) {
            return true;
        }
        if (transaction.getRequests().getFirst() != null && mod_LogisticsPipes.DisplayRequests) {
            System.out.println("*** START REQUEST FOR " + ((LogisticsRequest)transaction.getRequests().getFirst()).numberLeft() + " " + ((LogisticsRequest)transaction.getRequests().getFirst()).getItem().getFriendlyName() + " ***");
        }
        for (LogisticsRequest request : transaction.getRequests()) {
            if (mod_LogisticsPipes.DisplayRequests) {
                System.out.println("\tRequest for " + request.numberLeft() + " " + request.getItem().getFriendlyName());
            }
            for (LogisticsPromise promise : request.getPromises()) {
                promise.sender.fullFill(promise, request.getDestination());
                if (mod_LogisticsPipes.DisplayRequests) {
                    System.out.println("\t\t" + LogisticsManager.getBetterRouterName(promise.sender.getRouter()) + "\tSENDING " + promise.numberOfItems + " " + promise.item.getFriendlyName() + " to " + LogisticsManager.getBetterRouterName(request.getDestination().getRouter()));
                }
                if (!promise.extra || !mod_LogisticsPipes.DisplayRequests) continue;
                System.out.println("\t\t\t--Used extras from previous request");
            }
            for (LogisticsPromise promise : request.getExtras()) {
                if (mod_LogisticsPipes.DisplayRequests) {
                    System.out.println("\t\t\t--EXTRAS: " + promise.numberOfItems + " " + promise.item.getFriendlyName());
                }
                ((ICraftItems)promise.sender).registerExtras(promise.numberOfItems);
            }
        }
        if (mod_LogisticsPipes.DisplayRequests) {
            System.out.println("*** END REQUEST ***");
        }
        return true;
    }

    public static String getBetterRouterName(IRouter r) {
        RoutedPipe pipe;
        if (r.getPipe() instanceof PipeItemsCraftingLogistics && ((PipeItemsCraftingLogistics)(pipe = (PipeItemsCraftingLogistics)r.getPipe())).getCraftedItem() != null) {
            return "Crafter<" + ((PipeItemsCraftingLogistics)pipe).getCraftedItem().getFriendlyName() + ">";
        }
        if (r.getPipe() instanceof PipeItemsProviderLogistics) {
            pipe = (PipeItemsProviderLogistics)r.getPipe();
            return "Provider";
        }
        if (r.getPipe() instanceof PipeLogisticsChassi) {
            return "Chassis";
        }
        if (r.getPipe() instanceof PipeItemsRequestLogistics) {
            return "Request";
        }
        return r.getId().toString();
    }

    @Override
    public HashMap getAvailableItems(Set validDestinations) {
        HashMap allAvailableItems = new HashMap();
        for (Router r : validDestinations) {
            if (!(r.getPipe() instanceof IProvideItems)) continue;
            IProvideItems provider = (IProvideItems)((Object)r.getPipe());
            HashMap allItems = provider.getAllItems();
            for (ItemIdentifier item : allItems.keySet()) {
                if (!allAvailableItems.containsKey(item)) {
                    allAvailableItems.put(item, allItems.get(item));
                    continue;
                }
                allAvailableItems.put(item, (Integer)allAvailableItems.get(item) + (Integer)allItems.get(item));
            }
        }
        return allAvailableItems;
    }

    @Override
    public LinkedList getCraftableItems(Set validDestinations) {
        LinkedList<ItemIdentifier> craftableItems = new LinkedList<ItemIdentifier>();
        for (Router r : validDestinations) {
            ICraftItems crafter;
            ItemIdentifier craftedItem;
            if (!(r.getPipe() instanceof ICraftItems) || (craftedItem = (crafter = (ICraftItems)((Object)r.getPipe())).getCraftedItem()) == null) continue;
            craftableItems.add(craftedItem);
        }
        return craftableItems;
    }

    private class LogisticsValue {
        int TotalThisCycle = 0;
        int CompletedThisCycle = 0;
        float cycleCompletedFraction;

        public LogisticsValue(int TotalToDeliver) {
            this.TotalThisCycle = TotalToDeliver;
            this.recalc();
        }

        public void deliverItem() {
            ++this.CompletedThisCycle;
            this.recalc();
        }

        public void setCompleted() {
            this.CompletedThisCycle = this.TotalThisCycle;
            this.recalc();
        }

        private void recalc() {
            this.cycleCompletedFraction = this.TotalThisCycle == 0 ? 1.0f : 1.0f / (float)this.TotalThisCycle * (float)this.CompletedThisCycle;
        }
    }
}

