/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht;

import buildcraft.krapht.ICraftItems;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.LogisticsPromise;
import buildcraft.krapht.LogisticsRequest;
import java.util.HashMap;
import java.util.LinkedList;
import krapht.ItemIdentifierStack;

public class CraftingTemplate {
    private ItemIdentifierStack _result;
    private ICraftItems _crafter;
    private HashMap _required = new HashMap();

    public CraftingTemplate(ItemIdentifierStack result, ICraftItems crafter) {
        this._result = result;
        this._crafter = crafter;
    }

    public void addRequirement(ItemIdentifierStack stack, IRequestItems crafter) {
        this._required.put(stack, crafter);
    }

    public LogisticsPromise generatePromise() {
        LogisticsPromise promise = new LogisticsPromise();
        promise.item = this._result.getItem();
        promise.numberOfItems = this._result.stackSize;
        promise.sender = this._crafter;
        return promise;
    }

    public LinkedList generateRequests() {
        LinkedList<LogisticsRequest> requests = new LinkedList<LogisticsRequest>();
        for (ItemIdentifierStack stack : this._required.keySet()) {
            requests.add(new LogisticsRequest(stack.getItem(), stack.stackSize, (IRequestItems)this._required.get(stack)));
        }
        return requests;
    }

    public ItemIdentifierStack getResultStack() {
        return this._result;
    }

    public ICraftItems getCrafter() {
        return this._crafter;
    }
}

