/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.api.ISpecialInventory;
import buildcraft.api.Orientations;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.SidedInventoryAdapter;
import buildcraft.logisticspipes.modules.IClientInformationProvider;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.ISneakyOrientationreceiver;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;
import buildcraft.logisticspipes.modules.SneakyOrientation;
import forge.ISidedInventory;
import java.util.ArrayList;
import java.util.List;

public class ModuleExtractor
implements ILogisticsModule,
ISneakyOrientationreceiver,
IClientInformationProvider {
    private int currentTick = 0;
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private SneakyOrientation _sneakyOrientation = SneakyOrientation.Default;

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
    }

    protected int ticksToAction() {
        return 100;
    }

    protected int itemsToExtract() {
        return 1;
    }

    @Override
    public SneakyOrientation getSneakyOrientation() {
        return this._sneakyOrientation;
    }

    @Override
    public void setSneakyOrientation(SneakyOrientation sneakyOrientation) {
        this._sneakyOrientation = sneakyOrientation;
    }

    @Override
    public SinkReply sinksItem(aan item) {
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 20;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(ady nbttagcompound, String prefix) {
        this._sneakyOrientation = SneakyOrientation.values()[nbttagcompound.f("sneakyorientation")];
    }

    @Override
    public void writeToNBT(ady nbttagcompound, String prefix) {
        nbttagcompound.a("sneakyorientation", this._sneakyOrientation.ordinal());
    }

    @Override
    public void tick() {
        Orientations extractOrientation;
        if (++this.currentTick < this.ticksToAction()) {
            return;
        }
        this.currentTick = 0;
        io targetInventory = this._invProvider.getRawInventory();
        if (targetInventory == null) {
            return;
        }
        switch (this._sneakyOrientation) {
            case Bottom: {
                extractOrientation = Orientations.YNeg;
                break;
            }
            case Top: {
                extractOrientation = Orientations.YPos;
                break;
            }
            case Side: {
                extractOrientation = Orientations.ZPos;
                break;
            }
            default: {
                extractOrientation = this._invProvider.inventoryOrientation().reverse();
            }
        }
        if (targetInventory instanceof ISpecialInventory) {
            aan stack = ((ISpecialInventory)targetInventory).extractItem(false, extractOrientation);
            if (stack == null) {
                return;
            }
            if (!this.shouldSend(stack)) {
                return;
            }
            stack = ((ISpecialInventory)targetInventory).extractItem(true, extractOrientation);
            this._itemSender.sendStack(stack);
            return;
        }
        if (targetInventory instanceof ISidedInventory) {
            targetInventory = new SidedInventoryAdapter((ISidedInventory)targetInventory, extractOrientation);
        }
        for (int i = 0; i < targetInventory.a(); ++i) {
            aan stackToSend = targetInventory.k_(i);
            if (stackToSend == null || !this.shouldSend(stackToSend)) continue;
            stackToSend = targetInventory.a(i, this.itemsToExtract());
            this._itemSender.sendStack(stackToSend);
            break;
        }
    }

    protected boolean shouldSend(aan stack) {
        return SimpleServiceLocator.logisticsManager.hasDestination(stack, true, this._itemSender.getSourceUUID(), true);
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Extraction: " + this._sneakyOrientation.name());
        return list;
    }
}

