/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes.modules;

import buildcraft.api.APIProxy;
import buildcraft.core.CoreProxy;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.network.PacketPipeFourInteger;
import buildcraft.logisticspipes.modules.GuiWithPreviousGuiContainer;
import buildcraft.logisticspipes.modules.ModuleApiaristSink;
import buildcraft.transport.Pipe;
import krapht.gui.BasicGuiHelper;
import krapht.gui.DummyContainer;
import krapht.gui.IItemTextureRenderSlot;
import krapht.gui.ISmallColorRenderSlot;
import net.minecraft.client.Minecraft;

public class GuiApiaristSink
extends GuiWithPreviousGuiContainer {
    private final ModuleApiaristSink module;
    private final yw player;
    private int slot;

    public GuiApiaristSink(ModuleApiaristSink module, yw player, Pipe pipe, vp previousGui, int slot) {
        super(new DummyContainer((io)player.ap, null), pipe, previousGui);
        this.module = module;
        this.player = player;
        this.slot = slot;
        for (int i = 0; i < 6; ++i) {
            ModuleApiaristSink.SinkSetting filter = module.filter[i];
            this.addRenderSlot(new TypeSlot(20, 20 + i * 18, filter, i, this));
            this.addRenderSlot(new GroupSlot(this.e + 45, this.f + 25 + i * 18, filter, i, this));
            this.addRenderSlot(new BeeSlot(60, 20 + i * 18, filter, 0, i, this));
            this.addRenderSlot(new BeeSlot(78, 20 + i * 18, filter, 1, i, this));
        }
        this.b = 120;
        this.c = 150;
    }

    @Override
    protected void a(float var1, int var2, int var3) {
        BasicGuiHelper.drawGuiBackGround(this.p, this.e, this.f, this.right, this.bottom, this.g);
    }

    @Override
    public int getGuiID() {
        return 28;
    }

    private class BeeSlot
    extends IItemTextureRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int slotNumber;
        private final int row;
        private final GuiApiaristSink gui;

        private BeeSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int slotNumber, int row, GuiApiaristSink guiApiaristSink2) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.slotNumber = slotNumber;
            this.row = row;
            this.gui = guiApiaristSink2;
        }

        @Override
        public int getTextureId() {
            return 0;
        }

        @Override
        public String getTextureFile() {
            return "/gfx/forestry/items/bees.png";
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeReset();
                } else {
                    this.setting.secondBeeReset();
                }
            }
            if (button == 0) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeUp();
                } else {
                    this.setting.secondBeeUp();
                }
            }
            if (button == 1) {
                if (this.slotNumber == 0) {
                    this.setting.firstBeeDown();
                } else {
                    this.setting.secondBeeDown();
                }
            }
            if (APIProxy.isRemote()) {
                PacketPipeFourInteger packet = new PacketPipeFourInteger(43, GuiApiaristSink.this.pipe.xCoord, GuiApiaristSink.this.pipe.yCoord, GuiApiaristSink.this.pipe.zCoord, this.gui.slot, this.row, this.slotNumber, this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee);
                CoreProxy.sendToServer((abs)packet.getPacket());
            }
        }

        @Override
        public boolean drawSlotBackground() {
            return this.setting.filterType.secondSlots > this.slotNumber;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public boolean drawSlotIcon() {
            return this.drawSlotBackground() && (this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee) != -1;
        }

        @Override
        public String getToolTipText() {
            return SimpleServiceLocator.forestryProxy.getAlleleName(this.slotNumber == 0 ? this.setting.firstBee : this.setting.secondBee);
        }

        @Override
        public boolean displayToolTip() {
            if (this.slotNumber == 0) {
                return this.setting.firstBee != -1 && this.drawSlotBackground();
            }
            return this.setting.secondBee != -1 && this.drawSlotBackground();
        }

        @Override
        public boolean customRender(Minecraft mc, float zLevel) {
            if (this.slotNumber == 0) {
                BasicGuiHelper.renderForestryBeeAt(mc, this.xPos + 1, this.yPos + 1, zLevel, this.setting.firstBee);
            } else {
                BasicGuiHelper.renderForestryBeeAt(mc, this.xPos + 1, this.yPos + 1, zLevel, this.setting.secondBee);
            }
            return true;
        }
    }

    private class GroupSlot
    extends ISmallColorRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int row;
        private final GuiApiaristSink gui;

        private GroupSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int row, GuiApiaristSink guiApiaristSink2) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.row = row;
            this.gui = guiApiaristSink2;
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                this.setting.filterGroupReset();
            }
            if (button == 0) {
                this.setting.filterGroupUp();
            }
            if (button == 1) {
                this.setting.filterGroupDown();
            }
            if (APIProxy.isRemote()) {
                PacketPipeFourInteger packet = new PacketPipeFourInteger(43, GuiApiaristSink.this.pipe.xCoord, GuiApiaristSink.this.pipe.yCoord, GuiApiaristSink.this.pipe.zCoord, this.gui.slot, this.row, 2, this.setting.filterGroup);
                CoreProxy.sendToServer((abs)packet.getPacket());
            }
        }

        @Override
        public boolean drawSlotBackground() {
            return this.setting.filterType != ModuleApiaristSink.FilterType.Null;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public String getToolTipText() {
            switch (this.setting.filterGroup) {
                case 1: {
                    return "GroupColor: Red";
                }
                case 2: {
                    return "GroupColor: Green";
                }
                case 3: {
                    return "GroupColor: Blue";
                }
                case 4: {
                    return "GroupColor: Yellow";
                }
                case 5: {
                    return "GroupColor: Cyan";
                }
                case 6: {
                    return "GroupColor: Purple";
                }
            }
            return "No Group";
        }

        @Override
        public boolean displayToolTip() {
            return this.drawSlotBackground();
        }

        @Override
        public int getColor() {
            switch (this.setting.filterGroup) {
                case 1: {
                    return -65536;
                }
                case 2: {
                    return -16711936;
                }
                case 3: {
                    return -16776961;
                }
                case 4: {
                    return -256;
                }
                case 5: {
                    return -16711681;
                }
                case 6: {
                    return -65281;
                }
            }
            return 0;
        }

        @Override
        public boolean drawColor() {
            return this.drawSlotBackground();
        }
    }

    private class TypeSlot
    extends IItemTextureRenderSlot {
        private final int xPos;
        private final int yPos;
        private final ModuleApiaristSink.SinkSetting setting;
        private final int row;
        private final GuiApiaristSink gui;

        private TypeSlot(int xPos, int yPos, ModuleApiaristSink.SinkSetting setting, int row, GuiApiaristSink guiApiaristSink2) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.setting = setting;
            this.row = row;
            this.gui = guiApiaristSink2;
        }

        @Override
        public int getTextureId() {
            if (this.setting.filterType == null) {
                return 0;
            }
            return this.setting.filterType.icon;
        }

        @Override
        public String getTextureFile() {
            return "/gfx/forestry/gui/analyzer_icons.png";
        }

        @Override
        public void mouseClicked(int button) {
            if (button == 2) {
                this.setting.FilterTypeReset();
            }
            if (button == 0) {
                this.setting.FilterTypeUp();
            }
            if (button == 1) {
                this.setting.FilterTypeDown();
            }
            if (APIProxy.isRemote()) {
                PacketPipeFourInteger packet = new PacketPipeFourInteger(43, GuiApiaristSink.this.pipe.xCoord, GuiApiaristSink.this.pipe.yCoord, GuiApiaristSink.this.pipe.zCoord, this.gui.slot, this.row, 3, this.setting.filterType.ordinal());
                CoreProxy.sendToServer((abs)packet.getPacket());
            }
        }

        @Override
        public boolean drawSlotBackground() {
            return true;
        }

        @Override
        public int getXPos() {
            return this.xPos;
        }

        @Override
        public int getYPos() {
            return this.yPos;
        }

        @Override
        public boolean drawSlotIcon() {
            return true;
        }

        @Override
        public String getToolTipText() {
            if (this.setting.filterType == null) {
                return "";
            }
            return SimpleServiceLocator.forestryProxy.getForestryTranslation(this.setting.filterType.path);
        }

        @Override
        public boolean displayToolTip() {
            return this.setting.filterType != ModuleApiaristSink.FilterType.Null;
        }

        @Override
        public boolean customRender(Minecraft mc, float zLevel) {
            return false;
        }
    }
}

