/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes;

import buildcraft.api.Orientations;
import buildcraft.krapht.routing.IRouter;
import buildcraft.krapht.routing.RoutedEntityItem;
import buildcraft.logisticspipes.IAdjacentWorldAccess;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.ITrackStatistics;
import buildcraft.logisticspipes.TransportLayer;
import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import krapht.AdjacentTile;

public class PipeTransportLayer
extends TransportLayer {
    private final IAdjacentWorldAccess _worldAccess;
    private final ITrackStatistics _trackStatistics;
    private final IRouter _router;

    public PipeTransportLayer(IAdjacentWorldAccess worldAccess, ITrackStatistics trackStatistics, IRouter router) {
        this._worldAccess = worldAccess;
        this._trackStatistics = trackStatistics;
        this._router = router;
    }

    @Override
    public Orientations itemArrived(IRoutedItem item) {
        if (item.getItemStack() != null) {
            this._trackStatistics.recievedItem(item.getItemStack().a);
        }
        item.setArrived();
        this._router.inboundItemArrived((RoutedEntityItem)item);
        LinkedList adjacentEntities = this._worldAccess.getConnectedEntities();
        LinkedList<Orientations> possibleOrientations = new LinkedList<Orientations>();
        for (AdjacentTile tile : adjacentEntities) {
            if (tile.tile instanceof TileGenericPipe) continue;
            possibleOrientations.add(tile.orientation);
        }
        if (possibleOrientations.size() != 0) {
            return (Orientations)possibleOrientations.get(this._worldAccess.getRandomInt(possibleOrientations.size()));
        }
        for (AdjacentTile tile : adjacentEntities) {
            if (this._router.isRoutedExit(tile.orientation)) continue;
            possibleOrientations.add(tile.orientation);
        }
        if (possibleOrientations.size() == 0) {
            return null;
        }
        return (Orientations)possibleOrientations.get(this._worldAccess.getRandomInt(possibleOrientations.size()));
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        return true;
    }
}

