/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.logisticspipes;

import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.pipes.PipeLogisticsChassi;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.SinkReply;
import krapht.InventoryUtil;
import krapht.ItemIdentifier;

public class ChassiModule
implements ILogisticsModule {
    private final ILogisticsModule[] _modules;
    private final PipeLogisticsChassi _parentPipe;

    public ChassiModule(int moduleCount, PipeLogisticsChassi parentPipe) {
        this._modules = new ILogisticsModule[moduleCount];
        this._parentPipe = parentPipe;
    }

    public void installModule(int slot, ILogisticsModule module) {
        this._modules[slot] = module;
    }

    public void removeModule(int slot) {
        this._modules[slot] = null;
    }

    public ILogisticsModule getModule(int slot) {
        return this._modules[slot];
    }

    public boolean hasModule(int slot) {
        return this._modules[slot] != null;
    }

    @Override
    public SinkReply sinksItem(aan item) {
        io inv = this._parentPipe.getInventory();
        if (inv == null) {
            return null;
        }
        InventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
        int roomForItem = invUtil.roomForItem(ItemIdentifier.get(item));
        if (roomForItem < 1) {
            return null;
        }
        for (ILogisticsModule module : this._modules) {
            SinkReply result;
            if (module == null || (result = module.sinksItem(item)) == null) continue;
            result.maxNumberOfItems = roomForItem;
            return result;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 26;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        if (slot < 0 || slot >= this._modules.length) {
            return null;
        }
        return this._modules[slot];
    }

    @Override
    public void readFromNBT(ady nbttagcompound, String prefix) {
        for (int i = 0; i < this._modules.length; ++i) {
            ady slot;
            if (this._modules[i] == null || (slot = nbttagcompound.m("slot" + i)) == null) continue;
            this._modules[i].readFromNBT(slot, "");
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound, String prefix) {
        for (int i = 0; i < this._modules.length; ++i) {
            if (this._modules[i] == null) continue;
            ady slot = new ady();
            this._modules[i].writeToNBT(slot, "");
            nbttagcompound.a("slot" + i, (gh)slot);
        }
    }

    @Override
    public void tick() {
        for (ILogisticsModule module : this._modules) {
            if (module == null) continue;
            module.tick();
        }
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world) {
    }
}

