/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.routing;

import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.routing.ExitRoute;
import buildcraft.krapht.routing.IPaintPath;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsObsidian;
import java.util.HashMap;
import java.util.LinkedList;

class PathFinder {
    private int maxVisited;
    private int maxLength;

    public static HashMap getConnectedRoutingPipes(TileGenericPipe startPipe, int maxVisited, int maxLength) {
        PathFinder newSearch = new PathFinder(maxVisited, maxLength);
        return newSearch.getConnectedRoutingPipes(startPipe, new LinkedList(), null);
    }

    public static HashMap paintAndgetConnectedRoutingPipes(TileGenericPipe startPipe, Orientations startOrientation, int maxVisited, int maxLength, IPaintPath pathPainter) {
        PathFinder newSearch = new PathFinder(maxVisited, maxLength);
        LinkedList<TileGenericPipe> visited = new LinkedList<TileGenericPipe>();
        visited.add(startPipe);
        Position p = new Position((double)startPipe.j, (double)startPipe.k, (double)startPipe.l, startOrientation);
        p.moveForwards(1.0);
        kw entity = startPipe.i.b((int)p.x, (int)p.y, (int)p.z);
        if (!(entity instanceof TileGenericPipe) || !((TileGenericPipe)entity).pipe.isPipeConnected((kw)startPipe)) {
            return new HashMap();
        }
        return newSearch.getConnectedRoutingPipes((TileGenericPipe)entity, visited, pathPainter);
    }

    private PathFinder(int maxVisited, int maxLength) {
        this.maxVisited = maxVisited;
        this.maxLength = maxLength;
    }

    private HashMap getConnectedRoutingPipes(TileGenericPipe startPipe, LinkedList visited, IPaintPath pathPainter) {
        HashMap<RoutedPipe, ExitRoute> foundPipes = new HashMap<RoutedPipe, ExitRoute>();
        if (this.maxVisited-- < 1) {
            return foundPipes;
        }
        if (visited.size() > this.maxLength || visited.contains(startPipe)) {
            return foundPipes;
        }
        if (startPipe.pipe instanceof RoutedPipe && visited.size() != 0) {
            foundPipes.put((RoutedPipe)startPipe.pipe, new ExitRoute(Orientations.Unknown, visited.size()));
            return foundPipes;
        }
        visited.add(startPipe);
        if (startPipe instanceof TileGenericPipe && startPipe.pipe instanceof PipeItemsIron || startPipe.pipe instanceof PipeItemsObsidian) {
            return foundPipes;
        }
        if (startPipe.pipe != null && core_LogisticsPipes.PipeItemTeleport != null && core_LogisticsPipes.teleportPipeDetected && core_LogisticsPipes.PipeItemTeleport.isAssignableFrom(startPipe.pipe.getClass())) {
            try {
                LinkedList pipez = (LinkedList)core_LogisticsPipes.teleportPipeMethod.invoke((Object)startPipe.pipe, false);
                for (Pipe telepipe : pipez) {
                    HashMap result = this.getConnectedRoutingPipes(telepipe.container, (LinkedList)visited.clone(), pathPainter);
                    for (RoutedPipe pipe : result.keySet()) {
                        ((ExitRoute)result.get((Object)pipe)).exitOrientation = Orientations.Unknown;
                        if (!foundPipes.containsKey(pipe)) {
                            foundPipes.put(pipe, (ExitRoute)result.get(pipe));
                            continue;
                        }
                        if (((ExitRoute)result.get((Object)pipe)).metric >= ((ExitRoute)foundPipes.get((Object)pipe)).metric) continue;
                        foundPipes.put(pipe, (ExitRoute)result.get(pipe));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < 6; ++i) {
            Position p = new Position((double)startPipe.j, (double)startPipe.k, (double)startPipe.l, Orientations.values()[i]);
            p.moveForwards(1.0);
            kw tile = startPipe.i.b((int)p.x, (int)p.y, (int)p.z);
            if (tile == null || !(tile instanceof TileGenericPipe) || !SimpleServiceLocator.buildCraftProxy.checkPipesConnections((kw)startPipe, tile)) continue;
            int beforeRecurseCount = foundPipes.size();
            HashMap result = this.getConnectedRoutingPipes((TileGenericPipe)tile, (LinkedList)visited.clone(), pathPainter);
            for (RoutedPipe pipe : result.keySet()) {
                ((ExitRoute)result.get((Object)pipe)).exitOrientation = Orientations.values()[i];
                if (!foundPipes.containsKey(pipe)) {
                    foundPipes.put(pipe, (ExitRoute)result.get(pipe));
                    continue;
                }
                if (((ExitRoute)result.get((Object)pipe)).metric >= ((ExitRoute)foundPipes.get((Object)pipe)).metric) continue;
                foundPipes.put(pipe, (ExitRoute)result.get(pipe));
            }
            if (foundPipes.size() <= beforeRecurseCount || pathPainter == null) continue;
            p.moveBackwards(1.0);
            pathPainter.addLaser(startPipe.i, p, Orientations.values()[i]);
        }
        return foundPipes;
    }
}

