/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.recipeproviders;

import buildcraft.krapht.recipeproviders.ICraftingRecipeProvider;
import java.lang.reflect.Method;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;

public class RollingMachine
implements ICraftingRecipeProvider {
    public static Class tileRollingMachineClass;
    public static Method getCraftMatrixMethod;

    public static boolean load() {
        try {
            tileRollingMachineClass = Class.forName("railcraft.common.utility.TileRollingMachine");
            getCraftMatrixMethod = tileRollingMachineClass.getMethod("getCraftMatrix", new Class[0]);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("Necessary classes from Railcraft were not found");
            return false;
        }
        return true;
    }

    @Override
    public boolean canOpenGui(kw tile) {
        return tileRollingMachineClass.isInstance(tile);
    }

    public aan getResult(ade inventorycrafting) {
        if (inventorycrafting == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName("railcraft.common.util.crafting.RollingMachineCraftingManager");
            Method inst = c.getMethod("getInstance", new Class[0]);
            Object instance = inst.invoke(null, new Object[0]);
            Method findMatchingRecipe = c.getMethod("findMatchingRecipe", ade.class);
            return (aan)findMatchingRecipe.invoke(instance, inventorycrafting);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("getResult fail");
            return null;
        }
    }

    public ade getCraftMatrix(kw tile) {
        try {
            return (ade)getCraftMatrixMethod.invoke((Object)tile, new Object[0]);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("getCraftMatrix fail");
            return null;
        }
    }

    @Override
    public boolean importRecipe(kw tile, SimpleInventory inventory) {
        int i;
        if (!tileRollingMachineClass.isInstance(tile)) {
            return false;
        }
        ade craftMatrix = this.getCraftMatrix(tile);
        if (craftMatrix == null) {
            return false;
        }
        aan result = this.getResult(craftMatrix);
        if (result == null) {
            return false;
        }
        inventory.a(9, result);
        for (i = 0; i < craftMatrix.a() && i < inventory.a() - 1; ++i) {
            aan newStack = craftMatrix.k_(i) == null ? null : craftMatrix.k_(i).k();
            inventory.a(i, newStack);
        }
        for (i = 0; i < inventory.a() - 1; ++i) {
            aan stackInSlot = inventory.k_(i);
            if (stackInSlot == null) continue;
            ItemIdentifier itemInSlot = ItemIdentifier.get(stackInSlot);
            for (int j = i + 1; j < inventory.a() - 1; ++j) {
                aan stackInOtherSlot = inventory.k_(j);
                if (stackInOtherSlot == null || itemInSlot != ItemIdentifier.get(stackInOtherSlot)) continue;
                stackInSlot.a += stackInOtherSlot.a;
                inventory.a(j, null);
            }
        }
        block3: for (i = 0; i < inventory.a() - 1; ++i) {
            if (inventory.k_(i) != null) continue;
            for (int j = i + 1; j < inventory.a() - 1; ++j) {
                if (inventory.k_(j) == null) continue;
                inventory.a(i, inventory.k_(j));
                inventory.a(j, null);
                continue block3;
            }
        }
        return true;
    }
}

