/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.pipes;

import buildcraft.api.EntityPassiveItem;
import buildcraft.api.ISpecialInventory;
import buildcraft.api.Position;
import buildcraft.core.Utils;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.pipes.PipeItemsCraftingLogistics;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.transport.PipeTransportItems;
import java.util.LinkedList;
import krapht.AdjacentTile;

public class PipeItemsCraftingLogisticsMk2
extends PipeItemsCraftingLogistics {
    public PipeItemsCraftingLogisticsMk2(int itemID) {
        super(itemID);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this._orderManager.hasOrders() && this._extras < 1 || this.worldObj.w() % 6L != 0L) {
            return;
        }
        LinkedList crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            this._orderManager.sendFailed();
            return;
        }
        for (int i = 0; i < 64 && (this._orderManager.hasOrders() || this._extras >= 1); ++i) {
            for (AdjacentTile tile : this.locateCrafters()) {
                aan extracted = null;
                if (tile.tile instanceof ISpecialInventory) {
                    extracted = this.extractFromISpecialInventory((ISpecialInventory)tile.tile);
                } else if (tile.tile instanceof io) {
                    extracted = this.extractFromIInventory((io)tile.tile);
                }
                if (extracted == null) continue;
                while (extracted.a > 0) {
                    aan stackToSend = extracted.a(1);
                    Position p = new Position((double)tile.tile.j, (double)tile.tile.k, (double)tile.tile.l, tile.orientation);
                    if (this._orderManager.hasOrders()) {
                        LogisticsRequest order = this._orderManager.getNextRequest();
                        IRoutedItem item = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stackToSend, this.worldObj);
                        item.setSource(this.getRouter().getId());
                        item.setDestination(order.getDestination().getRouter().getId());
                        item.setTransportMode(IRoutedItem.TransportMode.Active);
                        super.queueRoutedItem(item, tile.orientation);
                        this._orderManager.sendSuccessfull(1);
                        continue;
                    }
                    --this._extras;
                    if (mod_LogisticsPipes.DisplayRequests) {
                        System.out.println("Extra dropped, " + this._extras + " remaining");
                    }
                    Position entityPos = new Position(p.x + 0.5, p.y + (double)Utils.getPipeFloorOf((aan)stackToSend), p.z + 0.5, p.orientation.reverse());
                    entityPos.moveForwards(0.5);
                    EntityPassiveItem entityItem = new EntityPassiveItem(this.worldObj, entityPos.x, entityPos.y, entityPos.z, stackToSend);
                    entityItem.speed = Utils.pipeNormalSpeed * 10.0f;
                    ((PipeTransportItems)this.transport).entityEntering(entityItem, entityPos.orientation);
                }
            }
            if (this._orderManager.hasOrders()) break;
        }
    }

    @Override
    public int getCenterTexture() {
        return core_LogisticsPipes.LOGISTICSPIPE_CRAFTERMK2_TEXTURE;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }
}

