/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.pipes;

import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.core.Utils;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.TemporaryLogic;
import buildcraft.logisticspipes.IInventoryProvider;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.SidedInventoryAdapter;
import buildcraft.logisticspipes.TransportLayer;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.ISendRoutedItem;
import buildcraft.logisticspipes.modules.ModuleApiaristAnalyser;
import buildcraft.transport.TileGenericPipe;
import forge.ISidedInventory;
import java.util.UUID;

public class PipeItemsApiaristAnalyser
extends RoutedPipe
implements IInventoryProvider,
ISendRoutedItem {
    private ModuleApiaristAnalyser analyserModule = new ModuleApiaristAnalyser();

    public PipeItemsApiaristAnalyser(int itemID) {
        super(new TemporaryLogic(), itemID);
        this.analyserModule.registerHandler(this, this, this);
    }

    @Override
    public int getCenterTexture() {
        return mod_LogisticsPipes.LOGISTICSPIPE_APIARIST_ANALYSER_TEXTURE;
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new TransportLayer(){

                @Override
                public Orientations itemArrived(IRoutedItem item) {
                    return PipeItemsApiaristAnalyser.this.getPointedOrientation();
                }

                @Override
                public boolean stillWantItem(IRoutedItem item) {
                    return true;
                }
            };
        }
        return this._transportLayer;
    }

    @Override
    public int getNonRoutedTexture(Orientations connection) {
        if (connection.equals((Object)this.getPointedOrientation())) {
            return core_LogisticsPipes.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE;
        }
        return core_LogisticsPipes.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return this.analyserModule;
    }

    @Override
    public UUID getSourceUUID() {
        return this.getRouter().getId();
    }

    @Override
    public void sendStack(aan stack) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Passive);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation());
    }

    @Override
    public void sendStack(aan stack, UUID destination) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setSource(this.getRouter().getId());
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Active);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation());
    }

    private Orientations getPointedOrientation() {
        for (Orientations ori : Orientations.values()) {
            Position pos = new Position((kw)this.container);
            pos.orientation = ori;
            pos.moveForwards(1.0);
            kw tile = this.worldObj.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (tile == null || !SimpleServiceLocator.forestryProxy.isTileAnalyser(tile)) continue;
            return ori;
        }
        return null;
    }

    private kw getPointedTileEntity() {
        for (Orientations ori : Orientations.values()) {
            Position pos = new Position((kw)this.container);
            pos.orientation = ori;
            pos.moveForwards(1.0);
            kw tile = this.worldObj.b((int)pos.x, (int)pos.y, (int)pos.z);
            if (tile == null || !SimpleServiceLocator.forestryProxy.isTileAnalyser(tile)) continue;
            return tile;
        }
        return null;
    }

    @Override
    public io getRawInventory() {
        kw tile = this.getPointedTileEntity();
        if (tile instanceof TileGenericPipe) {
            return null;
        }
        if (!(tile instanceof io)) {
            return null;
        }
        return Utils.getInventory((io)((io)tile));
    }

    @Override
    public io getInventory() {
        io rawInventory = this.getRawInventory();
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryAdapter((ISidedInventory)rawInventory, this.getPointedOrientation().reverse());
        }
        return rawInventory;
    }

    @Override
    public Orientations inventoryOrientation() {
        return this.getPointedOrientation();
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }
}

