/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.network;

import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.ItemMessage;
import buildcraft.krapht.gui.GuiProviderPipe;
import buildcraft.krapht.gui.GuiSupplierPipe;
import buildcraft.krapht.gui.orderer.GuiOrderer;
import buildcraft.krapht.gui.popup.GuiDiskPopup;
import buildcraft.krapht.logic.LogicCrafting;
import buildcraft.krapht.logic.LogicProvider;
import buildcraft.krapht.logic.LogicSatellite;
import buildcraft.krapht.logic.LogicSupplier;
import buildcraft.krapht.network.PacketCraftingLoop;
import buildcraft.krapht.network.PacketInventoryChange;
import buildcraft.krapht.network.PacketItem;
import buildcraft.krapht.network.PacketItems;
import buildcraft.krapht.network.PacketModuleNBT;
import buildcraft.krapht.network.PacketPipeInteger;
import buildcraft.krapht.network.PacketRequestGuiContent;
import buildcraft.krapht.pipes.PipeItemsApiaristSink;
import buildcraft.krapht.pipes.PipeItemsRequestLogisticsMk2;
import buildcraft.logisticspipes.ExtractionMode;
import buildcraft.logisticspipes.modules.GuiAdvancedExtractor;
import buildcraft.logisticspipes.modules.GuiExtractor;
import buildcraft.logisticspipes.modules.GuiItemSink;
import buildcraft.logisticspipes.modules.GuiProvider;
import buildcraft.logisticspipes.modules.ModuleApiaristSink;
import buildcraft.transport.TileGenericPipe;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import krapht.ItemIdentifier;
import krapht.gui.ISubGuiControler;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(lg network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            network.getNetHandler();
            int packetID = data.read();
            switch (packetID) {
                case 3: {
                    PacketPipeInteger packet = new PacketPipeInteger();
                    packet.readData(data);
                    this.onCraftingPipeSetSatellite(packet);
                    break;
                }
                case 5: {
                    PacketInventoryChange packetA = new PacketInventoryChange();
                    packetA.readData(data);
                    this.onCraftingPipeSetImport(packetA);
                    break;
                }
                case 8: {
                    PacketPipeInteger packetB = new PacketPipeInteger();
                    packetB.readData(data);
                    this.onSatellitePipeSetSatellite(packetB);
                    break;
                }
                case 13: {
                    PacketRequestGuiContent packetC = new PacketRequestGuiContent();
                    packetC.readData(data);
                    this.onOrdererRefreshAnswer(packetC);
                    break;
                }
                case 14: {
                    PacketItems packetD = new PacketItems();
                    packetD.readData(data);
                    this.onItemsResponse(packetD);
                    break;
                }
                case 15: {
                    PacketCraftingLoop packetE = new PacketCraftingLoop();
                    packetE.readData(data);
                    this.onCraftingLoop(packetE);
                    break;
                }
                case 17: {
                    PacketPipeInteger packetH = new PacketPipeInteger();
                    packetH.readData(data);
                    this.onItemSinkStatusRecive(packetH);
                    break;
                }
                case 20: {
                    PacketPipeInteger packetF = new PacketPipeInteger();
                    packetF.readData(data);
                    this.onProviderPipeModeRecive(packetF);
                    break;
                }
                case 21: {
                    PacketPipeInteger packetG = new PacketPipeInteger();
                    packetG.readData(data);
                    this.onProviderPipeIncludeRecive(packetG);
                    break;
                }
                case 23: {
                    PacketPipeInteger packetI = new PacketPipeInteger();
                    packetI.readData(data);
                    this.onSupplierPipeRecive(packetI);
                    break;
                }
                case 25: {
                    PacketPipeInteger packetJ = new PacketPipeInteger();
                    packetJ.readData(data);
                    this.onModulePipeRecive(packetJ);
                    break;
                }
                case 28: {
                    PacketPipeInteger packetK = new PacketPipeInteger();
                    packetK.readData(data);
                    this.onProviderModuleModeRecive(packetK);
                    break;
                }
                case 29: {
                    PacketPipeInteger packetL = new PacketPipeInteger();
                    packetL.readData(data);
                    this.onProviderModuleIncludeRecive(packetL);
                    break;
                }
                case 31: {
                    PacketPipeInteger packetM = new PacketPipeInteger();
                    packetM.readData(data);
                    this.onAdvancedExtractorModuleIncludeRecive(packetM);
                    break;
                }
                case 38: {
                    PacketItem packetO = new PacketItem();
                    packetO.readData(data);
                    this.handleRequestMK2DiskItem(packetO);
                    break;
                }
                case 42: {
                    PacketItems packetP = new PacketItems();
                    packetP.readData(data);
                    this.handleMacroResponse(packetP);
                }
                case 44: {
                    PacketModuleNBT packetQ = new PacketModuleNBT();
                    packetQ.readData(data);
                    this.handleBeePacketNBT(packetQ);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onCraftingPipeSetSatellite(PacketPipeInteger packet) {
        TileGenericPipe pipe = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicCrafting)) {
            return;
        }
        ((LogicCrafting)pipe.pipe.logic).setSatelliteId(packet.integer);
    }

    private void onCraftingPipeSetImport(PacketInventoryChange packet) {
        TileGenericPipe pipe = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicCrafting)) {
            return;
        }
        LogicCrafting craftingPipe = (LogicCrafting)pipe.pipe.logic;
        for (int i = 0; i < packet.itemStacks.size(); ++i) {
            craftingPipe.setDummyInventorySlot(i, (aan)packet.itemStacks.get(i));
        }
    }

    private void onSatellitePipeSetSatellite(PacketPipeInteger packet) {
        TileGenericPipe pipe = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicSatellite)) {
            return;
        }
        ((LogicSatellite)pipe.pipe.logic).setSatelliteId(packet.integer);
    }

    private void onOrdererRefreshAnswer(PacketRequestGuiContent packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiOrderer) {
            ((GuiOrderer)ModLoader.getMinecraftInstance().s).handlePacket(packet);
        }
    }

    private void onItemsResponse(PacketItems packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiOrderer) {
            ((GuiOrderer)ModLoader.getMinecraftInstance().s).handleRequestAnswer(packet.items, !packet.error, (ISubGuiControler)((GuiOrderer)ModLoader.getMinecraftInstance().s), (yw)ModLoader.getMinecraftInstance().h);
        } else if (packet.error) {
            for (ItemMessage items : packet.items) {
                ModLoader.getMinecraftInstance().h.b("Missing: " + items);
            }
        } else {
            for (ItemMessage items : packet.items) {
                ModLoader.getMinecraftInstance().h.b("Requested: " + items);
            }
            ModLoader.getMinecraftInstance().h.b("Request successful!");
        }
    }

    private void onCraftingLoop(PacketCraftingLoop packet) {
        ItemIdentifier item = ((ItemMessage)packet.items.get(0)).getItemIdentifier();
        ModLoader.getMinecraftInstance().h.b("Logistics: Possible crafting loop while trying to craft " + item.getFriendlyName() + " !! ABORTING !!");
    }

    private void onItemSinkStatusRecive(PacketPipeInteger packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiItemSink) {
            ((GuiItemSink)ModLoader.getMinecraftInstance().s).handleDefaultRoutePackage(packet);
        }
    }

    private void onProviderPipeModeRecive(PacketPipeInteger packet) {
        TileGenericPipe pipe = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicProvider)) {
            return;
        }
        ExtractionMode mode = ((LogicProvider)pipe.pipe.logic).getExtractionMode();
        int modeint = mode.ordinal();
        while (modeint != packet.integer) {
            ((LogicProvider)pipe.pipe.logic).nextExtractionMode();
            modeint = ((LogicProvider)pipe.pipe.logic).getExtractionMode().ordinal();
            if (mode.ordinal() != modeint) continue;
            break;
        }
    }

    private void onProviderPipeIncludeRecive(PacketPipeInteger packet) {
        TileGenericPipe pipe = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicProvider)) {
            return;
        }
        ((LogicProvider)pipe.pipe.logic).setFilterExcluded(packet.integer == 1);
        if (ModLoader.getMinecraftInstance().s instanceof GuiProviderPipe) {
            ((GuiProviderPipe)ModLoader.getMinecraftInstance().s).refreshInclude();
        }
    }

    private void onSupplierPipeRecive(PacketPipeInteger packet) {
        TileGenericPipe pipe = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (pipe == null) {
            return;
        }
        if (!(pipe.pipe.logic instanceof LogicSupplier)) {
            return;
        }
        ((LogicSupplier)pipe.pipe.logic).setRequestingPartials(packet.integer == 1);
        if (ModLoader.getMinecraftInstance().s instanceof GuiSupplierPipe) {
            ((GuiSupplierPipe)ModLoader.getMinecraftInstance().s).refreshMode();
        }
    }

    private void onModulePipeRecive(PacketPipeInteger packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiExtractor) {
            ((GuiExtractor)ModLoader.getMinecraftInstance().s).handlePackat(packet);
        }
    }

    private void onProviderModuleModeRecive(PacketPipeInteger packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiProvider) {
            ((GuiProvider)ModLoader.getMinecraftInstance().s).handleModuleModeRecive(packet);
        }
    }

    private void onProviderModuleIncludeRecive(PacketPipeInteger packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiProvider) {
            ((GuiProvider)ModLoader.getMinecraftInstance().s).handleModuleIncludeRecive(packet);
        }
    }

    private void onAdvancedExtractorModuleIncludeRecive(PacketPipeInteger packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiAdvancedExtractor) {
            ((GuiAdvancedExtractor)ModLoader.getMinecraftInstance().s).handleIncludeRoutePackage(packet);
        }
    }

    private void handleRequestMK2DiskItem(PacketItem packet) {
        TileGenericPipe tile = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof PipeItemsRequestLogisticsMk2) {
            ((PipeItemsRequestLogisticsMk2)tile.pipe).setDisk(packet.itemstack);
        }
    }

    private void handleMacroResponse(PacketItems packet) {
        if (ModLoader.getMinecraftInstance().s instanceof GuiOrderer && ((GuiOrderer)ModLoader.getMinecraftInstance().s).getSubGui() instanceof GuiDiskPopup) {
            ((GuiOrderer)ModLoader.getMinecraftInstance().s).handleRequestAnswer(packet.items, packet.error, (ISubGuiControler)((GuiOrderer)ModLoader.getMinecraftInstance().s).getSubGui(), (yw)ModLoader.getMinecraftInstance().h);
        }
    }

    private void handleBeePacketNBT(PacketModuleNBT packet) {
        ModuleApiaristSink sink;
        TileGenericPipe tile = this.getPipe(ModLoader.getMinecraftInstance().f, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        if (packet.slot == -1 && tile.pipe instanceof PipeItemsApiaristSink) {
            sink = (ModuleApiaristSink)((PipeItemsApiaristSink)tile.pipe).getLogisticsModule();
        } else if (tile.pipe instanceof CoreRoutedPipe && ((CoreRoutedPipe)tile.pipe).getLogisticsModule().getSubModule(packet.slot) instanceof ModuleApiaristSink) {
            sink = (ModuleApiaristSink)((CoreRoutedPipe)tile.pipe).getLogisticsModule().getSubModule(packet.slot);
        } else {
            return;
        }
        packet.handle(sink);
    }

    private TileGenericPipe getPipe(xd world, int x, int y, int z) {
        if (!world.j(x, y, z)) {
            return null;
        }
        kw tile = world.b(x, y, z);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        return (TileGenericPipe)tile;
    }
}

