/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logistics;

import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logistics.ILogisticsManagerV2;
import buildcraft.krapht.routing.IRouter;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.SinkReply;
import java.util.UUID;
import krapht.Pair;

public class LogisticsManagerV2
implements ILogisticsManagerV2 {
    @Override
    public boolean hasDestination(aan stack, boolean allowDefault, UUID sourceRouter, boolean excludeSource) {
        if (!SimpleServiceLocator.routerManager.isRouter(sourceRouter)) {
            return false;
        }
        Pair search = this.getBestReply(stack, SimpleServiceLocator.routerManager.getRouter(sourceRouter), excludeSource);
        if (search.getValue2() == null) {
            return false;
        }
        return allowDefault || !((SinkReply)search.getValue2()).isDefault;
    }

    private Pair getBestReply(aan item, IRouter sourceRouter, boolean excludeSource) {
        UUID potentialDestination = null;
        SinkReply bestReply = null;
        for (IRouter candidateRouter : sourceRouter.getIRoutersByCost()) {
            SinkReply reply;
            if (excludeSource && candidateRouter.getId().equals(sourceRouter.getId())) continue;
            ILogisticsModule module = candidateRouter.getLogisticsModule();
            if (candidateRouter.getPipe() == null || !candidateRouter.getPipe().isEnabled() || module == null || (reply = module.sinksItem(item)) == null) continue;
            if (bestReply == null) {
                potentialDestination = candidateRouter.getId();
                bestReply = reply;
                continue;
            }
            if (reply.fixedPriority.ordinal() > bestReply.fixedPriority.ordinal()) {
                bestReply = reply;
                potentialDestination = candidateRouter.getId();
                continue;
            }
            if (reply.fixedPriority != bestReply.fixedPriority || reply.customPriority <= bestReply.customPriority) continue;
            bestReply = reply;
            potentialDestination = candidateRouter.getId();
        }
        Pair result = new Pair(potentialDestination, bestReply);
        return result;
    }

    @Override
    public IRoutedItem assignDestinationFor(IRoutedItem item, UUID sourceRouterUUID, boolean excludeSource) {
        if (!SimpleServiceLocator.routerManager.isRouter(sourceRouterUUID)) {
            return item;
        }
        IRouter sourceRouter = SimpleServiceLocator.routerManager.getRouter(sourceRouterUUID);
        if (sourceRouter == null) {
            return item;
        }
        item.setDestination(null);
        Pair bestReply = this.getBestReply(item.getItemStack(), sourceRouter, excludeSource);
        item.setSource(sourceRouterUUID);
        if (bestReply.getValue1() != null) {
            item.setDestination((UUID)bestReply.getValue1());
            if (((SinkReply)bestReply.getValue2()).isPassive) {
                if (((SinkReply)bestReply.getValue2()).isDefault) {
                    item.setTransportMode(IRoutedItem.TransportMode.Default);
                } else {
                    item.setTransportMode(IRoutedItem.TransportMode.Passive);
                }
            }
        }
        return item;
    }

    @Override
    public IRoutedItem destinationUnreachable(IRoutedItem item, UUID currentRouter) {
        return this.assignDestinationFor(item, currentRouter, false);
    }
}

