/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logic;

import buildcraft.api.APIProxy;
import buildcraft.core.CoreProxy;
import buildcraft.core.Utils;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.energy.EngineWood;
import buildcraft.energy.TileEngine;
import buildcraft.krapht.CoreRoutedPipe;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.LogisticsManager;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.logic.BaseRoutingLogic;
import buildcraft.krapht.network.PacketPipeInteger;
import buildcraft.krapht.pipes.PipeItemsSupplierLogistics;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import krapht.AdjacentTile;
import krapht.InventoryUtil;
import krapht.InventoryUtilFactory;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;
import krapht.WorldUtil;

public class LogicSupplier
extends BaseRoutingLogic
implements IRequireReliableTransport {
    private SimpleInventory dummyInventory = new SimpleInventory(9, "Items to keep stocked", 127);
    private final InventoryUtilFactory _invUtilFactory;
    private final InventoryUtil _dummyInvUtil;
    private final HashMap _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public boolean pause = false;

    public LogicSupplier() {
        this(new InventoryUtilFactory());
    }

    public LogicSupplier(InventoryUtilFactory inventoryUtilFactory) {
        this._invUtilFactory = inventoryUtilFactory;
        this._dummyInvUtil = this._invUtilFactory.getInventoryUtil(this.dummyInventory);
        this.throttleTime = 100;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onWrenchClicked(yw entityplayer) {
        if (!APIProxy.isClient((xd)entityplayer.k)) {
            entityplayer.openGui((BaseMod)mod_LogisticsPipes.instance, 14, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            CoreProxy.sendToPlayer((yw)entityplayer, (BuildCraftPacket)new PacketPipeInteger(23, this.xCoord, this.yCoord, this.zCoord, this.isRequestingPartials() ? 1 : 0));
        }
    }

    public SimpleInventory getDummyInventory() {
        return this.dummyInventory;
    }

    @Override
    public void throttledUpdateEntity() {
        if (!((CoreRoutedPipe)this.container.pipe).isEnabled()) {
            return;
        }
        if (APIProxy.isClient((xd)this.worldObj)) {
            return;
        }
        if (this.pause) {
            return;
        }
        super.throttledUpdateEntity();
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities()) {
            io inv;
            if (tile.tile instanceof TileGenericPipe || !(tile.tile instanceof io) || tile.tile instanceof TileEngine && ((TileEngine)tile.tile).engine instanceof EngineWood || (inv = Utils.getInventory((io)((io)tile.tile))).a() < 1) continue;
            InventoryUtil invUtil = this._invUtilFactory.getInventoryUtil(inv);
            HashMap needed = this._dummyInvUtil.getItemsAndCount();
            HashMap have = invUtil.getItemsAndCount();
            for (ItemIdentifier item : needed.keySet()) {
                if (!have.containsKey(item)) continue;
                needed.put(item, (Integer)needed.get(item) - (Integer)have.get(item));
            }
            for (ItemIdentifier item : needed.keySet()) {
                if (!this._requestedItems.containsKey(item)) continue;
                needed.put(item, (Integer)needed.get(item) - (Integer)this._requestedItems.get(item));
            }
            ((PipeItemsSupplierLogistics)this.container.pipe).setRequestFailed(false);
            for (ItemIdentifier need : needed.keySet()) {
                int neededCount;
                if ((Integer)needed.get(need) < 1) continue;
                boolean success = false;
                for (neededCount = ((Integer)needed.get(need)).intValue(); !(success = LogisticsManager.Request(new LogisticsRequest(need, neededCount, (IRequestItems)this.container.pipe), this.getRouter().getRoutersByCost(), null)) && neededCount != 1; neededCount /= 2) {
                    if (this._requestPartials && !success) continue;
                }
                if (success) {
                    if (!this._requestedItems.containsKey(need)) {
                        this._requestedItems.put(need, neededCount);
                        continue;
                    }
                    this._requestedItems.put(need, (Integer)this._requestedItems.get(need) + neededCount);
                    continue;
                }
                ((PipeItemsSupplierLogistics)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.o("requestpartials");
    }

    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("requestpartials", this._requestPartials);
    }

    @Override
    public void itemLost(ItemIdentifier item) {
        if (this._requestedItems.containsKey(item)) {
            this._requestedItems.put(item, (Integer)this._requestedItems.get(item) - 1);
        }
    }

    @Override
    public void itemArrived(ItemIdentifier item) {
        super.resetThrottle();
        if (this._requestedItems.containsKey(item)) {
            this._requestedItems.put(item, (Integer)this._requestedItems.get(item) - 1);
        }
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }
}

