/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logic;

import buildcraft.api.APIProxy;
import buildcraft.api.BuildCraftAPI;
import buildcraft.api.ILiquidContainer;
import buildcraft.api.LiquidSlot;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.LogisticsManager;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.BaseRoutingLogic;
import java.util.HashMap;
import krapht.AdjacentTile;
import krapht.InventoryUtil;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;
import krapht.WorldUtil;

public class LogicLiquidSupplier
extends BaseRoutingLogic
implements IRequireReliableTransport {
    private SimpleInventory dummyInventory = new SimpleInventory(9, "Liquids to keep stocked", 127);
    private final HashMap _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public boolean pause = false;

    public LogicLiquidSupplier() {
        this.throttleTime = 100;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void throttledUpdateEntity() {
        if (this.pause) {
            return;
        }
        super.throttledUpdateEntity();
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities()) {
            LiquidSlot[] result;
            ILiquidContainer container;
            if (!(tile.tile instanceof ILiquidContainer) || (container = (ILiquidContainer)tile.tile).getLiquidSlots().length == 0) continue;
            InventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(this.dummyInventory);
            HashMap wantContainers = invUtil.getItemsAndCount();
            HashMap<Integer, Integer> wantLiquids = new HashMap<Integer, Integer>();
            for (ItemIdentifier item : wantContainers.keySet()) {
                aan wantItem = item.makeNormalStack(1);
                int liquidId = BuildCraftAPI.getLiquidForFilledItem((aan)wantItem);
                if (liquidId == 0) continue;
                wantLiquids.put(liquidId, (Integer)wantContainers.get(item) * 1000);
            }
            HashMap<Integer, Integer> haveLiquids = new HashMap<Integer, Integer>();
            for (LiquidSlot slot : result = container.getLiquidSlots()) {
                if (!wantLiquids.containsKey(slot.getLiquidId())) continue;
                if (!haveLiquids.containsKey(slot.getLiquidId())) {
                    haveLiquids.put(slot.getLiquidId(), slot.getLiquidQty());
                    continue;
                }
                haveLiquids.put(slot.getLiquidId(), (Integer)haveLiquids.get(slot.getLiquidId()) + slot.getLiquidQty());
            }
            for (Integer liquidId : wantLiquids.keySet()) {
                if (!haveLiquids.containsKey(liquidId)) continue;
                wantLiquids.put(liquidId, (Integer)wantLiquids.get(liquidId) - (Integer)haveLiquids.get(liquidId));
            }
            for (Integer liquidId : wantLiquids.keySet()) {
                for (ItemIdentifier requestedItem : this._requestedItems.keySet()) {
                    aan wantItem = requestedItem.makeNormalStack(1);
                    int requestedLiquidId = BuildCraftAPI.getLiquidForFilledItem((aan)wantItem);
                    if (requestedLiquidId == 0) continue;
                    wantLiquids.put(liquidId, (Integer)wantLiquids.get(liquidId) - (Integer)this._requestedItems.get(requestedItem) * 1000);
                }
            }
            HashMap allNeededContainers = invUtil.getItemsAndCount();
            for (ItemIdentifier need : allNeededContainers.keySet()) {
                int countToRequest;
                int requestedLiquidId = BuildCraftAPI.getLiquidForFilledItem((aan)need.makeNormalStack(1));
                if (requestedLiquidId == 0 || !wantLiquids.containsKey(requestedLiquidId) || (countToRequest = (Integer)wantLiquids.get(requestedLiquidId) / 1000) < 1) continue;
                boolean success = false;
                while (!(success = LogisticsManager.Request(new LogisticsRequest(need, countToRequest, (IRequestItems)this.container.pipe), this.getRouter().getRoutersByCost(), null)) && countToRequest != 1) {
                    countToRequest /= 2;
                    if (this._requestPartials && !success) continue;
                }
                if (!success) continue;
                if (!this._requestedItems.containsKey(need)) {
                    this._requestedItems.put(need, countToRequest);
                    continue;
                }
                this._requestedItems.put(need, (Integer)this._requestedItems.get(need) + countToRequest);
            }
        }
    }

    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.o("requestpartials");
    }

    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("requestpartials", this._requestPartials);
    }

    @Override
    public void itemLost(ItemIdentifier item) {
        if (this._requestedItems.containsKey(item)) {
            this._requestedItems.put(item, (Integer)this._requestedItems.get(item) - 1);
        }
    }

    @Override
    public void itemArrived(ItemIdentifier item) {
        super.resetThrottle();
        if (this._requestedItems.containsKey(item)) {
            this._requestedItems.put(item, (Integer)this._requestedItems.get(item) - 1);
        }
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    @Override
    public void onWrenchClicked(yw entityplayer) {
        if (!APIProxy.isClient((xd)entityplayer.k)) {
            entityplayer.openGui((BaseMod)mod_LogisticsPipes.instance, 11, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public SimpleInventory getDummyInventory() {
        return this.dummyInventory;
    }
}

