/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logic;

import buildcraft.builders.TileBuilder;
import buildcraft.core.Utils;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.LogisticsManager;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.logic.BaseRoutingLogic;
import buildcraft.krapht.pipes.PipeItemsBuilderSupplierLogistics;
import java.util.Collection;
import java.util.HashMap;
import krapht.AdjacentTile;
import krapht.InventoryUtil;
import krapht.InventoryUtilFactory;
import krapht.ItemIdentifier;
import krapht.SimpleInventory;
import krapht.WorldUtil;

public class LogicBuilderSupplier
extends BaseRoutingLogic
implements IRequireReliableTransport {
    private SimpleInventory dummyInventory = new SimpleInventory(9, "Items to keep stocked", 127);
    private final InventoryUtilFactory _invUtilFactory;
    private final HashMap _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public boolean pause = false;

    public LogicBuilderSupplier() {
        this(new InventoryUtilFactory());
    }

    public LogicBuilderSupplier(InventoryUtilFactory inventoryUtilFactory) {
        this._invUtilFactory = inventoryUtilFactory;
        this.throttleTime = 100;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void throttledUpdateEntity() {
        if (this.pause) {
            return;
        }
        super.throttledUpdateEntity();
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities()) {
            if (!(tile.tile instanceof TileBuilder)) continue;
            TileBuilder builder = (TileBuilder)tile.tile;
            io inv = Utils.getInventory((io)((io)tile.tile));
            InventoryUtil invUtil = this._invUtilFactory.getInventoryUtil(inv);
            Collection neededItems = builder.getNeededItems();
            HashMap<ItemIdentifier, Integer> needed = new HashMap<ItemIdentifier, Integer>();
            if (neededItems == null) {
                return;
            }
            for (aan stack : neededItems) {
                ItemIdentifier item = ItemIdentifier.get(stack);
                if (!needed.containsKey(item)) {
                    needed.put(item, stack.a);
                    continue;
                }
                needed.put(item, (Integer)needed.get(item) + stack.a);
            }
            HashMap have = invUtil.getItemsAndCount();
            for (ItemIdentifier item : needed.keySet()) {
                if (!have.containsKey(item)) continue;
                needed.put(item, (Integer)needed.get(item) - (Integer)have.get(item));
            }
            for (ItemIdentifier item : needed.keySet()) {
                if (!this._requestedItems.containsKey(item)) continue;
                needed.put(item, (Integer)needed.get(item) - (Integer)this._requestedItems.get(item));
            }
            ((PipeItemsBuilderSupplierLogistics)this.container.pipe).setRequestFailed(false);
            for (ItemIdentifier need : needed.keySet()) {
                int neededCount;
                if ((Integer)needed.get(need) < 1) continue;
                boolean success = false;
                for (neededCount = ((Integer)needed.get(need)).intValue(); !(success = LogisticsManager.Request(new LogisticsRequest(need, neededCount, (IRequestItems)this.container.pipe), this.getRouter().getRoutersByCost(), null)) && neededCount != 1; neededCount /= 2) {
                    if (this._requestPartials && !success) continue;
                }
                if (success) {
                    if (!this._requestedItems.containsKey(need)) {
                        this._requestedItems.put(need, neededCount);
                        continue;
                    }
                    this._requestedItems.put(need, (Integer)this._requestedItems.get(need) + neededCount);
                    continue;
                }
                ((PipeItemsBuilderSupplierLogistics)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    @Override
    public void itemLost(ItemIdentifier item) {
        if (this._requestedItems.containsKey(item)) {
            this._requestedItems.put(item, (Integer)this._requestedItems.get(item) - 1);
        }
    }

    @Override
    public void itemArrived(ItemIdentifier item) {
        super.resetThrottle();
        if (this._requestedItems.containsKey(item)) {
            this._requestedItems.put(item, (Integer)this._requestedItems.get(item) - 1);
        }
    }

    @Override
    public void onWrenchClicked(yw entityplayer) {
    }
}

