/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.logic;

import buildcraft.api.TileNetworkData;
import buildcraft.krapht.IRequireReliableTransport;
import buildcraft.krapht.LogisticsManager;
import buildcraft.krapht.LogisticsRequest;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.logic.BaseRoutingLogic;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import krapht.ItemIdentifier;

public class BaseLogicSatellite
extends BaseRoutingLogic
implements IRequireReliableTransport {
    public static HashSet AllSatellites = new HashSet();
    protected final LinkedList _lostItems = new LinkedList();
    @TileNetworkData
    public int satelliteId;

    public BaseLogicSatellite() {
        this.throttleTime = 40;
    }

    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.satelliteId = nbttagcompound.f("satelliteid");
        this.ensureAllSatelliteStatus();
    }

    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("satelliteid", this.satelliteId);
        super.writeToNBT(nbttagcompound);
    }

    protected int findId(int increment) {
        int potentialId = this.satelliteId;
        boolean conflict = true;
        block0: while (conflict) {
            if ((potentialId += increment) < 0) {
                return 0;
            }
            conflict = false;
            for (BaseLogicSatellite sat : AllSatellites) {
                if (sat.satelliteId != potentialId) continue;
                conflict = true;
                continue block0;
            }
        }
        return potentialId;
    }

    protected void ensureAllSatelliteStatus() {
        if (this.satelliteId == 0 && AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
        if (this.satelliteId != 0 && !AllSatellites.contains(this)) {
            AllSatellites.add(this);
        }
    }

    public void setNextId() {
        this.satelliteId = this.findId(1);
        this.ensureAllSatelliteStatus();
    }

    public void setPrevId() {
        this.satelliteId = this.findId(-1);
        this.ensureAllSatelliteStatus();
    }

    @Override
    public void destroy() {
        if (AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
    }

    @Override
    public void onWrenchClicked(yw entityplayer) {
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator iterator = this._lostItems.iterator();
        while (iterator.hasNext()) {
            LogisticsRequest request = new LogisticsRequest((ItemIdentifier)iterator.next(), 1, this.getRoutedPipe());
            if (!LogisticsManager.Request(request, ((RoutedPipe)this.container.pipe).getRouter().getRoutersByCost(), null)) continue;
            iterator.remove();
        }
    }

    @Override
    public void itemLost(ItemIdentifier item) {
        this._lostItems.add(item);
    }

    @Override
    public void itemArrived(ItemIdentifier item) {
    }
}

