/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht.forestry;

import buildcraft.krapht.forestry.ForestrySideSide;
import buildcraft.krapht.forestry.IForestryProxy;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import krapht.ItemIdentifier;

public class ForestryProxy
extends ForestrySideSide
implements IForestryProxy {
    private Class tileMachine;
    private Field machine_in_TileMachine;
    private Class analyserClass;
    private Class enumFilterTypeClass;
    private Method getBeeType;
    private Class stringUtil;
    private Method localize;
    private Class ForestryItem;
    private Field beeDroneGEField;
    private Field propolisField;
    private yr propolis;
    private boolean has_all;

    public ForestryProxy() {
        block2: {
            try {
                this.tileMachine = Class.forName("forestry.core.gadgets.TileMachine");
                this.machine_in_TileMachine = this.tileMachine.getDeclaredField("machine");
                this.machine_in_TileMachine.setAccessible(true);
                this.analyserClass = Class.forName("forestry.apiculture.MachineAnalyzer");
                this.enumFilterTypeClass = Class.forName("forestry.pipes.EnumFilterType");
                this.getBeeType = this.enumFilterTypeClass.getDeclaredMethod("getType", aan.class);
                this.getBeeType.setAccessible(true);
                this.stringUtil = Class.forName("forestry.core.utils.StringUtil");
                this.localize = this.stringUtil.getDeclaredMethod("localize", String.class);
                this.localize.setAccessible(true);
                this.ForestryItem = Class.forName("forestry.core.config.ForestryItem");
                this.beeDroneGEField = this.ForestryItem.getDeclaredField("beeDroneGE");
                this.beeDroneGEField.setAccessible(true);
                this.beeDroneGE = (yr)this.beeDroneGEField.get(null);
                this.propolisField = this.ForestryItem.getDeclaredField("propolis");
                this.propolisField.setAccessible(true);
                this.propolis = (yr)this.propolisField.get(null);
                this.has_all = true;
            }
            catch (Exception e) {
                if (!mod_LogisticsPipes.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isBee(ItemIdentifier item) {
        return this.isBee(item.makeNormalStack(1));
    }

    @Override
    public boolean isBee(aan item) {
        return BeeManager.beeInterface.isBee(item);
    }

    @Override
    public boolean isAnalysedBee(ItemIdentifier item) {
        return this.isAnalysedBee(item.makeNormalStack(1));
    }

    @Override
    public boolean isAnalysedBee(aan item) {
        if (!BeeManager.beeInterface.isBee(item)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(item).isAnalyzed();
    }

    public int getBeeAlleleCount() {
        return AlleleManager.alleleList.length;
    }

    @Override
    public boolean isTileAnalyser(kw tile) {
        block4: {
            if (!this.has_all) {
                return false;
            }
            try {
                Object obj;
                if (this.tileMachine.isAssignableFrom(tile.getClass()) && this.analyserClass.isAssignableFrom((obj = this.machine_in_TileMachine.get(tile)).getClass())) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!mod_LogisticsPipes.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean forestryEnabled() {
        return this.has_all;
    }

    @Override
    public boolean isVaildAlleleId(int id) {
        return AlleleManager.alleleList[id] != null;
    }

    @Override
    public boolean isKnownAlleleId(int id, xd world) {
        if (AlleleManager.alleleList[id] == null) {
            return false;
        }
        if (!((IAlleleSpecies)AlleleManager.alleleList[id]).isSecret()) {
            return true;
        }
        return BeeManager.breedingManager.getApiaristTracker(world).isDiscovered((IAlleleSpecies)AlleleManager.alleleList[id]);
    }

    @Override
    public String getAlleleName(int id) {
        if (AlleleManager.alleleList[id] == null) {
            return "";
        }
        return ((IAlleleSpecies)AlleleManager.alleleList[id]).getName();
    }

    @Override
    public int getFirstAlleleId(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return -1;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getPrimaryAsBee().getId();
    }

    @Override
    public int getSecondAlleleId(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return -1;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getSecondaryAsBee().getId();
    }

    @Override
    public boolean isDrone(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.isDrone(bee);
    }

    @Override
    public boolean isPrincess(aan bee) {
        if (!this.has_all) {
            return false;
        }
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        try {
            Object answer = this.getBeeType.invoke(null, bee);
            Enum enumAnswer = (Enum)answer;
            return enumAnswer.name().equals("PRINCESS");
        }
        catch (Exception e) {
            if (mod_LogisticsPipes.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean isQueen(aan bee) {
        if (!this.has_all) {
            return false;
        }
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        try {
            Object answer = this.getBeeType.invoke(null, bee);
            Enum enumAnswer = (Enum)answer;
            return enumAnswer.name().equals("QUEEN");
        }
        catch (Exception e) {
            if (mod_LogisticsPipes.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean isPurebred(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.SPECIES);
    }

    @Override
    public boolean isNocturnal(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getNocturnal();
    }

    @Override
    public boolean isPureNocturnal(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getNocturnal() && BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.NOCTURNAL);
    }

    @Override
    public boolean isFlyer(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getTolerantFlyer();
    }

    @Override
    public boolean isPureFlyer(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getTolerantFlyer() && BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.TOLERANT_FLYER);
    }

    @Override
    public boolean isCave(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getCaveDwelling();
    }

    @Override
    public boolean isPureCave(aan bee) {
        if (!BeeManager.beeInterface.isBee(bee)) {
            return false;
        }
        return BeeManager.beeInterface.getBee(bee).getGenome().getCaveDwelling() && BeeManager.beeInterface.getBee(bee).isPureBred(EnumBeeChromosome.CAVE_DWELLING);
    }

    @Override
    public String getForestryTranslation(String input) {
        if (!this.has_all) {
            return input;
        }
        try {
            return (String)this.localize.invoke(null, input.toLowerCase());
        }
        catch (Exception e) {
            if (mod_LogisticsPipes.DEBUG) {
                e.printStackTrace();
            }
            return input;
        }
    }

    @Override
    public void addCraftingRecipes() {
        if (!this.has_all) {
            return;
        }
        ModLoader.addRecipe((aan)new aan((yr)mod_LogisticsPipes.ModuleItem, 1, 8), (Object[])new Object[]{"CGC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('G'), BuildCraftCore.ironGearItem, Character.valueOf('r'), yr.aC, Character.valueOf('B'), new aan((yr)mod_LogisticsPipes.ModuleItem, 1, 0)});
        ModLoader.addRecipe((aan)new aan((yr)mod_LogisticsPipes.ModuleItem, 1, 9), (Object[])new Object[]{"CrC", "rBr", "CrC", Character.valueOf('C'), this.propolis, Character.valueOf('r'), yr.aC, Character.valueOf('B'), new aan((yr)mod_LogisticsPipes.ModuleItem, 1, 1)});
        ModLoader.addShapelessRecipe((aan)new aan(mod_LogisticsPipes.LogisticsApiaristAnalyserPipe, 1, 0), (Object[])new Object[]{new aan((yr)mod_LogisticsPipes.ModuleItem, 1, 8), new aan(mod_LogisticsPipes.LogisticsBasicPipe, 1, 0)});
        ModLoader.addShapelessRecipe((aan)new aan(mod_LogisticsPipes.LogisticsApiaristSinkPipe, 1, 0), (Object[])new Object[]{new aan((yr)mod_LogisticsPipes.ModuleItem, 1, 9), new aan(mod_LogisticsPipes.LogisticsBasicPipe, 1, 0)});
    }
}

