/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht;

import buildcraft.api.APIProxy;
import buildcraft.api.EntityPassiveItem;
import buildcraft.api.Orientations;
import buildcraft.api.SafeTimeTracker;
import buildcraft.core.CoreProxy;
import buildcraft.core.DefaultProps;
import buildcraft.core.Utils;
import buildcraft.core.network.PacketPipeTransportContent;
import buildcraft.krapht.RoutedPipe;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.network.PacketPipeLogisticsContent;
import buildcraft.krapht.routing.RoutedEntityItem;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.transport.EntityData;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import forge.NetworkMod;
import java.util.HashMap;
import java.util.Iterator;

public class PipeTransportLogistics
extends PipeTransportItems {
    private final int _bufferTimeOut = 40;
    private RoutedPipe _pipe = null;
    private final HashMap _itemBuffer = new HashMap();

    public PipeTransportLogistics() {
        this.allowBouncing = true;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this._itemBuffer.isEmpty()) {
            Iterator iterator = this._itemBuffer.keySet().iterator();
            while (iterator.hasNext()) {
                aan next = (aan)iterator.next();
                int currentTimeOut = (Integer)this._itemBuffer.get(next);
                if (currentTimeOut > 0) {
                    this._itemBuffer.put(next, currentTimeOut - 1);
                    continue;
                }
                EntityPassiveItem item = new EntityPassiveItem(this.container.pipe.worldObj, (double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + Utils.getPipeFloorOf((aan)next)) - 0.1, (double)this.zCoord + 0.5, next);
                IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(this.container.pipe.worldObj, item);
                routedItem.setDoNotBuffer(true);
                this.entityEntering(routedItem.getEntityPassiveItem(), Orientations.YPos);
                iterator.remove();
            }
        }
    }

    public void dropBuffer() {
        Iterator iterator = this._itemBuffer.keySet().iterator();
        while (iterator.hasNext()) {
            aan next = (aan)iterator.next();
            SimpleServiceLocator.buildCraftProxy.dropItems(this.container.i, next, this.xCoord, this.yCoord, this.zCoord);
            iterator.remove();
        }
    }

    public void entityEntering(EntityPassiveItem item, Orientations orientation) {
        SafeTimeTracker save = item.synchroTracker;
        item.synchroTracker = new SafeTimeTracker(){

            public boolean markTimeIfDelay(xd world, long delay) {
                return false;
            }
        };
        super.entityEntering(item, orientation);
        item.synchroTracker = save;
    }

    public Orientations resolveDestination(EntityData data) {
        if (this._pipe == null) {
            this._pipe = (RoutedPipe)this.container.pipe;
        }
        IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.GetOrCreateRoutedItem(this._pipe.worldObj, data);
        Orientations value = this._pipe.getRouteLayer().getOrientationForItem(routedItem);
        if (value == null && APIProxy.isRemote()) {
            routedItem.getItemStack().a = 0;
            return Orientations.Unknown;
        }
        if (value == null) {
            System.out.println("THIS IS NOT SUPPOSED TO HAPPEN!");
            return Orientations.Unknown;
        }
        if (value == Orientations.Unknown && !routedItem.getDoNotBuffer()) {
            if (APIProxy.isServerSide()) {
                CoreProxy.sendToPlayers((abs)this.createItemPacket(routedItem.getEntityPassiveItem(), value), (xd)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (int)DefaultProps.NETWORK_UPDATE_RANGE, (NetworkMod)mod_BuildCraftTransport.instance);
            }
            this._itemBuffer.put(routedItem.getItemStack().k(), 40);
            this.scheduleRemoval(data.item);
            return Orientations.XNeg;
        }
        this.readjustSpeed(routedItem.getEntityPassiveItem());
        if (APIProxy.isServerSide()) {
            CoreProxy.sendToPlayers((abs)this.createItemPacket(routedItem.getEntityPassiveItem(), value), (xd)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (int)DefaultProps.NETWORK_UPDATE_RANGE, (NetworkMod)mod_BuildCraftTransport.instance);
        }
        if (value == Orientations.Unknown) {
            data.item.speed = Math.min(data.item.speed, Utils.pipeNormalSpeed * 5.0f);
        }
        return value;
    }

    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this._itemBuffer.clear();
        no nbttaglist = nbttagcompound.n("buffercontents");
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            this._itemBuffer.put(aan.a((ady)nbttagcompound1), 40);
        }
    }

    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        no nbttaglist = new no();
        for (aan stack : this._itemBuffer.keySet()) {
            ady nbttagcompound1 = new ady();
            stack.b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("buffercontents", (gh)nbttaglist);
    }

    public void readjustSpeed(EntityPassiveItem item) {
        if (SimpleServiceLocator.buildCraftProxy.isRoutedItem(item)) {
            IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.GetRoutedItem(item);
            float defaultBoost = 1.0f;
            switch (routedItem.getTransportMode()) {
                case Default: {
                    defaultBoost = 10.0f;
                    break;
                }
                case Passive: {
                    defaultBoost = 20.0f;
                    break;
                }
                case Active: {
                    defaultBoost = 30.0f;
                }
            }
            item.speed = Math.max(item.speed, Utils.pipeNormalSpeed * defaultBoost);
        }
    }

    public void handleItemPacket(PacketPipeTransportContent packet) {
        if (packet.getID() != 2) {
            return;
        }
        if (!PacketPipeLogisticsContent.isPacket(packet)) {
            super.handleItemPacket(packet);
            return;
        }
        EntityPassiveItem item = EntityPassiveItem.getOrCreate((xd)this.worldObj, (int)packet.getEntityId());
        item.item = new aan(packet.getItemId(), packet.getStackSize(), packet.getItemDamage());
        item.setPosition(packet.getPosX(), packet.getPosY(), packet.getPosZ());
        item.speed = packet.getSpeed();
        item.deterministicRandomization = packet.getRandomization();
        if (SimpleServiceLocator.buildCraftProxy.isRoutedItem(item)) {
            if (item.container != this.container || !this.travelingEntities.containsKey(item.entityId)) {
                if (item.container != null) {
                    ((PipeTransportItems)((TileGenericPipe)item.container).pipe.transport).scheduleRemoval(item);
                }
                this.travelingEntities.put(new Integer(item.entityId), new EntityData(item, packet.getOrientation()));
                item.container = this.container;
            } else {
                ((EntityData)this.travelingEntities.get((Object)new Integer((int)item.entityId))).item = item;
                ((EntityData)this.travelingEntities.get((Object)new Integer((int)item.entityId))).orientation = packet.getOrientation();
            }
            PacketPipeLogisticsContent newpacket = new PacketPipeLogisticsContent(packet);
            IRoutedItem routed = SimpleServiceLocator.buildCraftProxy.GetRoutedItem(item);
            routed.setSource(newpacket.getSourceUUID(this.worldObj));
            routed.setDestination(newpacket.getDestUUID(this.worldObj));
            return;
        }
        PacketPipeLogisticsContent newpacket = new PacketPipeLogisticsContent(packet);
        IRoutedItem routed = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(this.worldObj, item);
        routed.setSource(newpacket.getSourceUUID(this.worldObj));
        routed.setDestination(newpacket.getDestUUID(this.worldObj));
        item = routed.getEntityPassiveItem();
        if (item.container != this.container || !this.travelingEntities.containsKey(item.entityId)) {
            if (item.container != null) {
                ((PipeTransportItems)((TileGenericPipe)item.container).pipe.transport).scheduleRemoval(item);
            }
            this.travelingEntities.put(new Integer(item.entityId), new EntityData(item, packet.getOrientation()));
            item.container = this.container;
        } else {
            ((EntityData)this.travelingEntities.get((Object)new Integer((int)item.entityId))).item = item;
            ((EntityData)this.travelingEntities.get((Object)new Integer((int)item.entityId))).orientation = packet.getOrientation();
        }
    }

    public abs createItemPacket(EntityPassiveItem item, Orientations orientation) {
        if (item instanceof RoutedEntityItem) {
            item.deterministicRandomization += this.worldObj.r.nextInt(6);
            PacketPipeLogisticsContent packet = new PacketPipeLogisticsContent(this.container.j, this.container.k, this.container.l, (RoutedEntityItem)item, orientation);
            return packet.getPacket();
        }
        return super.createItemPacket(item, orientation);
    }
}

