/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht;

import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.LogisticsPromise;
import java.util.LinkedList;
import krapht.ItemIdentifier;

public class LogisticsRequest {
    private ItemIdentifier _item;
    private int _count;
    private IRequestItems _destination;
    private LinkedList _promises = new LinkedList();
    private LinkedList _extraPromises = new LinkedList();

    public LogisticsRequest(ItemIdentifier item, int numberOfItems, IRequestItems destination) {
        this._item = item;
        this._count = numberOfItems;
        this._destination = destination;
    }

    public ItemIdentifier getItem() {
        return this._item;
    }

    public int numberLeft() {
        return this._count;
    }

    public void reduceNumberLeft() {
        --this._count;
    }

    public void reduceNumberLeft(int count) {
        this._count -= count;
    }

    public int notYetAllocated() {
        int totalAllocated = 0;
        for (LogisticsPromise promise : this._promises) {
            totalAllocated += promise.numberOfItems;
        }
        return this._count - totalAllocated;
    }

    public boolean isReady() {
        return this.notYetAllocated() < 1;
    }

    public boolean isComplete() {
        return this._count < 1;
    }

    public IRequestItems getDestination() {
        return this._destination;
    }

    public void addPromise(LogisticsPromise promise) {
        if (mod_LogisticsPipes.DisplayRequests) {
            System.out.println("Adding promise of " + promise.numberOfItems + " " + promise.item.getFriendlyName());
        }
        if (promise.numberOfItems < 1) {
            return;
        }
        if (promise.numberOfItems > this.notYetAllocated()) {
            LogisticsPromise extrasPromise = new LogisticsPromise();
            extrasPromise.numberOfItems = promise.numberOfItems - this.notYetAllocated();
            extrasPromise.item = promise.item;
            extrasPromise.sender = promise.sender;
            promise.numberOfItems = this.notYetAllocated();
            this._extraPromises.add(extrasPromise);
            if (mod_LogisticsPipes.DisplayRequests) {
                System.out.println("\treduced promise to " + promise.numberOfItems);
            }
            if (mod_LogisticsPipes.DisplayRequests) {
                System.out.println("\tAdding EXTRA promise of " + extrasPromise.numberOfItems + " " + extrasPromise.item.getFriendlyName());
            }
        }
        this._promises.add(promise);
    }

    public LinkedList getPromises() {
        return this._promises;
    }

    public int getExtrasCount() {
        int count = 0;
        for (LogisticsPromise extra : this._extraPromises) {
            count += extra.numberOfItems;
        }
        return count;
    }

    public LinkedList getExtras() {
        return (LinkedList)this._extraPromises.clone();
    }

    public void usePromise(LogisticsPromise promise) {
        if (this._extraPromises.contains(promise)) {
            if (mod_LogisticsPipes.DisplayRequests) {
                System.out.println("\tUsing promise of " + promise.numberOfItems + " " + promise.item.getFriendlyName());
            }
            this._extraPromises.remove(promise);
        }
    }
}

