/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.krapht;

import buildcraft.api.APIProxy;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.core.CoreProxy;
import buildcraft.core.Utils;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.krapht.IRequestItems;
import buildcraft.krapht.PipeTransportLogistics;
import buildcraft.krapht.SimpleServiceLocator;
import buildcraft.krapht.logic.BaseRoutingLogic;
import buildcraft.krapht.network.PacketPipeInteger;
import buildcraft.krapht.routing.IRouter;
import buildcraft.krapht.routing.RoutedEntityItem;
import buildcraft.logisticspipes.IAdjacentWorldAccess;
import buildcraft.logisticspipes.IRoutedItem;
import buildcraft.logisticspipes.ITrackStatistics;
import buildcraft.logisticspipes.PipeTransportLayer;
import buildcraft.logisticspipes.RouteLayer;
import buildcraft.logisticspipes.TransportLayer;
import buildcraft.logisticspipes.modules.ILogisticsModule;
import buildcraft.logisticspipes.modules.IWorldProvider;
import buildcraft.logisticspipes.modules.ModuleExtractor;
import buildcraft.logisticspipes.modules.ModuleItemSink;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogic;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import krapht.AdjacentTile;
import krapht.Pair;
import krapht.WorldUtil;

public abstract class CoreRoutedPipe
extends Pipe
implements IRequestItems,
IAdjacentWorldAccess,
ITrackStatistics,
IWorldProvider {
    private IRouter router;
    private String routerId;
    private static int pipecount = 0;
    private int _delayOffset = 0;
    protected int _nextTexture = this.getCenterTexture();
    private boolean _initialInit = true;
    private boolean enabled = true;
    private RouteLayer _routeLayer;
    protected TransportLayer _transportLayer;
    public int stat_session_sent;
    public int stat_session_recieved;
    public int stat_session_relayed;
    public long stat_lifetime_sent;
    public long stat_lifetime_recieved;
    public long stat_lifetime_relayed;
    private final LinkedList _sendQueue = new LinkedList();

    public CoreRoutedPipe(BaseRoutingLogic logic, int itemID) {
        super((PipeTransport)new PipeTransportLogistics(), (PipeLogic)logic, itemID);
        ((PipeTransportItems)this.transport).allowBouncing = true;
        this._delayOffset = ++pipecount % core_LogisticsPipes.LOGISTICS_DETECTION_FREQUENCY;
    }

    public RouteLayer getRouteLayer() {
        if (this._routeLayer == null) {
            this._routeLayer = new RouteLayer(this.getRouter(), this.getTransportLayer());
        }
        return this._routeLayer;
    }

    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new PipeTransportLayer(this, this, this.getRouter());
        }
        return this._transportLayer;
    }

    public void queueRoutedItem(IRoutedItem routedItem, Orientations from) {
        this._sendQueue.addLast(new Pair(routedItem, from));
    }

    private void sendRoutedItem(IRoutedItem routedItem, Orientations from) {
        Position p = new Position((double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + Utils.getPipeFloorOf((aan)routedItem.getItemStack()) + 0.5f), (double)((float)this.zCoord + 0.5f), from);
        p.moveForwards(0.5);
        routedItem.SetPosition(p.x, p.y, p.z);
        ((PipeTransportItems)this.transport).entityEntering(routedItem.getEntityPassiveItem(), from.reverse());
        this.router.startTrackingRoutedItem((RoutedEntityItem)routedItem.getEntityPassiveItem());
        ++this.stat_lifetime_sent;
        ++this.stat_session_sent;
    }

    public abstract ItemSendMode getItemSendMode();

    public void updateEntity() {
        super.updateEntity();
        this.getRouter().update(this.worldObj.w() % (long)core_LogisticsPipes.LOGISTICS_DETECTION_FREQUENCY == (long)this._delayOffset || this._initialInit);
        this._initialInit = false;
        if (!this._sendQueue.isEmpty()) {
            if (this.getItemSendMode() == ItemSendMode.Normal) {
                Pair itemToSend = (Pair)this._sendQueue.getFirst();
                this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (Orientations)itemToSend.getValue2());
                this._sendQueue.removeFirst();
            } else if (this.getItemSendMode() == ItemSendMode.Fast) {
                for (int i = 0; i < 64; ++i) {
                    if (this._sendQueue.isEmpty()) continue;
                    Pair itemToSend = (Pair)this._sendQueue.getFirst();
                    this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (Orientations)itemToSend.getValue2());
                    this._sendQueue.removeFirst();
                }
            } else {
                if (this.getItemSendMode() == null) {
                    throw new UnsupportedOperationException("getItemSendMode() can't return null. " + this.getClass().getName());
                }
                throw new UnsupportedOperationException("getItemSendMode() returned unhandled value. " + this.getItemSendMode().name() + " in " + this.getClass().getName());
            }
        }
        if (this.getLogisticsModule() == null) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.getLogisticsModule().tick();
    }

    public void onBlockRemoval() {
        try {
            super.onBlockRemoval();
            if (this.getRouter() != null) {
                this.getRouter().destroy();
            }
            if (this.logic instanceof BaseRoutingLogic) {
                ((BaseRoutingLogic)this.logic).destroy();
            }
            pipecount = Math.max(pipecount - 1, 0);
            if (this.transport != null && this.transport instanceof PipeTransportLogistics) {
                ((PipeTransportLogistics)this.transport).dropBuffer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract int getCenterTexture();

    public final void prepareTextureFor(Orientations connection) {
        if (connection == Orientations.Unknown || this.router == null) {
            this._nextTexture = this.getCenterTexture();
            return;
        }
        this._nextTexture = this.router.isRoutedExit(connection) ? this.getRoutedTexture(connection) : this.getNonRoutedTexture(connection);
    }

    public int getRoutedTexture(Orientations connection) {
        return core_LogisticsPipes.LOGISTICSPIPE_ROUTED_TEXTURE;
    }

    public int getNonRoutedTexture(Orientations connection) {
        return core_LogisticsPipes.LOGISTICSPIPE_NOTROUTED_TEXTURE;
    }

    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.routerId == null || this.routerId == "") {
            this.routerId = UUID.randomUUID().toString();
        }
        nbttagcompound.a("routerId", this.routerId);
        nbttagcompound.a("stat_lifetime_sent", this.stat_lifetime_sent);
        nbttagcompound.a("stat_lifetime_recieved", this.stat_lifetime_recieved);
        nbttagcompound.a("stat_lifetime_relayed", this.stat_lifetime_relayed);
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().writeToNBT(nbttagcompound, "");
        }
    }

    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.routerId = nbttagcompound.j("routerId");
        this.stat_lifetime_sent = nbttagcompound.g("stat_lifetime_sent");
        this.stat_lifetime_recieved = nbttagcompound.g("stat_lifetime_recieved");
        this.stat_lifetime_relayed = nbttagcompound.g("stat_lifetime_relayed");
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().readFromNBT(nbttagcompound, "");
        }
    }

    @Override
    public IRouter getRouter() {
        if (this.router == null) {
            if (this.routerId == null || this.routerId == "") {
                this.routerId = UUID.randomUUID().toString();
            }
            this.router = SimpleServiceLocator.routerManager.getOrCreateRouter(UUID.fromString(this.routerId), this.worldObj.B().i(), this.xCoord, this.yCoord, this.zCoord);
        }
        return this.router;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void onNeighborBlockChange_Logistics() {
    }

    public void onBlockPlaced() {
        super.onBlockPlaced();
    }

    public abstract ILogisticsModule getLogisticsModule();

    public boolean blockActivated(xd world, int i, int j, int k, yw entityplayer) {
        if (entityplayer.av() != null && entityplayer.av().a() == BuildCraftCore.wrenchItem && !entityplayer.V() && this.getLogisticsModule() != null && this.getLogisticsModule().getGuiHandlerID() != -1) {
            if (!APIProxy.isClient((xd)entityplayer.k)) {
                entityplayer.openGui((BaseMod)mod_LogisticsPipes.instance, this.getLogisticsModule().getGuiHandlerID(), world, this.xCoord, this.yCoord, this.zCoord);
                if (APIProxy.isServerSide() && this.getLogisticsModule() instanceof ModuleItemSink) {
                    CoreProxy.sendToPlayer((yw)entityplayer, (BuildCraftPacket)new PacketPipeInteger(17, this.xCoord, this.yCoord, this.zCoord, ((ModuleItemSink)this.getLogisticsModule()).isDefaultRoute() ? 1 : 0));
                }
                if (APIProxy.isServerSide() && this.getLogisticsModule() instanceof ModuleExtractor) {
                    CoreProxy.sendToPlayer((yw)entityplayer, (BuildCraftPacket)new PacketPipeInteger(25, this.xCoord, this.yCoord, this.zCoord, ((ModuleExtractor)this.getLogisticsModule()).getSneakyOrientation().ordinal()));
                }
                return true;
            }
            return false;
        }
        return super.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public LinkedList getConnectedEntities() {
        WorldUtil world = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        LinkedList adjacent = world.getAdjacentTileEntities();
        Iterator iterator = adjacent.iterator();
        while (iterator.hasNext()) {
            AdjacentTile tile = (AdjacentTile)iterator.next();
            if (SimpleServiceLocator.buildCraftProxy.checkPipesConnections((kw)this.container, tile.tile)) continue;
            iterator.remove();
        }
        return adjacent;
    }

    @Override
    public int getRandomInt(int maxSize) {
        return this.worldObj.r.nextInt(maxSize);
    }

    @Override
    public void recievedItem(int count) {
        this.stat_session_recieved += count;
        this.stat_lifetime_recieved += (long)count;
    }

    @Override
    public xd getWorld() {
        return this.worldObj;
    }

    protected static enum ItemSendMode {
        Normal,
        Fast;

    }
}

