/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.IChargeConductor;
import factorization.common.Core;
import factorization.common.CubeFace;
import factorization.common.RenderingCube;
import factorization.common.TileEntityWire;
import java.util.ArrayList;

public class WireConnections {
    TileEntityWire me;
    CubeFace my_face;
    DeltaCoord my_face_vector;
    Coord here;
    long edges = 0L;
    long faces = 0L;
    boolean center_core = false;
    static final float h = 2.0f;
    static final float w = 4.0f;
    static RenderingCube base_face = WireConnections.cube(new RenderingCube.Vector(4.0f, 2.0f, 4.0f), new RenderingCube.Vector(0.0f, -6.0f, 0.0f));
    static RenderingCube base_face_side = base_face.copy().rotate(1.0f, 0.0f, 0.0f, 90).normalize();
    static RenderingCube[] face_map = new RenderingCube[]{base_face.copy(), base_face.rotate(1.0f, 0.0f, 0.0f, 180).normalize(), base_face_side.rotate(0.0f, 1.0f, 0.0f, 0).normalize(), base_face_side.rotate(0.0f, 1.0f, 0.0f, 180).normalize(), base_face_side.rotate(0.0f, 1.0f, 0.0f, 90).normalize(), base_face_side.rotate(0.0f, 1.0f, 0.0f, 270).normalize()};
    static RenderingCube bottom_edge = WireConnections.cube(new RenderingCube.Vector(4.0f, 2.0f, 2.0f), new RenderingCube.Vector(0.0f, -6.0f, 6.0f));
    static RenderingCube top_edge = bottom_edge.copy().rotate(1.0f, 0.0f, 0.0f, 180).normalize();
    static RenderingCube side_edge = bottom_edge.copy().rotate(0.0f, 0.0f, 1.0f, 90).normalize();
    static RenderingCube[] edge_map = new RenderingCube[]{bottom_edge.rotate(0.0f, 1.0f, 0.0f, 180).normalize(), bottom_edge.rotate(0.0f, 1.0f, 0.0f, 90).normalize(), bottom_edge.rotate(0.0f, 1.0f, 0.0f, 0).normalize(), bottom_edge.rotate(0.0f, 1.0f, 0.0f, 270).normalize(), top_edge.rotate(0.0f, 1.0f, 0.0f, 0).normalize(), top_edge.rotate(0.0f, 1.0f, 0.0f, 270).normalize(), top_edge.rotate(0.0f, 1.0f, 0.0f, 180).normalize(), top_edge.rotate(0.0f, 1.0f, 0.0f, 90).normalize(), side_edge.rotate(0.0f, 1.0f, 0.0f, 90).normalize(), side_edge.rotate(0.0f, 1.0f, 0.0f, 0).normalize(), side_edge.rotate(0.0f, 1.0f, 0.0f, 270).normalize(), side_edge.rotate(0.0f, 1.0f, 0.0f, 180).normalize()};

    public WireConnections(TileEntityWire me) {
        this.me = me;
        this.my_face = new CubeFace(me.supporting_side);
        this.my_face_vector = this.my_face.toVector();
        this.here = me.getCoord();
        Core.profileStart("factoryWire");
        this.calculate();
        Core.profileEnd();
    }

    void calculate() {
        int wire_neighbor_count = 0;
        for (DeltaCoord d : DeltaCoord.directNeighbors) {
            Coord nc = this.here.add(d);
            TileEntityWire n = (TileEntityWire)nc.getTE(TileEntityWire.class);
            CubeFace delta_face = CubeFace.fromVector(d);
            if (n != null) {
                CubeFace neighbor_face = new CubeFace(n.supporting_side);
                this.addNeighbor(d, n, neighbor_face, delta_face);
                ++wire_neighbor_count;
                continue;
            }
            IChargeConductor c = (IChargeConductor)nc.getTE(IChargeConductor.class);
            if (c == null) continue;
            if (delta_face.equals(this.my_face)) {
                this.faces |= this.my_face.getFaceFlag();
                continue;
            }
            if (delta_face.opposite().equals(this.my_face)) {
                this.faces |= this.my_face.getFaceFlag() | delta_face.getFaceFlag();
                this.center_core = true;
                continue;
            }
            this.edges |= this.my_face.getEdgeFlags() & delta_face.getEdgeFlags();
            this.faces |= this.my_face.getFaceFlag();
        }
        if (this.faces == 0L && this.edges == 0L) {
            this.faces = this.my_face.getFaceFlag();
            return;
        }
        if (this.faces == 0L && Long.bitCount(this.edges) == 1 && wire_neighbor_count == 1) {
            this.faces = this.my_face.getFaceFlag();
        }
        for (int side = 0; side < 6; ++side) {
            if (Long.bitCount(this.edges & CubeFace.getEdgeFlags(side)) <= 1) continue;
            this.faces |= (long)(1 << side);
        }
        if (Long.bitCount(this.edges) > 1 && this.faces == 0L) {
            this.faces = this.my_face.getFaceFlag();
        }
    }

    void addNeighbor(DeltaCoord neighbor, TileEntityWire nte, CubeFace neighbor_face, CubeFace delta_face) {
        long edge_to_add = delta_face.getEdgeFlags() & this.my_face.getEdgeFlags();
        if (edge_to_add == 0L) {
            edge_to_add = delta_face.getEdgeFlags() & neighbor_face.getEdgeFlags();
            if (Long.bitCount(edge_to_add) > 1) {
                this.center_core = true;
                this.faces |= delta_face.getFaceFlag() | this.my_face.getFaceFlag();
            } else {
                this.edges |= edge_to_add;
                this.faces |= neighbor_face.getFaceFlag();
                this.edges |= neighbor_face.getEdgeFlags() & this.my_face.getEdgeFlags();
            }
        } else if (Long.bitCount(edge_to_add) > 1) {
            this.edges |= neighbor_face.getEdgeFlags() & this.my_face.getEdgeFlags();
        } else {
            this.edges |= edge_to_add;
            if (neighbor.isSubmissive() && Long.bitCount(edge_to_add = neighbor_face.getEdgeFlags() & delta_face.getEdgeFlags()) == 1) {
                this.edges |= edge_to_add;
            }
        }
    }

    int getComplexity() {
        return Long.bitCount(this.edges) + Long.bitCount(this.faces) * 2 + (this.center_core ? 4 : 0);
    }

    static RenderingCube cube(RenderingCube.Vector corner, RenderingCube.Vector origin) {
        int icon = 11;
        return new RenderingCube(11, corner, origin);
    }

    public Iterable getParts() {
        ArrayList<RenderingCube> ret = new ArrayList<RenderingCube>(20);
        if (this.center_core) {
            ret.add(WireConnections.cube(new RenderingCube.Vector(4.0f, 4.0f, 4.0f), null));
        }
        for (int face_index = 0; face_index < 6; ++face_index) {
            if ((this.faces & (long)(1 << face_index)) == 0L) continue;
            ret.add(face_map[face_index].copy());
        }
        for (int edge_index = 0; edge_index < 12; ++edge_index) {
            if ((this.edges & (long)(1 << edge_index)) == 0L) continue;
            ret.add(edge_map[edge_index].copy());
        }
        return ret;
    }

    public static Iterable getInventoryParts() {
        ArrayList<RenderingCube> ret = new ArrayList<RenderingCube>(2);
        ret.add(face_map[0].copy());
        ret.add(edge_map[0].copy());
        ret.add(edge_map[1].copy());
        ret.add(edge_map[3].copy());
        ret.add(face_map[2].copy());
        return ret;
    }

    private void getExtremes(RenderingCube cube, RenderingCube.Vector min, RenderingCube.Vector max) {
        for (int face = 0; face < 6; ++face) {
            for (RenderingCube.Vector v : cube.faceVerts(face)) {
                min.x = Math.min(v.x, min.x);
                min.y = Math.min(v.y, min.y);
                min.z = Math.min(v.z, min.z);
                max.x = Math.max(v.x, max.x);
                max.y = Math.max(v.y, max.y);
                max.z = Math.max(v.z, max.z);
            }
        }
    }

    public void setBlockBounds(aig block2) {
        RenderingCube.Vector min = null;
        RenderingCube.Vector max = null;
        boolean first = true;
        for (RenderingCube part : this.getParts()) {
            if (first) {
                first = false;
                min = max = part.faceVerts(0)[2];
                max = part.faceVerts(0)[1];
            }
            this.getExtremes(part, min, max);
        }
        min = min.add(8, 8, 8);
        max = max.add(8, 8, 8);
        min.scale(0.0625f);
        max.scale(0.0625f);
        float d = 0.0f;
        block2.a(min.x + d, min.y + d, min.z + d, max.x + d, max.y + d, max.z + d);
    }

    public ajq collisionRayTrace(up w, int x, int y, int z, ajs startVec, ajs endVec) {
        for (RenderingCube part : this.getParts()) {
            part.toBlockBounds(Core.registry.resource_block);
            ajq ret = Core.registry.resource_block.a(w, x, y, z, startVec, endVec);
            if (ret == null) continue;
            Core.registry.resource_block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return ret;
        }
        Core.registry.resource_block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return null;
    }

    public void conductorRestrict() {
        this.faces = 0L;
        this.center_core = false;
    }
}

