/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PriorityQueue;

public class TileEntityWrathLamp
extends TileEntityCommon {
    static final int radius = 6;
    static final int radiusSq = 36;
    static final int diameter = 12;
    static final int maxDepth = 24;
    private short[] beamDepths = new short[169];
    private Updater updater = new InitialBuild();
    static int update_count;
    static final int update_limit = 64;
    static PriorityQueue airToUpdate;
    static final int[] deltas;
    static HashSet toVisit;

    public static void handleAirUpdates() {
        update_count = 0;
        while (update_count < 64 && airToUpdate.size() > 0) {
            ((Coord)airToUpdate.remove()).check();
        }
    }

    static void doAirCheck(up w, int x, int y, int z) {
        if (update_count > 64) {
            airToUpdate.add(new Coord(w, x, y, z));
            return;
        }
        TileEntityWrathLamp lamp = TileEntityWrathLamp.findLightAirParent(w, x, y, z);
        if (lamp == null) {
            ++update_count;
            w.e(x, y, z, 0);
        } else {
            lamp.activate(y);
        }
    }

    private int getDepthIndex(int x, int z) {
        int dx = this.l - x;
        int dz = this.n - z;
        dz += 6;
        if ((dx += 6) < 0 || dx > 12) {
            throw new IndexOutOfBoundsException("x = " + dx);
        }
        if (dz < 0 || dz > 12) {
            throw new IndexOutOfBoundsException("z = " + dz);
        }
        return dx + dz * 12;
    }

    static TileEntityWrathLamp findLightAirParent(up world, int x, int y, int z) {
        toVisit.clear();
        for (int dcx : deltas) {
            for (int dcz : deltas) {
                wl chunk = world.d(x + dcx, z + dcz);
                if (chunk == null) continue;
                toVisit.add(chunk);
            }
        }
        for (wl chunk : toVisit) {
            for (Object o : chunk.i.values()) {
                TileEntityWrathLamp lamp;
                if (!(o instanceof TileEntityWrathLamp) || !(lamp = (TileEntityWrathLamp)o).lightsBlock(x, y, z)) continue;
                return lamp;
            }
        }
        return null;
    }

    private boolean inArea(int x, int y, int z) {
        if (y > this.m) {
            return false;
        }
        if (y < this.m - 24) {
            return false;
        }
        return this.l - 6 <= x && x <= this.l + 6 && this.n - 6 <= z && z <= this.n + 6;
    }

    private boolean lightsBlock(int x, int y, int z) {
        if (!this.inArea(x, y, z)) {
            return false;
        }
        short depth = this.beamDepths[this.getDepthIndex(x, z)];
        return y >= depth && depth != -1;
    }

    public void g() {
        Core.profileStart("WrathLamp");
        this.updater = this.updater.update();
        Core.profileEnd();
    }

    public void j() {
        super.j();
        Core.profileStart("WrathLamp");
        for (int x = this.l - 6; x <= this.l + 6; ++x) {
            for (int z = this.n - 6; z <= this.n + 6; ++z) {
                int id = this.k.a(x, this.m, z);
                if (id != Core.lightair_id) continue;
                this.k.e(x, this.m, z, 0);
            }
        }
        Core.profileEnd();
        if (this.k.K) {
            RelightTask task = new RelightTask(this.k);
            task.b(this.l, this.m, this.n);
            this.k.d((jn)task);
        }
    }

    double dist(int x, int y, int z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    boolean eq(double a, double b) {
        return Math.abs(a - b) < 0.9;
    }

    float div(int a, int b) {
        if (b == 0) {
            return Math.signum(a) * 4095.0f;
        }
        return a / b;
    }

    boolean myTrace(int x, int z) {
        int dx = x - this.l;
        int dz = z - this.n;
        float idealm = this.div(dz, dx);
        float old_dist = Float.MAX_VALUE;
        while (x != this.l || z != this.n) {
            int id = this.k.a(x, this.m, z);
            if (aig.m[id] != null && aig.m[id].d() && aig.o[id] != 0) {
                return false;
            }
            dx = x - this.l;
            dz = z - this.n;
            float m = this.div(dz, dx);
            int addx = (int)(-Math.signum(dx));
            int addz = (int)(-Math.signum(dz));
            if (addx == 0 && addz == 0) {
                return true;
            }
            if (addx == 0) {
                z += addz;
                continue;
            }
            if (addz == 0) {
                x += addx;
                continue;
            }
            float m_x = this.div(dz, dx + addx);
            float m_z = this.div(dz + addz, dx);
            if (Math.abs(idealm - m_x) <= Math.abs(idealm - m_z)) {
                x += addx;
                continue;
            }
            z += addz;
        }
        return true;
    }

    boolean clearTo(int x, int y, int z) {
        return this.myTrace(x, z);
    }

    @Override
    public void neighborChanged() {
        this.activate(this.m);
    }

    void activate(int at_height) {
        this.updater = this.updater.getActive(at_height);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LAMP;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Lamp;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    static {
        airToUpdate = new PriorityQueue(1024);
        deltas = new int[]{0, -16, 16};
        toVisit = new HashSet(45);
    }

    public static class RelightTask
    extends jn {
        int delay;

        public RelightTask(up par1World) {
            super(par1World);
        }

        protected void a() {
            this.delay = 40;
        }

        protected void a(an var1) {
        }

        protected void b(an var1) {
        }

        public void h_() {
            --this.delay;
            if (this.delay == 0) {
                factorization.api.Coord here = new factorization.api.Coord(this);
                int r = 21;
                int x = (int)(this.t - (double)r);
                while ((double)x <= this.t + (double)r) {
                    int z = (int)(this.v - (double)r);
                    while ((double)z <= this.v + (double)r) {
                        int y = (int)this.u;
                        while ((double)y >= this.u - 24.0) {
                            this.p.x(x, y, z);
                            --y;
                        }
                        ++z;
                    }
                    ++x;
                }
                this.y();
            }
        }
    }

    class Idler
    extends Updater {
        Idler() {
        }

        boolean couldUpdate(int dx, int dz) {
            return TileEntityWrathLamp.this.k.a(TileEntityWrathLamp.this.l + dx, TileEntityWrathLamp.this.m, TileEntityWrathLamp.this.n + dz) == 0;
        }

        @Override
        public Updater update() {
            if (this.couldUpdate(0, 1) || this.couldUpdate(0, -1) || this.couldUpdate(1, 0) || this.couldUpdate(-1, 0)) {
                return new InitialBuild();
            }
            return this;
        }

        @Override
        Updater getActive(int start_height) {
            InitialBuild r = new InitialBuild();
            r.start_height = Math.max(r.start_height, start_height);
            return r;
        }
    }

    class InitialBuild
    extends Updater {
        int height;
        int start_delay;
        Updater next_updater;

        InitialBuild() {
            this.height = -100;
            this.start_delay = 20;
            this.next_updater = new Idler();
        }

        @Override
        public Updater update() {
            int z;
            int x;
            if (this.start_delay >= 0) {
                --this.start_delay;
                return this;
            }
            this.height = this.height == -100 ? (this.start_height == -100 ? TileEntityWrathLamp.this.m : this.start_height) : --this.height;
            if (this.height < TileEntityWrathLamp.this.m - 24) {
                return this.next_updater;
            }
            if (this.height == TileEntityWrathLamp.this.m) {
                Arrays.fill(TileEntityWrathLamp.this.beamDepths, (short)0);
                for (x = TileEntityWrathLamp.this.l - 6; x <= TileEntityWrathLamp.this.l + 6; ++x) {
                    for (z = TileEntityWrathLamp.this.n - 6; z <= TileEntityWrathLamp.this.n + 6; ++z) {
                        if (TileEntityWrathLamp.this.clearTo(x, TileEntityWrathLamp.this.m, z)) continue;
                        ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[((TileEntityWrathLamp)TileEntityWrathLamp.this).getDepthIndex((int)x, (int)z)] = -1;
                    }
                }
            }
            for (x = TileEntityWrathLamp.this.l - 6; x <= TileEntityWrathLamp.this.l + 6; ++x) {
                for (z = TileEntityWrathLamp.this.n - 6; z <= TileEntityWrathLamp.this.n + 6; ++z) {
                    int index = TileEntityWrathLamp.this.getDepthIndex(x, z);
                    if (TileEntityWrathLamp.this.beamDepths[index] != 0) continue;
                    int block2 = TileEntityWrathLamp.this.k.a(x, this.height, z);
                    if (block2 == 0) {
                        TileEntityWrathLamp.this.k.e(x, this.height, z, Core.lightair_id);
                        continue;
                    }
                    if (block2 == Core.lightair_id || x == TileEntityWrathLamp.this.l && this.height == TileEntityWrathLamp.this.m && z == TileEntityWrathLamp.this.n) continue;
                    ((TileEntityWrathLamp)TileEntityWrathLamp.this).beamDepths[index] = (short)this.height;
                }
            }
            if (this.height == 0) {
                return this.next_updater;
            }
            return this;
        }

        @Override
        Updater getActive(int start_height) {
            if (!(this.next_updater instanceof InitialBuild)) {
                this.next_updater = new InitialBuild();
            }
            this.next_updater.start_height = Math.max(start_height, this.next_updater.start_height);
            return this;
        }
    }

    abstract class Updater {
        int start_height = -100;

        Updater() {
        }

        abstract Updater update();

        abstract Updater getActive(int var1);
    }

    private static class Coord
    implements Comparable {
        up w;
        int x;
        int y;
        int z;

        Coord(up w, int x, int y, int z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        void check() {
            TileEntityWrathLamp.doAirCheck(this.w, this.x, this.y, this.z);
        }

        public int compareTo(Coord o) {
            return o.y - this.y;
        }
    }
}

