/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.common.BlockLightAir;
import factorization.common.Core;
import factorization.common.ResourceType;
import factorization.common.Sound;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class TileEntityWrathFire
extends aji
implements ICoord {
    final int max_generation = 45;
    final int max_age = 35;
    static Random rand = new Random();
    static final List deltas = Arrays.asList(-1, 0, 1);
    public static HashMap transforms = new HashMap();
    static BlockMatch air = new BlockMatch(0, -1);
    static BlockMatch fire = new BlockMatch((aig)aig.ar);
    static BlockMatch netherBrick = new BlockMatch(aig.bA);
    static BlockMatch netherFence = new BlockMatch(aig.bB);
    static BlockMatch netherStair = new BlockMatch(aig.bC);
    BlockMatch host = null;
    int age = 0;
    int generation = 0;
    int random_time_offset = rand.nextInt();
    public static int updateCount = 0;

    public static void burn(Object key, Object val) {
        if (key instanceof aig) {
            key = new BlockMatch((aig)key);
        }
        if (val instanceof aig) {
            val = new BlockMatch((aig)val);
        }
        transforms.put((BlockMatch)key, (BlockMatch)val);
    }

    public static void burn(Object key) {
        TileEntityWrathFire.burn(key, air);
    }

    public static void setupBurning() {
        for (int i = 0; i < aig.m.length; ++i) {
            aco m;
            aig block2 = aig.m[i];
            if (block2 == null || (m = block2.cp) != aco.d && m != aco.m && m != aco.j && m != aco.i && m != aco.k && m != aco.x && m != aco.D) continue;
            TileEntityWrathFire.burn(block2);
        }
        TileEntityWrathFire.burn(aig.aT);
        TileEntityWrathFire.burn(aig.bA, aig.bA);
        TileEntityWrathFire.burn(aig.E, aig.M);
        TileEntityWrathFire.burn(aig.M, aig.E);
        TileEntityWrathFire.burn(aig.u, aig.v);
        TileEntityWrathFire.burn(aig.ap, aig.C);
        TileEntityWrathFire.burn(aig.w, aig.t);
        TileEntityWrathFire.burn(aig.t, aig.w);
        TileEntityWrathFire.burn(new BlockMatch(aig.bm, 0), new BlockMatch(aig.bm, 2));
        TileEntityWrathFire.burn(new BlockMatch(aig.bm, 2), new BlockMatch(aig.bm, 0));
        TileEntityWrathFire.burn(new BlockMatch(aig.bm, 1), new BlockMatch(aig.bm, 0));
        TileEntityWrathFire.burn(aig.ao, aig.w);
        TileEntityWrathFire.burn(aig.aW, aig.al);
        TileEntityWrathFire.burn(aig.ai, new BlockMatch(Core.registry.resource_block, ResourceType.DARKIRONBLOCK.md));
    }

    public void b(an tag) {
        super.b(tag);
        if (this.host == null) {
            return;
        }
        tag.a("host_id", this.host.id);
        tag.a("host_md", this.host.md);
        tag.a("age", this.age);
        tag.a("generation", this.generation);
    }

    public void a(an tag) {
        super.a(tag);
        this.host = new BlockMatch(tag.e("host_id"), tag.e("host_md"));
        this.age = tag.e("age");
        this.generation = tag.e("generation");
    }

    static TileEntityWrathFire getFire(up worldObj, int x, int y, int z) {
        aji te = worldObj.p(x, y, z);
        if (te instanceof TileEntityWrathFire) {
            return (TileEntityWrathFire)te;
        }
        return null;
    }

    boolean blockSupports(Coord c) {
        return this.host.matches(c);
    }

    boolean isBlockSupported(Coord c) {
        for (Coord n : c.getNeighborsAdjacent()) {
            if (!this.blockSupports(n)) continue;
            return true;
        }
        return false;
    }

    void inherit(TileEntityWrathFire parent) {
        if (parent == null) {
            return;
        }
        this.host = parent.host;
        this.generation = Math.max(this.generation, parent.generation + 1);
    }

    boolean trySpawn(Coord c) {
        if (!Core.spread_wrathfire) {
            return false;
        }
        if (this.generation > 45) {
            return false;
        }
        int id = c.getId();
        if (id != 0 && !c.isAir()) {
            return false;
        }
        if (!this.isBlockSupported(c)) {
            return false;
        }
        if (c.is(Core.registry.lightair_block) && c.getMd() == 1) {
            return false;
        }
        if (rand.nextInt(3) == 0) {
            return true;
        }
        BlockLightAir cfr_ignored_0 = Core.registry.lightair_block;
        c.setIdMd(Core.lightair_id, 1);
        TileEntityWrathFire fire = (TileEntityWrathFire)c.getTE(TileEntityWrathFire.class);
        if (fire != null) {
            fire.inherit(this);
            return true;
        }
        c.setId(0);
        c.rmTE();
        return false;
    }

    @Override
    public Coord getCoord() {
        return new Coord(this.k, this);
    }

    void die() {
        this.j();
        fire.set(this.getCoord());
    }

    public void g() {
        if (!this.k.K) {
            this.doUpdate();
        }
    }

    void doUpdate() {
        if ((this.k.D() + (long)this.random_time_offset) % 25L != 0L) {
            return;
        }
        if ((double)rand.nextFloat() > 0.95) {
            return;
        }
        if (this.age > 35) {
            this.die();
            return;
        }
        if (updateCount > 100 && rand.nextBoolean()) {
            return;
        }
        ++updateCount;
        BlockMatch burnTo = (BlockMatch)transforms.get(this.host);
        if (burnTo == null) {
            this.die();
            return;
        }
        Coord here = this.getCoord();
        if (netherBrick.equals(this.host) || netherStair.equals(this.host) || netherFence.equals(this.host)) {
            int furnace_size = 13;
            int src_count = 0;
            for (Coord c : here.getRandomNeighborsDiagonal()) {
                if (!netherBrick.matches(c) && !netherStair.matches(c) && !netherFence.matches(c)) continue;
                ++src_count;
            }
            if (src_count < furnace_size) {
                if (src_count == 0) {
                    this.die();
                    return;
                }
                this.age += furnace_size - src_count;
                return;
            }
            ArrayList n = here.getRandomNeighborsAdjacent();
            n.addAll(here.getRandomNeighborsDiagonal());
            for (Coord c : n) {
                if (c.is(aig.bA)) continue;
                for (BlockMatch match : transforms.keySet()) {
                    BlockMatch burnsTo;
                    if (!match.matches(c) || transforms.containsKey(burnsTo = (BlockMatch)transforms.get(match))) continue;
                    burnsTo.set(c);
                    ++this.age;
                    return;
                }
            }
            return;
        }
        ++this.age;
        for (Coord c : here.getRandomNeighborsDiagonal()) {
            if (!this.trySpawn(c)) continue;
            return;
        }
        if (this.age < 11) {
            return;
        }
        for (Coord c : here.getRandomNeighborsDiagonal()) {
            if (!this.host.matches(c)) continue;
            burnTo.set(c);
            return;
        }
        this.age += 10;
    }

    boolean tryLoadTarget(int id, int md) {
        for (BlockMatch match : transforms.keySet()) {
            if (!match.isType(id, md)) continue;
            this.host = match;
            return true;
        }
        if (netherBrick.isType(id, md) || netherFence.isType(id, md) || netherStair.isType(id, md)) {
            this.host = netherBrick;
            return true;
        }
        return false;
    }

    void setTarget(int id, int md) {
        if (this.tryLoadTarget(id, md)) {
            return;
        }
    }

    public static void ignite(Coord baseBlock, Coord fireBlock, og player) {
        fireBlock.setIdMd(Core.lightair_id, 1);
        TileEntityWrathFire fire = (TileEntityWrathFire)fireBlock.getTE(TileEntityWrathFire.class);
        if (fire == null) {
            return;
        }
        if (netherBrick.matches(baseBlock) || netherFence.matches(baseBlock) || netherStair.matches(baseBlock)) {
            Sound.wrathForge.playAt((jn)player);
        } else {
            Sound.wrathLight.playAt((jn)player);
        }
        fire.setTarget(baseBlock.getId(), baseBlock.getMd());
    }

    public static class BlockMatch {
        int id;
        int md;

        public BlockMatch(int id, int md) {
            this.id = id;
            this.md = md;
        }

        public BlockMatch(aig block2) {
            this(block2.ca, -1);
        }

        public BlockMatch(aig block2, int md) {
            this(block2.ca, md);
        }

        boolean matches(Coord c) {
            int i = c.getId();
            if (i != this.id) {
                return false;
            }
            if (this.md == -1) {
                return true;
            }
            return this.md == c.getMd();
        }

        boolean isType(int id, int md) {
            if (id != this.id) {
                return false;
            }
            if (this.md == -1) {
                return true;
            }
            return this.md == md;
        }

        void set(Coord c) {
            if (this.md == -1) {
                c.setId(this.id);
            } else {
                c.setIdMd(this.id, this.md);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockMatch) {
                BlockMatch m = (BlockMatch)obj;
                return this.id == m.id && this.md == m.md;
            }
            return false;
        }

        public int hashCode() {
            return this.id << 4 + this.md;
        }

        public String toString() {
            return this.id + ":" + this.md;
        }
    }
}

