/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.CubeFace;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.WireConnections;
import java.io.DataInput;
import java.io.IOException;

public class TileEntityWire
extends TileEntityCommon
implements IChargeConductor {
    public byte supporting_side;
    private boolean extended_wire = false;
    Charge charge = new Charge();

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.LEADWIRE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Wire;
    }

    @Override
    public boolean activate(og entityplayer) {
        return false;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    byte getExtraInfo() {
        return this.supporting_side;
    }

    @Override
    void useExtraInfo(byte b) {
        this.supporting_side = b;
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        tag.a("side", this.supporting_side);
        this.charge.writeToNBT(tag, "charge");
    }

    public void a(an tag) {
        super.a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.supporting_side = tag.c("side");
    }

    boolean find_support() {
        if (!this.extended_wire) {
            return false;
        }
        for (int side = 0; side < 6; side = (int)((byte)(side + 1))) {
            if (!this.canPlaceAgainst(this.getCoord().towardSide(side), side)) continue;
            this.supporting_side = (byte)side;
            this.shareInfo();
            return true;
        }
        return false;
    }

    boolean is_directly_supported() {
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        if (!supporter.blockExists()) {
            return true;
        }
        return supporter.isSolidOnSide(this.supporting_side);
    }

    boolean is_supported() {
        if (this.is_directly_supported()) {
            return true;
        }
        Coord supporter = this.getCoord().towardSide(this.supporting_side);
        TileEntityWire parent = (TileEntityWire)supporter.getTE(TileEntityWire.class);
        if (parent != null) {
            this.extended_wire = true;
            return parent.is_supported();
        }
        return false;
    }

    @Override
    boolean canPlaceAgainst(Coord supporter, int side) {
        if (supporter.isSolidOnSide(side)) {
            return true;
        }
        TileEntityWire parent = (TileEntityWire)supporter.getTE(TileEntityWire.class);
        if (parent != null && parent.is_directly_supported()) {
            return parent.supporting_side != side && parent.supporting_side != CubeFace.oppositeSide(side);
        }
        return false;
    }

    public void g() {
        if (this.k.K) {
            return;
        }
        Charge.update(this);
        if (!this.is_supported() && !this.find_support()) {
            Core.registry.factory_block.c(this.k, this.l, this.m, this.n, BlockClass.Wire.md, 0);
            Coord here = this.getCoord();
            here.setId(0);
            here.rmTE();
        }
    }

    int getComplexity(byte new_side) {
        this.supporting_side = new_side;
        int complexity = new WireConnections(this).getComplexity();
        for (Coord ne : this.getCoord().getNeighborsAdjacent()) {
            TileEntityWire w = (TileEntityWire)ne.getTE(TileEntityWire.class);
            if (w == null) continue;
            complexity += new WireConnections(w).getComplexity();
        }
        return complexity;
    }

    @Override
    void onPlacedBy(og player, rj is, int side) {
        side = (new int[]{1, 0, 3, 2, 5, 4})[side];
        if (player.af()) {
            this.supporting_side = (byte)side;
            if (this.is_supported()) {
                this.shareInfo();
                return;
            }
        }
        byte best_side = (byte)side;
        int best_complexity = this.getComplexity(best_side) - 1;
        if (!this.is_supported()) {
            best_complexity = 2457;
        }
        for (byte s = 0; s < 6; s = (byte)((byte)(s + 1))) {
            int test;
            if (s == side) continue;
            this.supporting_side = s;
            if (!this.is_supported() || (test = this.getComplexity(s)) >= best_complexity) continue;
            best_complexity = test;
            best_side = s;
        }
        this.supporting_side = best_side;
        this.shareInfo();
    }

    void shareInfo() {
        this.broadcastMessage(null, 121, this.supporting_side);
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }

    @Override
    public ajq collisionRayTrace(up w, int x, int y, int z, ajs startVec, ajs endVec) {
        return new WireConnections(this).collisionRayTrace(w, x, y, z, startVec, endVec);
    }

    @Override
    public ajn getCollisionBoundingBoxFromPool() {
        this.setBlockBounds(Core.registry.resource_block);
        ajn ret = Core.registry.resource_block.e(this.k, this.l, this.m, this.n);
        Core.registry.resource_block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return ret;
    }

    @Override
    public void setBlockBounds(aig b) {
        new WireConnections(this).setBlockBounds(b);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 121) {
            this.supporting_side = input.readByte();
            this.getCoord().dirty();
            return true;
        }
        return false;
    }
}

