/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntitySlagFurnace
extends TileEntityFactorization {
    rj[] furnaceItemStacks = new rj[4];
    public int furnaceBurnTime;
    public int currentFuelItemBurnTime;
    public int furnaceCookTime;
    static final int input = 0;
    static final int fuel = 1;
    static final int output = 2;

    public int i_() {
        return 4;
    }

    public rj a(int i) {
        return this.furnaceItemStacks[i];
    }

    public void a(int i, rj is) {
        this.furnaceItemStacks[i] = is;
    }

    public String b() {
        return "Slag Furnace";
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
            case UP: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
            return 1;
        }
        return 2;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SLAGFURNACE;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.MachineLightable;
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void a(an tag) {
        super.a(tag);
        this.readSlotsFromNBT(tag);
        this.furnaceBurnTime = tag.e("burnTime");
        this.furnaceCookTime = tag.e("cookTime");
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        this.writeSlotsToNBT(tag);
        tag.a("burnTime", this.furnaceBurnTime);
        tag.a("cookTime", this.furnaceCookTime);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public void g() {
        boolean burnState = this.isBurning();
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (this.k.K) {
            return;
        }
        boolean invChanged = false;
        if (this.furnaceBurnTime <= 0 && this.canSmelt()) {
            this.currentFuelItemBurnTime = this.furnaceBurnTime = ajd.a((rj)this.furnaceItemStacks[1]) / 2;
            if (this.furnaceBurnTime > 0) {
                invChanged = true;
                if (this.furnaceItemStacks[1] != null) {
                    --this.furnaceItemStacks[1].a;
                    if (this.furnaceItemStacks[1].a == 0) {
                        this.furnaceItemStacks[1] = this.furnaceItemStacks[1].b().getContainerItemStack(this.furnaceItemStacks[1]);
                    }
                }
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.furnaceCookTime;
            if (this.furnaceCookTime >= 200 || Core.cheat) {
                this.furnaceCookTime = 0;
                this.smeltItem();
                invChanged = true;
            }
        } else {
            this.furnaceCookTime = 0;
        }
        if (burnState != this.isBurning() || this.isBurning() && this.draw_active != 1) {
            this.draw_active = (byte)-1;
            this.drawActive(this.furnaceBurnTime > 0 ? 2 : 0);
            Coord here = this.getCoord();
            here.dirty();
            here.updateLight();
        }
        if (invChanged) {
            this.d();
        }
    }

    boolean checkFit(rj output, rj res, int resSize) {
        if (output == null) {
            return true;
        }
        if (!output.a(res)) {
            return false;
        }
        return output.a + resSize <= output.d();
    }

    boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        SmeltingResult res = SlagRecipes.getSlaggingResult(this.furnaceItemStacks[0]);
        if (res == null) {
            return false;
        }
        return this.checkFit(this.furnaceItemStacks[2], res.output1, (int)res.prob1) && this.checkFit(this.furnaceItemStacks[3], res.output2, (int)res.prob2);
    }

    int getRandomSize(float f) {
        int i = (int)f;
        if (f - (float)i > rand.nextFloat()) {
            ++i;
        }
        return i;
    }

    void smeltItem() {
        if (!this.canSmelt()) {
            return;
        }
        SmeltingResult res = SlagRecipes.getSlaggingResult(this.furnaceItemStacks[0]);
        if (this.furnaceItemStacks[2] == null) {
            this.furnaceItemStacks[2] = rj.b((rj)res.output1);
            this.furnaceItemStacks[2].a = 0;
        }
        if (this.furnaceItemStacks[3] == null) {
            this.furnaceItemStacks[3] = rj.b((rj)res.output2);
            this.furnaceItemStacks[3].a = 0;
        }
        rj fo0 = this.furnaceItemStacks[2];
        rj fo1 = this.furnaceItemStacks[3];
        fo0.a += this.getRandomSize(res.prob1);
        fo1.a += this.getRandomSize(res.prob2);
        if (fo0.a > fo0.d()) {
            fo0.a = fo0.d();
        }
        if (fo1.a > fo1.d()) {
            fo1.a = fo1.d();
        }
        if (fo0.a <= 0) {
            this.furnaceItemStacks[2] = null;
        }
        if (fo1.a <= 0) {
            this.furnaceItemStacks[3] = null;
        }
        --this.furnaceItemStacks[0].a;
        if (this.furnaceItemStacks[0].a == 0) {
            this.furnaceItemStacks[0] = null;
        }
    }

    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 200;
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentFuelItemBurnTime == 0) {
            this.currentFuelItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentFuelItemBurnTime;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        boolean r = super.handleMessageFromServer(messageType, input);
        if (messageType == 0) {
            this.getCoord().updateLight();
        }
        return r;
    }

    static class SlagRecipes {
        static ArrayList smeltingResults = new ArrayList();

        SlagRecipes() {
        }

        static void register(Object o_input, float prob1, Object o_output1, float prob2, Object o_output2) {
            rj input = SlagRecipes.obj2is(o_input);
            rj output1 = SlagRecipes.obj2is(o_output1);
            rj output2 = SlagRecipes.obj2is(o_output2);
            input = rj.b((rj)input);
            input.a = 1;
            SmeltingResult value = new SmeltingResult(input, prob1, output1, prob2, output2);
            smeltingResults.add(value);
        }

        static rj obj2is(Object o) {
            if (o instanceof rj) {
                return (rj)o;
            }
            if (o instanceof aig) {
                aig b = (aig)o;
                return new rj(rh.e[b.ca]);
            }
            if (o instanceof rh) {
                return new rj((rh)o);
            }
            return null;
        }

        static SmeltingResult getSlaggingResult(rj input) {
            for (SmeltingResult res : smeltingResults) {
                if (!res.input.a(input)) continue;
                return res;
            }
            return null;
        }
    }

    static class SmeltingResult {
        rj input;
        float prob1;
        float prob2;
        rj output1;
        rj output2;

        SmeltingResult(rj input, float prob1, rj output1, float prob2, rj output2) {
            this.input = input;
            this.prob1 = prob1;
            this.prob2 = prob2;
            this.output1 = output1;
            this.output2 = output2;
        }
    }
}

