/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityMixer
extends TileEntityFactorization
implements IChargeConductor {
    rj[] input = new rj[4];
    rj[] output = new rj[4];
    int progress = 0;
    int speed = 0;
    Charge charge = new Charge();
    int last_speed = -1;
    float rotation = 0.0f;
    static ArrayList recipes = new ArrayList();
    static boolean sorted = false;
    MixRecipe cache = null;
    boolean dirty = true;

    @Override
    public void b(an tag) {
        super.b(tag);
        this.charge.writeToNBT(tag, "charge");
        tag.a("progress", this.progress);
        tag.a("speed", this.speed);
        this.writeSlotsToNBT(tag);
    }

    @Override
    public void a(an tag) {
        super.a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.progress = tag.e("progress");
        this.speed = tag.e("speed");
        this.readSlotsFromNBT(tag);
        this.dirty = true;
    }

    public int i_() {
        return 8;
    }

    public rj a(int slot) {
        this.dirty = true;
        if (slot >= 0 && slot < 4) {
            return this.input[slot];
        }
        if ((slot -= 4) >= 0 && slot < 4) {
            return this.output[slot];
        }
        return null;
    }

    public void a(int slot, rj is) {
        this.dirty = true;
        if (slot >= 0 && slot < 4) {
            this.input[slot] = is;
            return;
        }
        if ((slot -= 4) >= 0 && slot < 4) {
            this.output[slot] = is;
            return;
        }
    }

    public String b() {
        return "Mixer";
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 4;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 4;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIXER;
    }

    @Override
    public void g() {
        super.g();
        Charge.update(this);
        this.rotation += (float)this.speed;
        this.shareRotationSpeed();
    }

    void shareRotationSpeed() {
        if (this.speed != this.last_speed) {
            this.broadcastMessage(null, 100, this.speed);
            this.last_speed = this.speed;
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 100) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    int getLogicSpeed() {
        return 8;
    }

    int getRemainingProgress() {
        return 300 - this.progress;
    }

    public float getRotation() {
        return this.rotation;
    }

    static void addRecipe(rj[] inputs, rj[] outputs) {
        recipes.add(new MixRecipe(inputs, outputs));
        sorted = false;
    }

    MixRecipe getRecipe() {
        if (!sorted) {
            Collections.sort(recipes, new Comparator(){

                public int compare(MixRecipe a, MixRecipe b) {
                    return a.inputs.length - b.inputs.length;
                }
            });
            sorted = true;
        }
        for (MixRecipe recipe : recipes) {
            if (!recipe.matches(this.input)) continue;
            return recipe;
        }
        return null;
    }

    static rj[] copyArray(rj[] src) {
        rj[] clone = new rj[src.length];
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == null) continue;
            clone[i] = src[i].l();
        }
        return clone;
    }

    boolean addItems(rj[] out, rj[] src) {
        for (rj is : src) {
            int i;
            for (i = 0; i < out.length; ++i) {
                if (out[i] == null || !is.a(out[i])) continue;
                int free = out[i].d() - out[i].a;
                int delta = Math.min(free, is.a);
                is.a -= delta;
                out[i].a += delta;
                if ((is = FactorizationUtil.normalize(is)) == null) break;
            }
            if (is == null) continue;
            for (i = 0; i < out.length; ++i) {
                if (out[i] != null) continue;
                out[i] = is.l();
                is = null;
                break;
            }
            if (is == null) continue;
            this.normalize(out);
            this.normalize(src);
            return false;
        }
        this.normalize(out);
        this.normalize(src);
        return true;
    }

    boolean hasFreeSpace(MixRecipe mr) {
        return this.addItems(TileEntityMixer.copyArray(this.output), TileEntityMixer.copyArray(mr.outputs));
    }

    MixRecipe getCachedRecipe() {
        if (!this.dirty) {
            return this.cache;
        }
        this.dirty = false;
        this.cache = this.getRecipe();
        return this.cache;
    }

    void slow() {
        if (this.progress > 0) {
            this.progress = (int)Math.max(0.0, (double)this.progress * 0.8 - 5.0);
        }
        if (this.speed > 0) {
            --this.speed;
        }
    }

    boolean extractEnergy() {
        int val = this.charge.getValue();
        if (val == 0) {
            return false;
        }
        this.charge.setValue(val - 1);
        return true;
    }

    @Override
    void doLogic() {
        this.needLogic();
        MixRecipe mr = this.getCachedRecipe();
        if (mr == null) {
            this.slow();
            return;
        }
        if (!this.hasFreeSpace(mr)) {
            this.slow();
            return;
        }
        if (!this.extractEnergy() && this.speed > 0) {
            --this.speed;
        }
        if (this.speed < 5 && this.extractEnergy()) {
            ++this.speed;
        }
        this.progress += this.speed;
        if (this.getRemainingProgress() <= 0 || Core.cheat) {
            this.progress = 0;
            this.addItems(this.output, TileEntityMixer.copyArray(mr.outputs));
            this.dirty = true;
            block0: for (rj rec : TileEntityMixer.copyArray(mr.inputs)) {
                for (int i = 0; i < this.input.length; ++i) {
                    if (this.input[i] == null) continue;
                    if (rec.a(this.input[i])) {
                        int d = Math.min(this.input[i].a, rec.a);
                        this.input[i].a -= d;
                        rec.a -= d;
                        this.input[i] = FactorizationUtil.normalize(this.input[i]);
                        rec = FactorizationUtil.normalize(rec);
                    }
                    if (rec == null) continue block0;
                }
            }
            this.normalize(this.input);
        }
    }

    void normalize(rj[] is) {
        for (int i = 0; i < is.length; ++i) {
            is[i] = FactorizationUtil.normalize(is[i]);
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public int getMixProgressScaled(int scale) {
        return this.progress * scale / (this.progress + this.getRemainingProgress());
    }

    @Override
    byte getExtraInfo2() {
        return (byte)this.speed;
    }

    @Override
    void useExtraInfo(byte b) {
        this.speed = b;
    }

    static class MixRecipe {
        final rj[] inputs;
        final rj[] outputs;

        public MixRecipe(rj[] inputs, rj[] outputs) {
            this.inputs = inputs;
            this.outputs = outputs;
        }

        public boolean matches(rj[] mixer_inv) {
            for (rj is : this.inputs) {
                boolean found = false;
                for (rj inp : mixer_inv) {
                    if (inp == null || !is.a(inp)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

