/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoord;
import factorization.api.IReflectionTarget;
import factorization.common.BlockClass;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;

public class TileEntityMirror
extends TileEntityCommon {
    Coord reflection_target = null;
    public int rotation = 0;
    public boolean is_lit = false;
    int search_delay = 0;
    int trace_check = 0;
    int target_rotation = 0;
    int last_shared = -1;
    boolean gotten_info_packet = false;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MIRROR;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        if (this.reflection_target != null) {
            this.reflection_target.writeToNBT("target", tag);
        }
    }

    public void a(an tag) {
        super.a(tag);
        if (tag.b("targetx")) {
            this.reflection_target = this.getCoord();
            this.reflection_target.readFromNBT("target", tag);
            this.updateRotation();
            this.rotation = this.target_rotation;
        } else {
            this.reflection_target = null;
        }
    }

    @Override
    public void neighborChanged() {
        this.trace_check = 1;
        this.search_delay = 1;
    }

    int getPower() {
        return 1;
    }

    int clipAngle(int angle) {
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return angle;
    }

    boolean hasSun() {
        boolean raining = this.k.J() && this.k.a((int)this.l, (int)this.m).G > 0.0f;
        return this.getCoord().canSeeSky() && this.k.s() && !raining;
    }

    void setRotation(int rotation) {
        if (this.rotation != rotation) {
            this.rotation = rotation;
        }
    }

    void broadcastTargetInfo() {
        if (this.getTargetInfo() != this.last_shared) {
            this.broadcastMessage(null, 60, this.getTargetInfo());
            this.last_shared = this.getTargetInfo();
        }
    }

    int getTargetInfo() {
        return this.reflection_target == null ? -99 : this.target_rotation;
    }

    void setRotationTarget(int new_target) {
        if (this.target_rotation != new_target) {
            this.target_rotation = new_target;
        }
    }

    @Override
    public db e() {
        return this.getDescriptionPacketWith(61, this.rotation, this.getTargetInfo());
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        switch (messageType) {
            case 61: {
                this.rotation = input.readInt();
            }
            case 60: {
                this.target_rotation = input.readInt();
                this.getCoord().dirty();
                this.gotten_info_packet = true;
                return true;
            }
        }
        return false;
    }

    @Override
    void onPlacedBy(og player, rj is, int side) {
        if (player == null) {
            return;
        }
        this.setRotation(this.clipAngle(-this.clipAngle((int)player.z + 270)));
    }

    @Override
    void onRemove() {
        if (this.reflection_target == null) {
            return;
        }
        IReflectionTarget target = (IReflectionTarget)this.reflection_target.getTE(IReflectionTarget.class);
        if (target == null) {
            return;
        }
        if (this.is_lit) {
            target.addReflector(-this.getPower());
            this.is_lit = false;
        }
        this.reflection_target = null;
    }

    public void g() {
        if (this.k.K) {
            if (!this.gotten_info_packet) {
                return;
            }
            if (this.target_rotation == -99) {
                ++this.rotation;
            } else if (this.target_rotation != this.rotation) {
                int dist = this.target_rotation - this.rotation;
                this.rotation = dist > 180 || dist < 0 && dist > -180 ? --this.rotation : ++this.rotation;
                this.rotation = this.clipAngle(this.rotation);
            }
            return;
        }
        this.broadcastTargetInfo();
        if (this.reflection_target == null) {
            ++this.rotation;
            if (this.search_delay > 0) {
                --this.search_delay;
                return;
            }
            this.findTarget();
            if (this.reflection_target == null) {
                this.search_delay = 60;
                return;
            }
            this.trace_check = 300;
        } else {
            this.reflection_target.setWorld(this.k);
        }
        IReflectionTarget target = null;
        target = (IReflectionTarget)this.reflection_target.getTE(IReflectionTarget.class);
        if (target == null) {
            if (this.reflection_target.blockExists()) {
                this.reflection_target = null;
                this.is_lit = false;
            }
            return;
        }
        this.rotation = this.clipAngle(this.rotation);
        if (this.rotation != this.target_rotation) {
            int dist = this.target_rotation - this.rotation;
            this.rotation = dist > 180 || dist < 0 && dist > -180 ? --this.rotation : ++this.rotation;
            this.rotation = this.clipAngle(this.rotation);
            if (this.rotation == this.target_rotation) {
                this.trace_check = 1;
            }
        }
        if (this.trace_check == 0) {
            this.trace_check = 600 + rand.nextInt(20);
            if (!this.myTrace(this.reflection_target.x, this.reflection_target.z) && this.is_lit) {
                this.is_lit = false;
                target.addReflector(-this.getPower());
                this.reflection_target = null;
                this.setRotationTarget(-99);
                return;
            }
        } else {
            --this.trace_check;
        }
        if (this.hasSun() != this.is_lit && this.rotation == this.target_rotation) {
            this.is_lit = this.hasSun();
            target.addReflector(this.is_lit ? this.getPower() : -this.getPower());
        }
    }

    void findTarget() {
        if (this.reflection_target != null) {
            IReflectionTarget target = (IReflectionTarget)this.reflection_target.getTE(IReflectionTarget.class);
            if (target != null) {
                if (this.is_lit) {
                    target.addReflector(-this.getPower());
                }
                this.reflection_target = null;
            }
            this.is_lit = false;
        }
        int search_distance = 8;
        ICoord closest = null;
        int last_dist = Integer.MAX_VALUE;
        Coord me = this.getCoord();
        for (int x = this.l - search_distance; x < this.l + search_distance; ++x) {
            for (int z = this.n - search_distance; z < this.n + search_distance; ++z) {
                int new_dist;
                Coord here = new Coord(this.k, x, this.m, z);
                IReflectionTarget target = (IReflectionTarget)here.getTE(IReflectionTarget.class);
                if (target == null || !this.myTrace(x, z) || (new_dist = me.distanceSq(here)) >= last_dist) continue;
                last_dist = new_dist;
                closest = target;
            }
        }
        if (closest != null) {
            this.reflection_target = closest.getCoord();
            this.updateRotation();
        } else {
            this.setRotationTarget(-99);
        }
    }

    void updateRotation() {
        DeltaCoord dc2 = this.getCoord().difference(this.reflection_target);
        int new_target = this.clipAngle((int)Math.toDegrees(dc2.getAngleHorizontal()));
        this.setRotationTarget(new_target);
    }

    double div(double a, double b) {
        if (b == 0.0) {
            return Math.signum(a) * 4095.0;
        }
        return a / b;
    }

    boolean myTrace(double x, double z) {
        double offset_x = (x += 0.5) - ((double)this.l + 0.5);
        double offset_z = (z += 0.5) - ((double)this.n + 0.5);
        double length = Math.hypot(offset_x, offset_z);
        double dx = offset_x / length;
        double dz = offset_z / length;
        x -= dx;
        z -= dz;
        int bx = 0;
        int bz = 0;
        int i = 0;
        while ((double)i < length) {
            bx = (int)Math.round(x + 0.5) - 1;
            bz = (int)Math.round(z + 0.5) - 1;
            if (bx == this.l && bz == this.n) {
                return true;
            }
            int id = this.k.a(bx, this.m, bz);
            aig b = aig.m[id];
            if (b != null && !b.isAirBlock(this.k, bx, this.m, bz)) {
                return false;
            }
            x -= dx;
            z -= dz;
            ++i;
        }
        return false;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return false;
    }
}

