/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.ItemCraft;
import factorization.common.Sound;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityMaker
extends TileEntityFactorization
implements ISidedInventory {
    public int fuel = 0;
    public boolean[] targets = new boolean[9];
    rj input;
    rj craft;
    rj output;
    private final int input_slot = 0;
    private final int craft_slot = 1;
    private final int output_slot = 2;

    public TileEntityMaker() {
        this.targets[4] = true;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public int i_() {
        return 3;
    }

    public rj a(int i) {
        switch (i) {
            case 0: {
                return this.input;
            }
            case 1: {
                return this.craft;
            }
            case 2: {
                return this.output;
            }
        }
        return null;
    }

    public void a(int i, rj itemstack) {
        switch (i) {
            case 0: {
                this.input = itemstack;
                break;
            }
            case 1: {
                this.craft = itemstack;
                break;
            }
            case 2: {
                this.output = itemstack;
            }
        }
        this.d();
    }

    public String b() {
        return "Craft Maker";
    }

    public void setTargets(int id, boolean flag) {
        if (this.targets[id] != flag) {
            this.targets[id] = flag;
            this.broadcastTarget(null, id);
        }
    }

    boolean insertItem(int targetSlot, boolean doTarget) {
        if (!doTarget) {
            return true;
        }
        if (this.craft == null) {
            return false;
        }
        ItemCraft ic = (ItemCraft)this.craft.b();
        if (this.input == null) {
            return ic.isSlotSet(this.craft, targetSlot);
        }
        rj toAdd = this.input.l();
        toAdd.a = 1;
        if (ic.addItem(this.craft, targetSlot, toAdd)) {
            --this.input.a;
            if (this.input.a < 1) {
                this.input = null;
            }
            return true;
        }
        return ic.isSlotSet(this.craft, targetSlot);
    }

    void changeFuel(int delta) {
        this.fuel += delta;
        this.broadcastFuel(null);
    }

    void handleFuel() {
        if (this.craft != null) {
            si c;
            int value = 0;
            if (this.craft.b() == rh.aK) {
                value = 1;
            }
            if (this.craft.b() == rh.as) {
                value = 13;
            }
            if (this.craft.b() == rh.bd) {
                value = 8;
            }
            if (this.craft.b() == rh.aL) {
                value = 9;
            }
            if (this.craft.b() instanceof si && (c = (si)this.craft.b()).f() == aig.an.ca) {
                value = 64;
            }
            if (value != 0) {
                this.changeFuel(value * this.craft.a);
                this.craft = null;
            }
        }
    }

    @Override
    void doLogic() {
        this.handleFuel();
        boolean have_craft = this.craft != null && this.craft.b() instanceof ItemCraft;
        boolean is_armed = this.input != null && this.input.a > 0 && !(this.input.b() instanceof ItemCraft) && this.output == null;
        boolean could_move = this.craft != null && this.output == null;
        boolean haveFlag = false;
        for (boolean target : this.targets) {
            haveFlag |= target;
        }
        if (!haveFlag) {
            is_armed = false;
        }
        if (this.craft == null && this.fuel != 0 && is_armed) {
            have_craft = true;
            this.craft = new rj((rh)Core.registry.item_craft);
            this.changeFuel(-1);
        }
        if (have_craft && (is_armed || could_move)) {
            boolean success = true;
            for (int index = 0; index < 9; ++index) {
                success &= this.insertItem(index, this.targets[index]);
            }
            if (success) {
                this.output = this.craft;
                this.craft = null;
                this.drawActive(3);
            }
        }
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        tag.a("fuel", this.fuel);
        for (int i = 0; i < 9; ++i) {
            tag.a("target" + i, this.targets[i]);
        }
        TileEntityMaker.saveItem("input", tag, this.input);
        TileEntityMaker.saveItem("craft", tag, this.craft);
        TileEntityMaker.saveItem("output", tag, this.output);
    }

    @Override
    public void a(an tag) {
        super.a(tag);
        this.fuel = tag.e("fuel");
        for (int i = 0; i < 9; ++i) {
            this.targets[i] = tag.n("target" + i);
        }
        this.input = TileEntityMaker.readItem("input", tag);
        this.craft = TileEntityMaker.readItem("craft", tag);
        this.output = TileEntityMaker.readItem("output", tag);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
            case UP: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    void sendFullDescription(og player) {
        super.sendFullDescription(player);
        this.broadcastFuel(player);
        for (int i = 0; i < 9; ++i) {
            this.broadcastTarget(player, i);
        }
    }

    void broadcastFuel(og who) {
        this.broadcastMessage(who, 12, this.fuel);
    }

    void broadcastTarget(og who, int slot) {
        this.broadcastMessage(who, 11, slot, this.targets[slot]);
    }

    boolean handleMessageFromAny(int messageType, DataInput input) throws IOException {
        if (messageType == 11) {
            int target_id = input.readInt();
            boolean state = input.readBoolean();
            if (!this.k.K) {
                this.setTargets(target_id, state);
            } else {
                this.targets[target_id] = state;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (this.handleMessageFromAny(messageType, input)) {
            return true;
        }
        if (messageType == 12) {
            this.fuel = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromClient(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        return this.handleMessageFromAny(messageType, input);
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.MAKER;
    }

    @Override
    void makeNoise() {
        Sound.makerUse.playAt(this);
    }
}

