/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntitySlagFurnace;
import java.io.DataInput;
import java.io.IOException;

public class TileEntityHeater
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge();
    public byte heat = 0;
    public static final byte maxHeat = 32;
    byte last_heat = (byte)-99;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.HEATER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        this.charge.writeToNBT(tag, "charge");
        tag.a("heat", this.heat);
    }

    public void a(an tag) {
        super.a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.heat = tag.c("heat");
    }

    int charge2heat(int i) {
        return (int)((double)i / 1.5);
    }

    void updateClient() {
        int delta = Math.abs(this.heat - this.last_heat);
        if (delta > 2) {
            this.broadcastMessage(null, 80, this.heat);
            this.last_heat = this.heat;
        }
    }

    @Override
    byte getExtraInfo() {
        return this.heat;
    }

    @Override
    void useExtraInfo(byte b) {
        this.heat = b;
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 80) {
            this.heat = input.readByte();
            return true;
        }
        return false;
    }

    public void g() {
        if (this.k.K) {
            return;
        }
        this.updateClient();
        Coord here = this.getCoord();
        int delta = Math.min(32 - this.heat, this.charge.getValue());
        long now = this.k.D() + (long)here.seed();
        if (this.charge2heat(delta) > 0) {
            if (now % 4L == 0L || this.heat == 0) {
                this.heat = (byte)(this.heat + this.charge2heat(delta));
                this.charge.addValue(-delta);
            }
        } else if (now % 200L == 0L) {
            int toLose = Math.max(1, this.heat / 8);
            this.heat = (byte)(this.heat - toLose);
            this.heat = (byte)Math.max(0, this.heat);
        }
        Charge.update(this);
        if (this.heat <= 0) {
            return;
        }
        for (Coord c : here.getRandomNeighborsAdjacent()) {
            this.sendHeat(c.getTE());
            if (this.heat > 0) continue;
            return;
        }
    }

    boolean shouldHeat(int cookTime) {
        if ((double)this.heat >= 16.0) {
            return true;
        }
        return cookTime > 0;
    }

    int addGraceHeat(int burnTime) {
        return Math.max(4, burnTime);
    }

    void sendHeat(aji te) {
        ProxiedHeatingResult pf;
        Object furnace;
        if (te instanceof ajd) {
            furnace = (ajd)te;
            if (!this.TEF_canSmelt((ajd)furnace)) {
                return;
            }
            pf = new ProxiedHeatingResult(new Coord(te), ((ajd)furnace).a, ((ajd)furnace).c);
            ((ajd)furnace).a = pf.burnTime;
            ((ajd)furnace).c = Math.min(pf.cookTime, 199);
            afz.a((((ajd)furnace).c > 0 ? 1 : 0) != 0, (up)this.k, (int)te.l, (int)te.m, (int)te.n);
        }
        if (te instanceof TileEntitySlagFurnace) {
            furnace = (TileEntitySlagFurnace)te;
            if (!((TileEntitySlagFurnace)furnace).canSmelt()) {
                return;
            }
            pf = new ProxiedHeatingResult(new Coord(te), ((TileEntitySlagFurnace)furnace).furnaceBurnTime, ((TileEntitySlagFurnace)furnace).furnaceCookTime);
            ((TileEntitySlagFurnace)furnace).furnaceBurnTime = pf.burnTime;
            ((TileEntitySlagFurnace)furnace).furnaceCookTime = pf.cookTime;
        }
        if (te instanceof TileEntityCrystallizer) {
            TileEntityCrystallizer crys = (TileEntityCrystallizer)te;
            if (!crys.needHeat()) {
                return;
            }
            ++crys.heat;
            this.heat = (byte)(this.heat - 1);
        }
    }

    boolean TEF_canSmelt(ajd diss) {
        if (diss.a(0) == null) {
            return false;
        }
        rj var1 = tb.a().getSmeltingResult(diss.a(0));
        if (var1 == null) {
            return false;
        }
        if (diss.a(2) == null) {
            return true;
        }
        if (!diss.a(2).a(var1)) {
            return false;
        }
        int result = diss.a((int)2).a + var1.a;
        return result <= diss.j_() && result <= var1.d();
    }

    private class ProxiedHeatingResult {
        int burnTime;
        int cookTime;
        int topBurnTime;

        public ProxiedHeatingResult(Coord furnace, int burnTime, int cookTime) {
            this.burnTime = burnTime;
            this.cookTime = cookTime;
            this.topBurnTime = 200;
            this.calculate(furnace);
        }

        private void calculate(Coord furnace) {
            for (int i = 0; i < 2; ++i) {
                if (TileEntityHeater.this.heat <= 16) {
                    return;
                }
                if (this.burnTime < this.topBurnTime) {
                    ++this.burnTime;
                } else {
                    ++this.cookTime;
                }
                TileEntityHeater.this.heat = (byte)(TileEntityHeater.this.heat - 1);
            }
        }
    }
}

