/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityGrinder
extends TileEntityFactorization
implements IChargeConductor {
    rj input;
    rj output;
    Charge charge = new Charge();
    int progress = 0;
    int energy = 0;
    int speed = 0;
    final int grind_time = 400;
    int last_speed = 0;
    public int rotation;
    static ArrayList recipes = new ArrayList();

    public int i_() {
        return 2;
    }

    public rj a(int slot) {
        if (slot == 0) {
            return this.input;
        }
        if (slot == 1) {
            return this.output;
        }
        return null;
    }

    public void a(int slot, rj is) {
        if (slot == 0) {
            this.input = is;
        }
        if (slot == 1) {
            this.output = is;
        }
    }

    @Override
    public void a(an tag) {
        super.a(tag);
        this.readSlotsFromNBT(tag);
        this.charge.readFromNBT(tag, "charge");
        this.progress = tag.e("progress");
        this.energy = tag.e("energy");
        this.speed = tag.e("speed");
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        this.writeSlotsToNBT(tag);
        this.charge.writeToNBT(tag, "charge");
        tag.a("progress", this.progress);
        tag.a("energy", this.energy);
        tag.a("speed", this.speed);
    }

    public String b() {
        return "Grinder";
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        float p = (float)(this.speed * 100) / 50.0f;
        return "Speed: " + (int)p + "%";
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.GRINDER;
    }

    void slowDown() {
        if (this.speed > 0) {
            --this.speed;
        }
    }

    void shareSpeed() {
        if (this.speed != this.last_speed) {
            this.last_speed = this.speed;
            this.broadcastMessage(null, 90, this.speed);
        }
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 90) {
            this.speed = input.readInt();
            return true;
        }
        return false;
    }

    @Override
    public void g() {
        this.rotation += this.speed;
        super.g();
    }

    @Override
    void doLogic() {
        int val;
        this.shareSpeed();
        this.needLogic();
        Charge.update(this);
        if (this.k.D() % 3L == 0L && (val = this.getCharge().getValue()) > 16 && this.energy < 30) {
            int to_take = Math.min(30, val);
            this.energy += to_take / 5;
            this.getCharge().setValue(val -= to_take);
        }
        if (this.energy <= 0) {
            this.slowDown();
            if (this.progress > 0) {
                --this.progress;
            }
            return;
        }
        if (this.canGrind()) {
            if (this.speed < 50) {
                ++this.speed;
                this.energy -= 2;
            } else {
                if (this.progress == 400 || Core.cheat) {
                    this.progress = 0;
                    this.grind();
                } else {
                    ++this.progress;
                }
                --this.energy;
            }
        } else {
            this.slowDown();
            this.progress = 0;
        }
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public static void addRecipe(rj input, rj output, float probability) {
        recipes.add(new GrinderRecipe(input, output, probability));
    }

    boolean canGrind() {
        this.input = FactorizationUtil.normalize(this.input);
        if (this.input == null) {
            return false;
        }
        for (GrinderRecipe gr : recipes) {
            if (!gr.input.a(this.input)) continue;
            if (this.output == null) {
                return true;
            }
            if (!this.output.a(gr.output)) {
                return false;
            }
            return !((double)this.output.a + ((double)((int)gr.probability) + 0.99) > (double)this.output.d());
        }
        return false;
    }

    void grind() {
        for (GrinderRecipe gr : recipes) {
            if (!gr.input.a(this.input)) continue;
            if (this.output == null) {
                this.output = gr.output.l();
                this.output.a = 0;
            }
            int min = (int)gr.probability;
            this.output.a += min;
            this.output.a = this.output.a + (rand.nextFloat() < gr.probability - (float)min ? 1 : 0);
            --this.input.a;
            this.input = FactorizationUtil.normalize(this.input);
            return;
        }
    }

    public int getGrindProgressScaled(int total) {
        return total * this.progress / 400;
    }

    private static class GrinderRecipe {
        rj input;
        rj output;
        float probability;

        GrinderRecipe(rj input, rj output, float probability) {
            this.input = input;
            this.output = output;
            this.probability = probability;
        }
    }
}

