/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityFactorization;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityCrystallizer
extends TileEntityFactorization {
    rj[] inputs = new rj[6];
    rj output;
    public rj growing_crystal;
    public rj solution;
    public int heat;
    public int progress;
    int share_delay = 600;
    int current_state = -1;
    int last_state = -1;
    static ArrayList recipes = new ArrayList();

    @Override
    public void b(an tag) {
        super.b(tag);
        this.writeSlotsToNBT(tag);
        tag.a("heat", this.heat);
        tag.a("progress", this.progress);
    }

    @Override
    public void a(an tag) {
        super.a(tag);
        this.readSlotsFromNBT(tag);
        this.heat = tag.e("heat");
        this.progress = tag.e("progress");
    }

    public int i_() {
        return this.inputs.length + 1;
    }

    public rj a(int slot) {
        this.needLogic();
        if (slot == this.inputs.length) {
            return this.output;
        }
        return this.inputs[slot];
    }

    public void a(int slot, rj is) {
        this.needLogic();
        if (slot == this.inputs.length) {
            this.output = is;
            return;
        }
        this.inputs[slot] = is;
    }

    public String b() {
        return "Crystallizer";
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return this.inputs.length;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return 1;
        }
        return this.inputs.length;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.CRYSTALLIZER;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    int pickInputSlot(rj must_match) {
        int slot = -1;
        int max_size = -99;
        for (int i = 0; i < this.inputs.length; ++i) {
            int here_size;
            if (must_match != null && this.inputs[i] != null && !must_match.a(this.inputs[i]) || (here_size = FactorizationUtil.getStackSize(this.inputs[i])) <= max_size) continue;
            max_size = here_size;
            slot = i;
        }
        return slot;
    }

    public int getProgressRemaining() {
        return 24000 / this.getLogicSpeed() - this.progress;
    }

    public float getProgress() {
        return (float)this.progress / (float)(this.getProgressRemaining() + this.progress);
    }

    boolean needHeat() {
        if (this.heat >= 100) {
            return false;
        }
        return this.getMatchingRecipe() != null;
    }

    void empty() {
        this.growing_crystal = null;
        this.solution = null;
        this.shareState();
    }

    @Override
    void doLogic() {
        if (this.heat <= 0) {
            this.current_state = 1;
            this.empty();
            return;
        }
        CrystalRecipe match = this.getMatchingRecipe();
        if (match == null) {
            this.heat = Math.max(this.heat - 3, 0);
            this.progress = (int)Math.min((double)this.progress * 0.005 - 1.0, 0.0);
            this.current_state = 2;
            this.empty();
            return;
        }
        if (this.growing_crystal == null) {
            this.growing_crystal = match.output;
            this.solution = match.solution;
            this.share_delay = 0;
            this.current_state = 3;
        }
        if (this.heat < 100) {
            this.current_state = 4;
            this.shareState();
            return;
        }
        this.needLogic();
        if (this.progress == 0) {
            this.share_delay = 0;
            this.current_state = 5;
        }
        ++this.progress;
        if (this.getProgressRemaining() <= 0 || Core.cheat) {
            this.heat = Core.cheat ? 80 : 0;
            this.progress = 0;
            match.apply(this);
            this.share_delay = 0;
            this.current_state = 6;
        }
        this.shareState();
    }

    void shareState() {
        --this.share_delay;
        if (this.share_delay <= 0 || this.current_state != this.last_state) {
            this.share_delay = 300;
            this.broadcastMessage(null, this.e());
            this.last_state = this.current_state;
        }
    }

    int countMaterial(rj toMatch) {
        int count = 0;
        for (rj is : this.inputs) {
            if (is == null || !is.a(toMatch)) continue;
            count += is.a;
        }
        return count;
    }

    public static void addRecipe(rj input, rj output, float output_count, rj solution, int antium_count) {
        recipes.add(new CrystalRecipe(input, output, output_count, solution, antium_count));
    }

    CrystalRecipe getMatchingRecipe() {
        for (CrystalRecipe r : recipes) {
            if (!r.matches(this)) continue;
            return r;
        }
        return null;
    }

    rj null2fake(rj is) {
        if (is == null) {
            return Core.registry.crystallizer_item;
        }
        return is;
    }

    rj unfake(rj is) {
        if (is.a(Core.registry.crystallizer_item)) {
            return null;
        }
        return is;
    }

    @Override
    public db e() {
        return this.getDescriptionPacketWith(110, this.null2fake(this.growing_crystal), this.null2fake(this.solution), this.progress);
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 110) {
            this.growing_crystal = this.unfake(FactorizationHack.loadItemStackFromDataInput(input));
            this.solution = this.unfake(FactorizationHack.loadItemStackFromDataInput(input));
            this.progress = input.readInt();
            return true;
        }
        return false;
    }

    static class CrystalRecipe {
        rj input;
        rj output;
        rj solution;
        float output_count;
        int antium_count;

        public CrystalRecipe(rj input, rj output, float output_count, rj solution, int antium_count) {
            this.input = input;
            this.output = output;
            this.output_count = output_count;
            this.solution = solution;
            this.antium_count = antium_count;
        }

        boolean matches(TileEntityCrystallizer crys) {
            if (crys.output != null) {
                if (!crys.output.a(this.output)) {
                    return false;
                }
                if ((float)crys.output.a + this.output_count > (float)crys.output.d()) {
                    return false;
                }
            }
            if (this.solution != null && crys.countMaterial(this.solution) < this.solution.a) {
                return false;
            }
            if (this.input != null) {
                return crys.countMaterial(this.input) >= this.input.a;
            }
            return true;
        }

        void apply(TileEntityCrystallizer crys) {
            rj is = this.input.l();
            while (is.a > 0) {
                int slot = crys.pickInputSlot(is);
                --crys.inputs[slot].a;
                crys.inputs[slot] = FactorizationUtil.normalize(crys.inputs[slot]);
                --is.a;
            }
            int delta = (int)this.output_count;
            if (TileEntityFactorization.rand.nextFloat() > this.output_count - (float)delta) {
                ++delta;
            }
            if (crys.output == null) {
                crys.output = this.output.l();
                crys.output.a = delta;
            } else {
                crys.output.a += delta;
            }
        }
    }
}

