/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import factorization.api.Charge;
import factorization.api.IChargeConductor;
import factorization.common.BlockClass;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.TileEntityCommon;
import java.io.DataInput;
import java.io.IOException;

public class TileEntityBattery
extends TileEntityCommon
implements IChargeConductor {
    Charge charge = new Charge();
    Charge storage = new Charge();
    static final int max_storage = 6400;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.BATTERY;
    }

    @Override
    public Charge getCharge() {
        return this.charge;
    }

    @Override
    public String getInfo() {
        float f = this.storage.getValue() * 100 / 6400;
        return "Storage: " + (int)f + "%";
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Machine;
    }

    public void a(an tag) {
        super.a(tag);
        this.charge.readFromNBT(tag, "charge");
        this.storage.readFromNBT(tag, "storage");
    }

    @Override
    public void b(an tag) {
        super.b(tag);
        this.charge.writeToNBT(tag, "charge");
        this.storage.writeToNBT(tag, "storage");
    }

    public static float getFullness(int value) {
        return (float)value / 6400.0f;
    }

    public float getFullness() {
        return TileEntityBattery.getFullness(this.storage.getValue());
    }

    public void g() {
        super.g();
        Charge.update(this);
        int val = this.getCharge().getValue();
        int delta = 0;
        int min_charge = 20;
        int max_charge = 30;
        if (val < 20) {
            delta = Math.min(20 - val, this.storage.getValue());
        } else if (val > 30) {
            int free = 6400 - this.storage.getValue();
            if (free <= 0) {
                return;
            }
            delta = -Math.min(free, val - 30);
        } else {
            return;
        }
        int tier = this.storage.getValue() * 32 / 6400;
        if (delta != 0) {
            this.charge.addValue(delta);
            this.storage.addValue(-delta);
        }
        if (tier != this.storage.getValue() * 32 / 6400) {
            this.updateMeter();
        }
    }

    void updateMeter() {
        Core.network.broadcastMessage(null, this.getCoord(), 50, this.storage.getValue());
        this.getCoord().dirty();
    }

    @Override
    public boolean handleMessageFromServer(int messageType, DataInput input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == 50) {
            this.storage.setValue(input.readInt());
            return true;
        }
        return false;
    }

    @Override
    void onPlacedBy(og player, rj is, int side) {
        super.onPlacedBy(player, is, side);
        an tag = FactorizationUtil.getTag(is);
        if (tag.b("storage")) {
            this.storage.setValue(tag.e("storage"));
        } else {
            this.storage.setValue(6400);
        }
    }

    @Override
    byte getExtraInfo() {
        float perc = this.storage.getValue() / 6400;
        return (byte)(perc * 127.0f);
    }

    @Override
    void useExtraInfo(byte b) {
        float perc = (float)b / 127.0f;
        this.storage.setValue((int)(6400.0f * perc));
    }
}

