/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

public class RenderingCube {
    int icon;
    Vector corner;
    Vector origin;
    public double ul;
    public double vl;
    float ax;
    float ay;
    float az;
    float theta;

    public RenderingCube(int icon, Vector corner, Vector origin) {
        this.icon = icon;
        if (origin == null) {
            origin = new Vector(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.corner = corner;
        this.origin = origin;
        this.ul = (double)((icon & 0xF) << 4) / 256.0;
        this.vl = (double)(icon & 0xF0) / 256.0;
    }

    public RenderingCube copy() {
        RenderingCube ret = new RenderingCube(this.icon, this.corner.copy(), this.origin.copy());
        ret.ul = this.ul;
        ret.vl = this.vl;
        ret.ax = this.ax;
        ret.ay = this.ay;
        ret.az = this.az;
        ret.theta = this.theta;
        return ret;
    }

    public RenderingCube normalize() {
        Vector newCorner = this.corner.copy();
        Vector newOrigin = this.origin.copy();
        newCorner.rotate(this.ax, this.ay, this.az, this.theta);
        newOrigin.rotate(this.ax, this.ay, this.az, this.theta);
        newCorner.x = Math.abs(newCorner.x);
        newCorner.y = Math.abs(newCorner.y);
        newCorner.z = Math.abs(newCorner.z);
        return new RenderingCube(this.icon, newCorner, newOrigin);
    }

    public void toBlockBounds(aig b) {
        RenderingCube cube = this.normalize();
        Vector c = cube.corner;
        Vector o = cube.origin;
        c.scale(0.0625f);
        o = o.add(8, 8, 8);
        o.scale(0.0625f);
        b.a(o.x - c.x, o.y - c.y, o.z - c.z, o.x + c.x, o.y + c.y, o.z + c.z);
    }

    public RenderingCube rotate(double ax, double ay2, double az2, int theta) {
        return this.rotate((float)ax, (float)ay2, (float)az2, theta);
    }

    public RenderingCube rotate(float ax, float ay2, float az2, int theta) {
        if (theta == 0) {
            this.theta = 0.0f;
            this.az = 0.0f;
            this.ay = 0.0f;
            this.ax = 0.0f;
            return this;
        }
        this.ax = ax;
        this.ay = ay2;
        this.az = az2;
        this.theta = theta;
        return this;
    }

    public Vector[] faceVerts(int face) {
        Vector[] ret = new Vector[4];
        Vector v = this.corner;
        int c = 8;
        switch (face) {
            case 0: {
                ret[0] = new Vector(v.x, -v.y, v.z, (float)c + v.x, (float)c + v.z);
                ret[1] = new Vector(-v.x, -v.y, v.z, (float)c - v.x, (float)c + v.z);
                ret[2] = new Vector(-v.x, -v.y, -v.z, (float)c - v.x, (float)c - v.z);
                ret[3] = new Vector(v.x, -v.y, -v.z, (float)c + v.x, (float)c - v.z);
                break;
            }
            case 1: {
                ret[0] = new Vector(v.x, v.y, -v.z, (float)c + v.x, (float)c - v.x);
                ret[1] = new Vector(-v.x, v.y, -v.z, (float)c - v.x, (float)c - v.x);
                ret[2] = new Vector(-v.x, v.y, v.z, (float)c - v.x, (float)c + v.x);
                ret[3] = new Vector(v.x, v.y, v.z, (float)c + v.x, (float)c + v.x);
                break;
            }
            case 2: {
                ret[0] = new Vector(v.x, v.y, -v.z, (float)c - v.x, (float)c - v.y);
                ret[1] = new Vector(v.x, -v.y, -v.z, (float)c - v.x, (float)c + v.y);
                ret[2] = new Vector(-v.x, -v.y, -v.z, (float)c + v.x, (float)c + v.y);
                ret[3] = new Vector(-v.x, v.y, -v.z, (float)c + v.x, (float)c - v.y);
                break;
            }
            case 3: {
                ret[0] = new Vector(v.x, v.y, v.z, (float)c - v.x, (float)c - v.y);
                ret[1] = new Vector(-v.x, v.y, v.z, (float)c + v.x, (float)c - v.y);
                ret[2] = new Vector(-v.x, -v.y, v.z, (float)c + v.x, (float)c + v.y);
                ret[3] = new Vector(v.x, -v.y, v.z, (float)c - v.x, (float)c + v.y);
                break;
            }
            case 4: {
                ret[0] = new Vector(-v.x, v.y, v.z, (float)c + v.z, (float)c - v.y);
                ret[1] = new Vector(-v.x, v.y, -v.z, (float)c - v.z, (float)c - v.y);
                ret[2] = new Vector(-v.x, -v.y, -v.z, (float)c - v.z, (float)c + v.y);
                ret[3] = new Vector(-v.x, -v.y, v.z, (float)c + v.z, (float)c + v.y);
                break;
            }
            case 5: {
                ret[0] = new Vector(v.x, v.y, v.z, (float)c + v.z, (float)c - v.y);
                ret[1] = new Vector(v.x, -v.y, v.z, (float)c + v.z, (float)c + v.y);
                ret[2] = new Vector(v.x, -v.y, -v.z, (float)c - v.z, (float)c + v.y);
                ret[3] = new Vector(v.x, v.y, -v.z, (float)c - v.z, (float)c - v.y);
            }
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i].incr(this.origin);
            if (this.theta == 0.0f) continue;
            ret[i].rotate(this.ax, this.ay, this.az, this.theta);
        }
        return ret;
    }

    public static class Vector {
        public float x;
        public float y;
        public float z;
        public float u;
        public float v;

        public Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = 0.0f;
            this.v = 0.0f;
        }

        public Vector(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }

        void rotate(float u, float v, float w, float argtheta) {
            double theta = Math.toRadians(argtheta);
            float ox = this.x;
            float oy = this.y;
            float oz = this.z;
            float cos_theta = (float)Math.cos(theta);
            float sin_theta = (float)Math.sin(theta);
            float product = (u * ox + v * oy + w * oz) * (1.0f - cos_theta);
            this.x = u * product + ox * cos_theta + (-w * oy + v * oz) * sin_theta;
            this.y = v * product + oy * cos_theta + (w * ox - u * oz) * sin_theta;
            this.z = w * product + oz * cos_theta + (-v * ox + u * oy) * sin_theta;
        }

        public Vector add(int dx, int dy, int dz) {
            return new Vector(this.x + (float)dx, this.y + (float)dy, this.z + (float)dz, this.u, this.v);
        }

        void scale(float d) {
            this.x *= d;
            this.y *= d;
            this.z *= d;
        }

        void incr(Vector d) {
            this.x += d.x;
            this.y += d.y;
            this.z += d.z;
        }

        Vector copy() {
            return new Vector(this.x, this.y, this.z, this.u, this.v);
        }

        public String toString() {
            return "<" + this.x + ", " + this.y + ", " + this.z + ">";
        }
    }
}

