/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.GameRegistry;
import factorization.api.IActOnCraft;
import factorization.common.BlockClass;
import factorization.common.BlockFactorization;
import factorization.common.BlockLightAir;
import factorization.common.BlockResource;
import factorization.common.Core;
import factorization.common.FactorizationUtil;
import factorization.common.FactoryType;
import factorization.common.ItemAcidBottle;
import factorization.common.ItemBagOfHolding;
import factorization.common.ItemBattery;
import factorization.common.ItemBlockResource;
import factorization.common.ItemChargeMeter;
import factorization.common.ItemCraft;
import factorization.common.ItemCraftingComponent;
import factorization.common.ItemDemon;
import factorization.common.ItemFactorization;
import factorization.common.ItemMachineUpgrade;
import factorization.common.ItemMirror;
import factorization.common.ItemOreProcessing;
import factorization.common.ItemPocketTable;
import factorization.common.ItemWandOfCooling;
import factorization.common.ItemWrathIgniter;
import factorization.common.MechaArmor;
import factorization.common.MechaBuoyantBarrel;
import factorization.common.MechaCobblestoneDrive;
import factorization.common.MechaMountedPiston;
import factorization.common.ResourceType;
import factorization.common.Sound;
import factorization.common.TileEntityCrystallizer;
import factorization.common.TileEntityGrinder;
import factorization.common.TileEntityMixer;
import factorization.common.TileEntitySlagFurnace;
import factorization.common.TileEntityWatchDemon;
import factorization.common.TileEntityWrathFire;
import factorization.common.TileEntityWrathLamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Registry
implements ICraftingHandler,
IWorldGenerator,
ITickHandler {
    public static final int MechaKeyCount = 3;
    public ItemFactorization item_factorization;
    public ItemBlockResource item_resource;
    public BlockFactorization factory_block;
    public BlockFactorization factory_rendering_block = null;
    public BlockLightAir lightair_block;
    public BlockResource resource_block;
    public rj cutter_item;
    public rj router_item;
    public rj maker_item;
    public rj stamper_item;
    public rj packager_item;
    public rj barrel_item;
    public rj queue_item;
    public rj lamp_item;
    public rj air_item;
    public rj sentrydemon_item;
    public rj slagfurnace_item;
    public rj battery_item_hidden;
    public rj solar_turbine_item;
    public rj heater_item;
    public rj mirror_item_hidden;
    public rj leadwire_item;
    public rj grinder_item;
    public rj mixer_item;
    public rj crystallizer_item;
    public rj silver_ore_item;
    public rj silver_block_item;
    public rj lead_block_item;
    public rj dark_iron_block_item;
    public rj mechaworkshop_item;
    public rj is_factory;
    public rj is_lamp;
    public rj is_lightair;
    public ItemCraft item_craft;
    public ItemBagOfHolding bag_of_holding;
    public ItemPocketTable pocket_table;
    public ItemDemon tiny_demon;
    public ItemDemon bound_tiny_demon;
    public ItemWandOfCooling wand_of_cooling;
    public ItemCraftingComponent diamond_shard;
    public tf diamond_shard_recipe;
    public rj diamond_shard_packet;
    public tf boh_upgrade_recipe;
    public ItemWrathIgniter wrath_igniter;
    public ItemCraftingComponent silver_ingot;
    public ItemCraftingComponent lead_ingot;
    public ItemCraftingComponent dark_iron;
    public ItemCraftingComponent mecha_chasis;
    public MechaArmor mecha_head;
    public MechaArmor mecha_chest;
    public MechaArmor mecha_leg;
    public MechaArmor mecha_foot;
    public MechaBuoyantBarrel mecha_buoyant_barrel;
    public MechaCobblestoneDrive mecha_cobble_drive;
    public MechaMountedPiston mecha_mounted_piston;
    public ItemMachineUpgrade router_item_filter;
    public ItemMachineUpgrade router_machine_filter;
    public ItemMachineUpgrade router_speed;
    public ItemMachineUpgrade router_thorough;
    public ItemMachineUpgrade router_throughput;
    public ItemMachineUpgrade router_eject;
    public ItemMachineUpgrade barrel_enlarge;
    public rj fake_is;
    public ItemCraftingComponent acid;
    public ItemCraftingComponent magnet;
    public ItemCraftingComponent insulated_coil;
    public ItemCraftingComponent motor;
    public ItemCraftingComponent fan;
    public ItemCraftingComponent diamond_cutting_head;
    public ItemChargeMeter charge_meter;
    public ItemMirror mirror;
    public ItemBattery battery;
    public ItemOreProcessing ore_dirty_gravel;
    public ItemOreProcessing ore_clean_gravel;
    public ItemOreProcessing ore_reduced;
    public ItemOreProcessing ore_crystal;
    public ItemCraftingComponent sludge;
    public rj antium;
    public aco materialMachine = new aco(acq.h);
    yk silverGen;
    HashSet added_ids = new HashSet();
    private int demon_spawn_delay = 0;

    void makeBlocks() {
        this.factory_block = new BlockFactorization(Core.factory_block_id);
        this.lightair_block = new BlockLightAir(Core.lightair_id);
        this.resource_block = new BlockResource(Core.resource_id);
        this.is_factory = new rj((aig)this.factory_block);
        this.is_lightair = new rj((aig)this.lightair_block);
        GameRegistry.registerBlock((aig)this.factory_block, ItemFactorization.class);
        GameRegistry.registerBlock((aig)this.lightair_block);
        GameRegistry.registerBlock((aig)this.resource_block, ItemBlockResource.class);
        GameRegistry.registerCraftingHandler((ICraftingHandler)this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this);
        this.factory_block.a(qg.d);
    }

    void makeRenderHelperBlock() {
        aig orig_block = aig.m[Core.factory_block_id];
        if (orig_block != this.factory_block) {
            System.err.println("You changed a Factorization block. Why did you do that?");
            System.err.println("If " + orig_block + " becomes weird, this is why.");
        }
        aig.m[Core.factory_block_id] = null;
        this.factory_rendering_block = new BlockFactorization(Core.factory_block_id);
        aig.m[Core.factory_block_id] = orig_block;
    }

    void registerSimpleTileEntities() {
        FactoryType.registerTileEntities();
        ModLoader.registerEntityID(TileEntityWrathLamp.RelightTask.class, (String)"factory_relight_task", (int)Core.entity_relight_task_id);
    }

    private void addName(Object what, String name2) {
        Core.proxy.addName(what, name2);
    }

    public int itemID(String name2, int default_id) {
        int id = Integer.parseInt(Core.config.getOrCreateIntProperty((String)name2, (String)"item", (int)default_id).value);
        if (this.added_ids.contains(default_id)) {
            throw new RuntimeException("Default ID already used: " + default_id);
        }
        if (rh.e[id] != null) {
            throw new RuntimeException("Item ID conflict: " + id + " is already taken by " + rh.e[id] + "; tried to use it for Factorization " + name2);
        }
        this.added_ids.add(default_id);
        return id;
    }

    rh tab(rh item2, qg tab) {
        item2.a(tab);
        return item2;
    }

    void makeItems() {
        this.ore_dirty_gravel = new ItemOreProcessing(this.itemID("oreDirtyGravel", 9034), 36, "dirtyGravel");
        this.ore_clean_gravel = new ItemOreProcessing(this.itemID("oreCleanGravel", 9035), 37, "cleanGravel");
        this.ore_reduced = new ItemOreProcessing(this.itemID("oreReduced", 9036), 38, "reduced");
        this.ore_crystal = new ItemOreProcessing(this.itemID("oreCrystal", 9037), 39, "crystal");
        this.ore_dirty_gravel.addEnglishNames("Dirty ", " Gravel");
        this.ore_clean_gravel.addEnglishNames("Clean ", " Chunks");
        this.ore_reduced.addEnglishNames("Reduced ", " Chunks");
        this.ore_crystal.addEnglishNames("Crystalline ", "");
        this.sludge = new ItemCraftingComponent(this.itemID("sludge", 9039), "item.sludge", 40);
        this.addName((Object)this.sludge, "Sludge");
        this.item_factorization = (ItemFactorization)rh.e[Core.factory_block_id];
        this.item_resource = (ItemBlockResource)rh.e[this.resource_block.ca];
        this.router_item = FactoryType.ROUTER.itemStack("Router");
        this.cutter_item = FactoryType.CUTTER.itemStack("Stack Cutter");
        this.barrel_item = FactoryType.BARREL.itemStack("Barrel");
        this.queue_item = FactoryType.QUEUE.itemStack("Queue");
        this.maker_item = FactoryType.MAKER.itemStack("Craftpacket Maker");
        this.stamper_item = FactoryType.STAMPER.itemStack("Craftpacket Stamper");
        this.lamp_item = FactoryType.LAMP.itemStack("Wrathlamp");
        this.packager_item = FactoryType.PACKAGER.itemStack("Packager");
        this.sentrydemon_item = FactoryType.SENTRYDEMON.itemStack("Sentry Demon");
        this.slagfurnace_item = FactoryType.SLAGFURNACE.itemStack("Slag Furnace");
        this.battery_item_hidden = FactoryType.BATTERY.itemStack("Battery Block");
        this.solar_turbine_item = FactoryType.SOLARTURBINE.itemStack("Solar Turbine");
        this.heater_item = FactoryType.HEATER.itemStack("Furnace Heater");
        this.mirror_item_hidden = FactoryType.MIRROR.itemStack("Reflective Mirror");
        this.leadwire_item = FactoryType.LEADWIRE.itemStack("Lead Wire");
        this.grinder_item = FactoryType.GRINDER.itemStack("Grinder");
        this.mixer_item = FactoryType.MIXER.itemStack("Mixer");
        this.crystallizer_item = FactoryType.CRYSTALLIZER.itemStack("Crystallizer");
        this.silver_ore_item = ResourceType.SILVERORE.itemStack("Silver Ore");
        this.silver_block_item = ResourceType.SILVERBLOCK.itemStack("Block of Silver");
        this.lead_block_item = ResourceType.LEADBLOCK.itemStack("Block of Lead");
        this.dark_iron_block_item = ResourceType.DARKIRONBLOCK.itemStack("Block of Dark Iron");
        this.mechaworkshop_item = ResourceType.MECHAMODDER.itemStack("Mecha-Modder");
        this.lead_ingot = new ItemCraftingComponent(this.itemID("leadIngot", 9014), "Lead Ingot", 51);
        this.silver_ingot = new ItemCraftingComponent(this.itemID("silverIngot", 9015), "Silver Ingot", 52);
        OreDictionary.registerOre((String)"oreSilver", (rj)this.silver_ore_item);
        OreDictionary.registerOre((String)"ingotSilver", (rj)new rj((rh)this.silver_ingot));
        OreDictionary.registerOre((String)"ingotLead", (rj)new rj((rh)this.lead_ingot));
        this.addName((Object)this.lead_ingot, "Lead Ingot");
        this.addName((Object)this.silver_ingot, "Silver Ingot");
        this.diamond_shard = new ItemCraftingComponent(this.itemID("diamondShard", 9006), "item.diamondshard", 48);
        this.addName((Object)this.diamond_shard, "Diamond Shard");
        this.wrath_igniter = new ItemWrathIgniter(this.itemID("wrathIgniter", 9007));
        this.addName(this.wrath_igniter, "Wrath Igniter");
        this.dark_iron = new ItemCraftingComponent(this.itemID("darkIron", 9008), "item.darkiron", 50);
        this.addName((Object)this.dark_iron, "Dark Iron Ingot");
        this.bag_of_holding = new ItemBagOfHolding(this.itemID("bagOfHolding", 9001));
        this.addName(this.bag_of_holding, "Bag of Holding");
        this.bound_tiny_demon = new ItemDemon(this.itemID("boundTinyDemon", 9003));
        this.tiny_demon = new ItemDemon(this.itemID("tinyDemon", 9004));
        this.addName((Object)this.bound_tiny_demon, "Bound Tiny Demon");
        this.addName((Object)this.tiny_demon, "Tiny Demon");
        this.wand_of_cooling = new ItemWandOfCooling(this.itemID("wandOfCooling", 9005));
        this.addName((Object)this.wand_of_cooling, "Wand of Cooling");
        this.router_item_filter = new ItemMachineUpgrade(this.itemID("routerItemFilter", 9016), "Item Filter", "Router Upgrade", FactoryType.ROUTER, 0);
        this.router_machine_filter = new ItemMachineUpgrade(this.itemID("routerMachineFilter", 9017), "Machine Filter", "Router Upgrade", FactoryType.ROUTER, 1);
        this.router_speed = new ItemMachineUpgrade(this.itemID("routerSpeed", 9018), "Speed Boost", "Router Upgrade", FactoryType.ROUTER, 2);
        this.router_thorough = new ItemMachineUpgrade(this.itemID("routerThorough", 9019), "Thoroughness", "Router Upgrade", FactoryType.ROUTER, 3);
        this.router_throughput = new ItemMachineUpgrade(this.itemID("routerThroughput", 9020), "Bandwidth", "Router Upgrade", FactoryType.ROUTER, 4);
        this.router_eject = new ItemMachineUpgrade(this.itemID("routerEject", 9031), "Ejector", "Router Upgrade", FactoryType.ROUTER, 5);
        this.barrel_enlarge = new ItemMachineUpgrade(this.itemID("barrelEnlarge", 9032), "Extra-Dimensional Storage", "Barrel Upgrade", FactoryType.BARREL, 6);
        this.acid = new ItemAcidBottle(this.itemID("acid", 9024), "Sulfuric Acid", 53);
        this.magnet = new ItemCraftingComponent(this.itemID("magnet", 9025), "Magnet", 54);
        this.insulated_coil = new ItemCraftingComponent(this.itemID("coil", 9026), "Insulated Coil", 55);
        this.motor = new ItemCraftingComponent(this.itemID("motor", 9027), "Motor", 56);
        this.fan = new ItemCraftingComponent(this.itemID("fan", 9028), "Fan", 57);
        this.diamond_cutting_head = new ItemCraftingComponent(this.itemID("diamondCuttingHead", 9038), "Diamond Cutting Head", 58);
        this.charge_meter = new ItemChargeMeter(this.itemID("chargemeter", 9029));
        this.addName((Object)this.charge_meter, "Charge Meter");
        this.mirror = new ItemMirror(this.itemID("mirror", 9030));
        this.addName((Object)this.mirror, "Reflective Mirror");
        this.battery = new ItemBattery(this.itemID("battery", 9033));
        this.addName(this.battery, "Battery Block");
        this.item_craft = new ItemCraft(this.itemID("itemCraftId", 9000));
        this.addName((Object)this.item_craft, "Craftpacket");
        this.mecha_head.setSlotCount(5);
        this.mecha_chest.setSlotCount(8);
        this.mecha_leg.setSlotCount(6);
        this.mecha_foot.setSlotCount(4);
        this.mecha_chasis = new ItemCraftingComponent(this.itemID("mechaChasis", 9009), "item.mechachasis", 5);
        this.addName((Object)this.mecha_chasis, "Mecha-Chassis");
        this.addName((Object)this.mecha_head, "Mecha-Helmet");
        this.addName((Object)this.mecha_chest, "Mecha-Chestplate");
        this.addName((Object)this.mecha_leg, "Mecha-Leggings");
        this.addName((Object)this.mecha_foot, "Mecha-Boots");
        this.mecha_buoyant_barrel = new MechaBuoyantBarrel(this.itemID("mechaBouyantBarrel", 9021));
        this.mecha_cobble_drive = new MechaCobblestoneDrive(this.itemID("mechaCobbleDrive", 9022));
        this.mecha_mounted_piston = new MechaMountedPiston(this.itemID("mechaMountedPiston", 9023));
        this.addName(this.mecha_buoyant_barrel, "Buoyant Barrel");
        this.addName(this.mecha_cobble_drive, "Cobblestone Drive");
        this.addName(this.mecha_mounted_piston, "Mounted Piston");
        this.pocket_table = new ItemPocketTable(this.itemID("pocketCraftingTable", 9002));
        this.addName((Object)this.pocket_table, "Pocket Crafting Table");
    }

    void recipe(rj res, Object ... params) {
        ModLoader.addRecipe((rj)res, (Object[])params);
    }

    void shapelessRecipe(rj res, Object ... params) {
        ModLoader.addShapelessRecipe((rj)res, (Object[])params);
    }

    void oreRecipe(rj res, Object ... params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(res, params);
        td.a().b().add(rec);
    }

    void shapelessOreRecipe(rj res, Object ... params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(res, params);
        td.a().b().add(rec);
    }

    void makeRecipes() {
        this.shapelessRecipe(new rj((rh)this.dark_iron, 4), this.dark_iron_block_item);
        this.recipe(this.dark_iron_block_item, new Object[]{"II", "II", Character.valueOf('I'), this.dark_iron});
        rj BOH = new rj((rh)this.bag_of_holding, 1);
        this.recipe(BOH, new Object[]{"LOL", "ILI", " I ", Character.valueOf('I'), this.dark_iron, Character.valueOf('O'), rh.bn, Character.valueOf('L'), rh.aF});
        this.shapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, rh.bn, rh.aF});
        this.boh_upgrade_recipe = FactorizationUtil.createShapelessRecipe(BOH, new Object[]{BOH, this.dark_iron, rh.bn, rh.aF});
        this.recipe(new rj((rh)this.pocket_table), "# ", " |", Character.valueOf('#'), aig.ay, Character.valueOf('|'), rh.D);
        this.shapelessRecipe(new rj((rh)this.bound_tiny_demon), new Object[]{this.tiny_demon, rh.K});
        this.recipe(new rj((rh)this.wand_of_cooling), new Object[]{" OD", " FO", "I  ", Character.valueOf('O'), aig.ap, Character.valueOf('D'), this.bound_tiny_demon, Character.valueOf('F'), rh.i, Character.valueOf('I'), rh.o});
        this.recipe(new rj((rh)this.wand_of_cooling), new Object[]{"DO ", "OF ", "  I", Character.valueOf('O'), aig.ap, Character.valueOf('D'), this.bound_tiny_demon, Character.valueOf('F'), rh.i, Character.valueOf('I'), rh.o});
        this.diamond_shard_recipe = FactorizationUtil.createShapedRecipe(new rj((rh)this.diamond_shard, 12), "OTO", "TDT", "OTO", Character.valueOf('O'), aig.ap, Character.valueOf('T'), aig.am, Character.valueOf('D'), aig.ax);
        ItemCraft.addStamperRecipe(this.diamond_shard_recipe);
        this.diamond_shard_packet = new rj((rh)this.item_craft);
        this.diamond_shard_packet.b(255);
        for (int i : new int[]{0, 2, 6, 8}) {
            this.item_craft.addItem(this.diamond_shard_packet, i, new rj(aig.ap));
        }
        for (int i : new int[]{1, 3, 5, 7}) {
            this.item_craft.addItem(this.diamond_shard_packet, i, new rj(aig.am));
        }
        this.item_craft.addItem(this.diamond_shard_packet, 4, new rj(aig.ax));
        this.recipe(this.diamond_shard_packet, "OTO", "TDT", "OTO", Character.valueOf('O'), aig.ap, Character.valueOf('T'), aig.am, Character.valueOf('D'), aig.ax);
        this.recipe(new rj((rh)this.wrath_igniter), new Object[]{"D ", " B", Character.valueOf('D'), this.diamond_shard, Character.valueOf('B'), aig.bA});
        this.recipe(new rj((rh)this.wrath_igniter), "D ", " B", Character.valueOf('D'), rh.n, Character.valueOf('B'), aig.bA);
        this.recipe(new rj((rh)this.lead_ingot, 9), "#", Character.valueOf('#'), this.lead_block_item);
        this.recipe(new rj((rh)this.silver_ingot, 9), "#", Character.valueOf('#'), this.silver_block_item);
        tb.a().addSmelting(this.resource_block.ca, 0, new rj((rh)this.silver_ingot));
        this.recipe(new rj((rh)this.mecha_chasis), "III", "InI", "III", Character.valueOf('I'), rh.o, Character.valueOf('n'), rh.bq);
        this.recipe(new rj((rh)this.mecha_head), new Object[]{"###", "# #", Character.valueOf('#'), this.mecha_chasis});
        this.recipe(new rj((rh)this.mecha_chest), new Object[]{"# #", "###", "###", Character.valueOf('#'), this.mecha_chasis});
        this.recipe(new rj((rh)this.mecha_leg), new Object[]{"###", "# #", "# #", Character.valueOf('#'), this.mecha_chasis});
        this.recipe(new rj((rh)this.mecha_foot), new Object[]{"# #", "# #", Character.valueOf('#'), this.mecha_chasis});
        this.recipe(new rj((rh)this.mecha_buoyant_barrel), "W_W", "PBP", "WVW", Character.valueOf('W'), aig.x, Character.valueOf('_'), aig.aM, Character.valueOf('P'), aig.Z, Character.valueOf('B'), this.barrel_item, Character.valueOf('V'), rh.aE);
        rj is_cobble_drive = new rj((rh)this.mecha_cobble_drive);
        this.recipe(is_cobble_drive, "OPO", "WTL", "OOO", Character.valueOf('O'), aig.ap, Character.valueOf('P'), aig.Z, Character.valueOf('W'), rh.ax, Character.valueOf('T'), rh.g, Character.valueOf('L'), rh.ay);
        this.recipe(is_cobble_drive, "OPO", "LTW", "OOO", Character.valueOf('O'), aig.ap, Character.valueOf('P'), aig.Z, Character.valueOf('W'), rh.ax, Character.valueOf('T'), rh.g, Character.valueOf('L'), rh.ay);
        this.recipe(new rj((rh)this.mecha_mounted_piston), "CNC", "LSL", "CCC", Character.valueOf('C'), aig.w, Character.valueOf('S'), aig.V, Character.valueOf('N'), aig.Z, Character.valueOf('L'), aig.aJ);
        this.recipe(this.router_item, new Object[]{"MMM", "oIO", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), rh.aP, Character.valueOf('o'), rh.bn, Character.valueOf('O'), rh.bA});
        this.recipe(this.router_item, new Object[]{"MMM", "OIo", "MMM", Character.valueOf('M'), this.dark_iron, Character.valueOf('I'), rh.aP, Character.valueOf('o'), rh.bn, Character.valueOf('O'), rh.bA});
        this.recipe(new rj((rh)this.router_item_filter), new Object[]{"ITI", "GDG", "ICI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), aig.aQ, Character.valueOf('D'), this.bound_tiny_demon, Character.valueOf('G'), rh.p, Character.valueOf('C'), aig.au});
        this.oreRecipe(new rj((rh)this.router_machine_filter), new Object[]{"ITI", "SDS", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('T'), aig.aQ, Character.valueOf('D'), this.bound_tiny_demon, Character.valueOf('S'), "ingotSilver", Character.valueOf('B'), rh.aL});
        this.recipe(new rj((rh)this.router_speed), new Object[]{"ISI", "SCS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), rh.aY, Character.valueOf('C'), rh.aZ});
        this.recipe(new rj((rh)this.router_thorough), new Object[]{"ISI", "SSS", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), aig.bc});
        this.recipe(new rj((rh)this.router_throughput), new Object[]{"IBI", "B!B", "IBI", Character.valueOf('I'), this.dark_iron, Character.valueOf('B'), rh.bw, Character.valueOf('!'), rh.aP});
        this.recipe(new rj((rh)this.router_eject), new Object[]{"IWI", "C_C", "IPI", Character.valueOf('I'), this.dark_iron, Character.valueOf('W'), aig.x, Character.valueOf('C'), aig.w, Character.valueOf('_'), aig.aM, Character.valueOf('P'), aig.Z});
        this.recipe(this.barrel_item, "W-W", "W W", "WWW", Character.valueOf('W'), aig.J, Character.valueOf('-'), new rj((aig)aig.ak, 1, 2));
        this.recipe(this.maker_item, "#p#", "# #", "#C#", Character.valueOf('#'), aig.w, Character.valueOf('p'), aig.Z, Character.valueOf('C'), aig.ay);
        this.fake_is = this.maker_item;
        this.recipe(this.stamper_item, "#p#", "III", "#C#", Character.valueOf('#'), aig.w, Character.valueOf('p'), aig.Z, Character.valueOf('I'), rh.o, Character.valueOf('C'), aig.ay);
        this.recipe(this.packager_item, "#M#", "# #", "#S#", Character.valueOf('#'), aig.w, Character.valueOf('M'), this.maker_item, Character.valueOf('S'), this.stamper_item);
        this.oreRecipe(this.lamp_item, new Object[]{"ISI", "GWG", "ISI", Character.valueOf('I'), this.dark_iron, Character.valueOf('S'), "ingotSilver", Character.valueOf('G'), aig.bq, Character.valueOf('W'), new rj((rh)this.wrath_igniter, 1, -1)});
        this.recipe(this.slagfurnace_item, "CFC", "C C", "CFC", Character.valueOf('C'), aig.w, Character.valueOf('F'), aig.aB);
        this.createOreProcessingPath(new rj(aig.H), new rj(rh.o), 0);
        this.createOreProcessingPath(new rj(aig.G), new rj(rh.p), 1);
        for (aig redstone : Arrays.asList(aig.aN, aig.aO)) {
            TileEntitySlagFurnace.SlagRecipes.register(redstone, 5.8f, rh.aC, 0.2f, aig.t);
        }
        this.recipe(this.mechaworkshop_item, new Object[]{"MCM", "i i", "i i", Character.valueOf('C'), aig.ay, Character.valueOf('M'), this.mecha_chasis, Character.valueOf('i'), rh.o});
        this.shapelessRecipe(new rj((rh)this.acid), rh.M, rh.M, rh.m, rh.bs);
        this.recipe(new rj((rh)this.fan), "I I", " I ", "I I", Character.valueOf('I'), rh.o);
        this.recipe(this.solar_turbine_item, new Object[]{"###", "#F#", "#M#", Character.valueOf('#'), aig.M, Character.valueOf('F'), this.fan, Character.valueOf('M'), this.motor});
        this.oreRecipe(new rj((rh)this.charge_meter), "WSW", "W/W", "LIL", Character.valueOf('W'), aig.x, Character.valueOf('S'), rh.au, Character.valueOf('/'), rh.D, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), rh.o);
        this.oreRecipe(new rj((rh)this.battery, 1, 2), new Object[]{"ILI", "LAL", "ILI", Character.valueOf('I'), rh.o, Character.valueOf('L'), "ingotLead", Character.valueOf('A'), this.acid});
        for (int damage : new int[]{1, 2}) {
            this.recipe(new rj((rh)this.magnet), "WWW", "WIW", "WBW", Character.valueOf('W'), this.leadwire_item, Character.valueOf('I'), rh.o, Character.valueOf('B'), new rj((rh)this.battery, 1, damage));
        }
        this.oreRecipe(this.heater_item, new Object[]{"CCC", "L L", "CCC", Character.valueOf('C'), this.insulated_coil, Character.valueOf('L'), "ingotLead"});
        this.oreRecipe(new rj((rh)this.insulated_coil), "LLL", "LCL", "LLL", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), aig.aW);
        this.oreRecipe(new rj((rh)this.motor), new Object[]{"CIC", "CMC", "LIL", Character.valueOf('C'), this.insulated_coil, Character.valueOf('M'), this.magnet, Character.valueOf('L'), "ingotLead", Character.valueOf('I'), rh.o});
        this.oreRecipe(new rj((rh)this.mirror), "SSS", "S#S", "SSS", Character.valueOf('S'), "ingotSilver", Character.valueOf('#'), aig.bq);
        rj with_8 = this.leadwire_item.l();
        with_8.a = 8;
        this.oreRecipe(with_8, "LLL", "LLL", Character.valueOf('L'), "ingotLead");
        this.recipe(new rj((rh)this.diamond_cutting_head), new Object[]{"SSS", "SIS", "SSS", Character.valueOf('S'), this.diamond_shard, Character.valueOf('I'), rh.o});
        this.recipe(this.grinder_item, new Object[]{"IMI", "IHI", "LDL", Character.valueOf('I'), rh.o, Character.valueOf('M'), this.motor, Character.valueOf('H'), this.diamond_cutting_head, Character.valueOf('L'), this.lead_ingot, Character.valueOf('D'), this.dark_iron});
        TileEntityGrinder.addRecipe(new rj(aig.t), new rj(aig.w), 1.0f);
        TileEntityGrinder.addRecipe(new rj(aig.w), new rj(aig.F), 1.0f);
        TileEntityGrinder.addRecipe(new rj(aig.F), new rj(aig.E), 1.0f);
        TileEntityGrinder.addRecipe(new rj((aig)aig.u), new rj(aig.v), 1.0f);
        TileEntityGrinder.addRecipe(new rj((aig)aig.by), new rj(aig.v), 1.0f);
        this.recipe(this.mixer_item, new Object[]{" M ", "WXW", "LUL", Character.valueOf('L'), this.lead_ingot, Character.valueOf('M'), this.motor, Character.valueOf('W'), rh.ax, Character.valueOf('X'), this.fan, Character.valueOf('U'), rh.bz});
        TileEntityMixer.addRecipe(new rj[]{new rj((rh)this.sludge, 1), new rj(aig.v), new rj(rh.ax)}, new rj[]{new rj(rh.aI), new rj(rh.aw)});
        this.recipe(this.crystallizer_item, "-S-", "WUW", Character.valueOf('-'), rh.D, Character.valueOf('S'), rh.K, Character.valueOf('W'), aig.x, Character.valueOf('U'), rh.bz);
        rj lime = new rj(rh.aW, 1, 10);
        TileEntityCrystallizer.addRecipe(lime, new rj(rh.aM), 1.0f, new rj(rh.aG), 0);
    }

    void createOreProcessingPath(rj ore, rj ingot, int oreID) {
        ItemOreProcessing.enable(oreID);
        rj dirty = new rj((rh)this.ore_dirty_gravel, 1, oreID);
        rj clean = new rj((rh)this.ore_clean_gravel, 1, oreID);
        rj reduced = new rj((rh)this.ore_reduced, 1, oreID);
        rj crystal = new rj((rh)this.ore_crystal, 1, oreID);
        for (rj is : new rj[]{dirty, clean, reduced, crystal}) {
            tb.a().addSmelting(is.c, is.j(), ingot);
        }
        TileEntitySlagFurnace.SlagRecipes.register(ore, 1.2f, ingot, 0.4f, aig.t);
        TileEntityGrinder.addRecipe(ore, dirty, 1.4f);
        TileEntitySlagFurnace.SlagRecipes.register(dirty, 1.4285715f, ingot, 0.2f, aig.v);
        TileEntityMixer.addRecipe(new rj[]{dirty, new rj(rh.ax)}, new rj[]{clean, new rj(rh.aw), new rj((rh)this.sludge)});
        TileEntitySlagFurnace.SlagRecipes.register(clean, 1.0f, reduced, 0.42857143f, reduced);
        TileEntityCrystallizer.addRecipe(reduced, crystal, 1.5f, new rj((rh)this.acid), 0);
    }

    void addDictOres() {
        for (String oreClass : Arrays.asList("oreCopper", "oreTin", "oreSilver")) {
            rj bestIngot = null;
            ArrayList oreList = OreDictionary.getOres((String)oreClass);
            if (oreList == null || !oreList.iterator().hasNext()) continue;
            for (rj ore : oreList) {
                rj smeltsTo = tb.a().getSmeltingResult(ore);
                if (smeltsTo == null || bestIngot != null && ore.j() == 0) continue;
                bestIngot = smeltsTo;
            }
            if (bestIngot == null) continue;
            int id = -1;
            if (oreClass.equals("oreCopper")) {
                id = 4;
            }
            if (oreClass.equals("oreTin")) {
                id = 3;
            }
            if (oreClass.equals("oreSilver")) {
                id = 2;
                bestIngot = new rj((rh)this.lead_ingot);
            }
            for (rj ore : oreList) {
                this.createOreProcessingPath(ore, bestIngot, id);
            }
        }
    }

    @ForgeSubscribe
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        String oreClass = evt.Name;
        rj ore = evt.Ore;
        if (oreClass.equals("ingotLead")) {
            ModLoader.addRecipe((rj)this.lead_block_item, (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), ore});
            return;
        }
        if (oreClass.equals("ingotSilver")) {
            ModLoader.addRecipe((rj)this.silver_block_item, (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), ore});
            return;
        }
        if (oreClass.equals("oreSilver")) {
            TileEntitySlagFurnace.SlagRecipes.register(ore, 0.9f, new rj((rh)this.silver_ingot), 1.4f, new rj((rh)this.lead_ingot));
            return;
        }
    }

    public void setToolEffectiveness() {
        for (String tool : new String[]{"pickaxe", "axe", "shovel"}) {
            MinecraftForge.removeBlockEffectiveness((aig)this.factory_block, (String)tool);
            MinecraftForge.removeBlockEffectiveness((aig)this.resource_block, (String)tool);
        }
        BlockClass.DarkIron.harvest("pickaxe", 2);
        BlockClass.Barrel.harvest("axe", 1);
        BlockClass.Machine.harvest("pickaxe", 0);
        BlockClass.Cage.harvest("pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel((aig)this.resource_block, (String)"pickaxe", (int)2);
    }

    public void makeOther() {
        this.silverGen = new yk(this.resource_block.ca, 35);
    }

    public void onTickPlayer(og player) {
        MechaArmor.onTickPlayer(player);
        if (player.p.K) {
            return;
        }
        if (player.by.o() != null) {
            this.tiny_demon.playerHolding(player.by.o(), (jw)player);
        } else {
            this.tiny_demon.playerHolding(player.by.g(), (jw)player);
        }
    }

    public void onTickWorld(up world) {
        if (world.K) {
            return;
        }
        TileEntityWrathLamp.handleAirUpdates();
        TileEntityWrathFire.updateCount = 0;
        TileEntityWatchDemon.worldTick(world);
    }

    @ForgeSubscribe
    public boolean onItemPickup(EntityItemPickupEvent event) {
        og player = event.entityPlayer;
        nj item2 = event.item;
        if (item2 == null || item2.a == null || item2.a.a == 0) {
            return true;
        }
        if (player.L) {
            return true;
        }
        rj is = item2.a;
        of inv = player.by;
        int remaining_size = is.a;
        int free_slots = 0;
        for (int i = 0; i < inv.i_(); ++i) {
            int free;
            rj here = inv.a(i);
            if (here == null) {
                ++free_slots;
                continue;
            }
            if (is.a(here) && (remaining_size -= (free = here.d() - here.a)) <= 0) break;
        }
        if (remaining_size > 0) {
            ArrayList<rj> bags = new ArrayList<rj>();
            for (int i = 0; i < inv.i_(); ++i) {
                rj here = inv.a(i);
                if (here == null || here.b() != this.bag_of_holding) continue;
                bags.add(here);
            }
            boolean success = false;
            for (rj bag : bags) {
                if (is.a < 0) break;
                success = this.bag_of_holding.insertItem(bag, is);
            }
            if (success) {
                Sound.bagSlurp.playAt((jn)player);
            }
        }
        Core.proxy.pokePocketCrafting();
        this.tiny_demon.bitePlayer(is, (jw)player, true);
        return true;
    }

    public void generate(Random rand, int chunkX, int chunkZ, up world, wi chunkGenerator, wi chunkProvider) {
        if (!Core.gen_silver_ore) {
            return;
        }
        if ((chunkZ + 3 * chunkX) % 5 != 0) {
            return;
        }
        int x = chunkX * 16 + rand.nextInt(16);
        int z = chunkZ * 16 + rand.nextInt(16);
        int y = 5 + rand.nextInt(48);
        this.silverGen.a(world, rand, x, y, z);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        --this.demon_spawn_delay;
        if (this.demon_spawn_delay < -1) {
            this.demon_spawn_delay = 1200;
        }
        if (type.contains(TickType.WORLD)) {
            up w = (up)tickData[0];
            if (w.K) {
                return;
            }
            this.onTickWorld(w);
            if (this.demon_spawn_delay == 0) {
                ItemDemon.spawnDemons(w);
            }
        }
        if (type.contains(TickType.PLAYER)) {
            og player = (og)tickData[0];
            this.onTickPlayer(player);
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD, TickType.PLAYER);
    }

    public String getLabel() {
        return "factorization-world";
    }

    public void onCrafting(og player, rj stack, ix craftMatrix) {
        for (int i = 0; i < craftMatrix.i_(); ++i) {
            rh item2;
            rj here = craftMatrix.a(i);
            if (here == null || !((item2 = here.b()) instanceof IActOnCraft)) continue;
            ((IActOnCraft)item2).onCraft(here, craftMatrix, i, stack, player);
        }
        if (stack.b() == this.item_craft && stack.j() == this.diamond_shard_packet.j()) {
            stack.d((an)this.diamond_shard_packet.p().b());
            stack.b(1);
        }
    }

    public void onSmelting(og player, rj item2) {
    }
}

