/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import factorization.api.Coord;
import factorization.common.Command;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.Sound;
import factorization.common.TileEntityBarrel;
import factorization.common.TileEntityCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IllegalFormatException;

public class NetworkFactorization
implements IPacketHandler {
    protected static final String factorizeTEChannel = "factorizeTE";
    protected static final String factorizeMsgChannel = "factorizeMsg";
    protected static final String factorizeCmdChannel = "factorizeCmd";
    private static final ThreadLocal currentPlayer = new ThreadLocal();

    public NetworkFactorization() {
        Core.network = this;
    }

    public ce messagePacket(Coord src, int messageType, Object ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            output.writeInt(src.x);
            output.writeInt(src.y);
            output.writeInt(src.z);
            output.writeInt(messageType);
            for (Object item2 : items) {
                if (item2 == null) {
                    throw new RuntimeException("Argument is null!");
                }
                if (item2 instanceof Integer) {
                    output.writeInt((Integer)item2);
                    continue;
                }
                if (item2 instanceof Byte) {
                    output.writeByte(((Byte)item2).byteValue());
                    continue;
                }
                if (item2 instanceof String) {
                    output.writeUTF((String)item2);
                    continue;
                }
                if (item2 instanceof Boolean) {
                    output.writeBoolean((Boolean)item2);
                    continue;
                }
                if (item2 instanceof rj) {
                    an tag = new an();
                    ((rj)item2).b(tag);
                    FactorizationHack.tagWrite(tag, output);
                    continue;
                }
                throw new RuntimeException("Argument is not Integer/Byte/String/Boolean/ItemStack: " + item2);
            }
            output.flush();
            ce packet = new ce();
            packet.a = factorizeTEChannel;
            packet.c = outputStream.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ce translatePacket(String ... items) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            for (String i : items) {
                output.writeUTF(i);
            }
            output.flush();
            ce packet = new ce();
            packet.a = factorizeMsgChannel;
            packet.c = outputStream.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendCommand(og player, Command cmd, byte arg) {
        ce packet = new ce();
        packet.a = factorizeCmdChannel;
        packet.c = new byte[2];
        packet.c[0] = cmd.id;
        packet.c[1] = arg;
        packet.b = packet.c.length;
        Core.proxy.addPacket(player, (db)packet);
    }

    public void broadcastMessage(og who, Coord src, int messageType, Object ... msg) {
        ce toSend = this.messagePacket(src, messageType, msg);
        if (who == null || !who.p.K) {
            this.broadcastPacket(who, src, (db)toSend);
        } else {
            Core.proxy.addPacket(who, (db)toSend);
        }
    }

    public void broadcastPacket(og who, Coord src, db toSend) {
        if (src.w == null) {
            return;
        }
        if (who == null) {
            int max_dist = (int)(3.0 * Math.pow(32.0, 2.0));
            for (og player : src.w.i) {
                if (src.distanceSq(new Coord((jn)player)) > max_dist || !Core.proxy.playerListensToCoord(player, src)) continue;
                Core.proxy.addPacket(player, toSend);
            }
        } else {
            Core.proxy.addPacket(who, toSend);
        }
    }

    og getCurrentPlayer() {
        og ret = (og)currentPlayer.get();
        if (ret == null) {
            throw new NullPointerException("currentPlayer was unset");
        }
        return ret;
    }

    public void onPacketData(az network, ce packet, Player player) {
        String channel = packet.a;
        byte[] data = packet.c;
        currentPlayer.set((og)player);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(inputStream);
        if (channel.equals(factorizeTEChannel)) {
            this.handleTE(input);
        } else if (channel.equals(factorizeMsgChannel)) {
            this.handleMsg(input);
        } else if (channel.equals(factorizeCmdChannel)) {
            this.handleCmd(data);
        }
        currentPlayer.set(null);
    }

    void handleTE(DataInput input) {
        try {
            int x = input.readInt();
            int y = input.readInt();
            int z = input.readInt();
            int messageType = input.readInt();
            if (!this.getCurrentPlayer().p.e(x, y, z)) {
                return;
            }
            if (messageType == 1) {
                FactoryType ft = FactoryType.fromMd(input.readInt());
                byte extraData = input.readByte();
                byte extraData2 = input.readByte();
                try {
                    messageType = input.readInt();
                }
                catch (IOException e) {
                    messageType = -1;
                }
                up world = this.getCurrentPlayer().p;
                Coord here = new Coord(world, x, y, z);
                TileEntityCommon spawn = (TileEntityCommon)here.getTE(TileEntityCommon.class);
                if (spawn != null && spawn.getFactoryType() != ft) {
                    world.q(x, y, z);
                    spawn = null;
                }
                if (spawn == null) {
                    spawn = ft.makeTileEntity();
                    spawn.k = world;
                    world.a(x, y, z, (aji)spawn);
                }
                if (spawn != null) {
                    spawn.useExtraInfo(extraData);
                    spawn.useExtraInfo2(extraData2);
                }
            }
            if (messageType == -1) {
                return;
            }
            Coord target = new Coord(this.getCurrentPlayer().p, x, y, z);
            TileEntityCommon tec = (TileEntityCommon)target.getTE(TileEntityCommon.class);
            if (tec == null) {
                this.handleForeignMessage(this.getCurrentPlayer().p, x, y, z, tec, messageType, input);
                return;
            }
            boolean handled = target.w.K ? tec.handleMessageFromServer(messageType, input) : tec.handleMessageFromClient(messageType, input);
            if (!handled) {
                this.handleForeignMessage(this.getCurrentPlayer().p, x, y, z, tec, messageType, input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleMsg(DataInput input) {
        String main;
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        try {
            main = input.readUTF();
        }
        catch (IOException e1) {
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        try {
            while (true) {
                String orig = input.readUTF();
                String name2 = orig + ".name";
                String transd = ak.a().b(name2);
                if (transd.compareTo(name2) == 0) {
                    items.add(orig);
                    continue;
                }
                items.add(transd);
            }
        }
        catch (IOException e) {
            try {
                this.getCurrentPlayer().c(String.format(main, items.toArray()));
            }
            catch (IllegalFormatException e2) {
                System.out.print("Illegal format: \"" + main + '\"');
                for (String i : items) {
                    System.out.print(" \"" + i + "\"");
                }
                System.out.println();
                e2.printStackTrace();
            }
            return;
        }
    }

    void handleCmd(byte[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        byte s = data[0];
        byte arg = data[1];
        Command.fromNetwork(this.getCurrentPlayer(), s, arg);
    }

    void handleForeignMessage(up world, int x, int y, int z, aji ent, int messageType, DataInput input) throws IOException {
        if (world.K) {
            Coord here = new Coord(world, x, y, z);
            switch (messageType) {
                case 10: {
                    if (!(ent instanceof aiz)) break;
                    Core.proxy.pokeChest((aiz)ent);
                    break;
                }
                case 11: {
                    Sound.receive(input);
                    break;
                }
                case 12: {
                    aig.Z.b(world, x, y, z, 0, input.readInt());
                    here.setId(0);
                    break;
                }
                case 43: {
                    TileEntityBarrel.spawnBreakParticles(here, input.readInt());
                    break;
                }
                default: {
                    if (world.e(x, y, z)) {
                        Core.logWarning("Got unhandled message: " + messageType + " for " + here, new Object[0]);
                        break;
                    }
                    Core.logWarning("Got message to unloaded chunk: " + messageType + " for " + here, new Object[0]);
                }
            }
        }
    }

    public static class MessageType {
        public static final int ShareAll = -1;
        public static final int DemonEnterChest = 10;
        public static final int PlaySound = 11;
        public static final int PistonPush = 12;
        public static final int DrawActive = 0;
        public static final int FactoryType = 1;
        public static final int MakerTarget = 11;
        public static final int MakerFuel = 12;
        public static final int RouterSlot = 20;
        public static final int RouterTargetSide = 21;
        public static final int RouterMatch = 22;
        public static final int RouterIsInput = 23;
        public static final int RouterLastSeen = 24;
        public static final int RouterMatchToVisit = 25;
        public static final int RouterDowngrade = 26;
        public static final int RouterUpgradeState = 27;
        public static final int RouterEjectDirection = 28;
        public static final int BarrelDescription = 40;
        public static final int BarrelItem = 41;
        public static final int BarrelCount = 42;
        public static final int BarrelLoss = 43;
        public static final int BatteryLevel = 50;
        public static final int MirrorTargetRotation = 60;
        public static final int MirrorDescription = 61;
        public static final int TurbineWater = 70;
        public static final int TurbineSpeed = 71;
        public static final int HeaterHeat = 80;
        public static final int GrinderSpeed = 90;
        public static final int MixerSpeed = 100;
        public static final int CrystallizerInfo = 110;
        public static final int WireFace = 121;
    }
}

