/*
 * Decompiled with CFR 0.152.
 */
package factorization.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import factorization.common.FactorizationProxy;
import factorization.common.NetworkFactorization;
import factorization.common.Registry;
import factorization.common.TileEntityWrathFire;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;

@Mod(modid="factorization", name="Factorization", version="0.5.0")
@NetworkMod(clientSideRequired=true, packetHandler=NetworkFactorization.class, channels={"factorizeTE", "factorizeMsg", "factorizeCmd"}, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(packetHandler=NetworkFactorization.class, channels={"factorizeTE", "factorizeMsg", "factorizeCmd"}), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(packetHandler=NetworkFactorization.class, channels={"factorizeTE", "factorizeMsg", "factorizeCmd"}))
public class Core {
    public static final String version = "0.5.0";
    @Mod.Instance
    public static Core instance;
    public static Registry registry;
    @SidedProxy(clientSide="factorization.client.FactorizationClientProxy", serverSide="factorization.common.FactorizationServerProxy")
    public static FactorizationProxy proxy;
    public static NetworkFactorization network;
    public static int factory_rendertype;
    public static Configuration config;
    public static int factory_block_id;
    public static int lightair_id;
    public static int resource_id;
    public static Pattern routerBan;
    public static int block_item_id_offset;
    public static boolean render_barrel_item;
    public static boolean render_barrel_text;
    public static boolean debug_light_air;
    public static int watch_demon_chunk_range;
    public static int entity_relight_task_id;
    public static boolean gen_silver_ore;
    public static boolean spread_wrathfire;
    public static boolean pocket_craft_anywhere;
    public static boolean bag_swap_anywhere;
    public static String pocketActions;
    public static boolean add_branding;
    public static boolean cheat;
    public static final String texture_dir = "/factorization/texture/";
    public static final String texture_file_block = "/factorization/texture/blocks.png";
    public static final String texture_file_item = "/factorization/texture/items.png";
    HashMap keyStateMap = new HashMap();
    static int ExtraKey_minimum;

    private int getBlockConfig(String name2, int defaultId, String comment) {
        Property prop = config.getOrCreateBlockIdProperty(name2, defaultId);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultId);
    }

    private int getIntConfig(String category, String name2, int defaultValue, String comment) {
        Property prop = config.getOrCreateIntProperty(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getInt(defaultValue);
    }

    private boolean getBoolConfig(String category, String name2, boolean defaultValue, String comment) {
        Property prop = config.getOrCreateBooleanProperty(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.getBoolean(defaultValue);
    }

    private String getStringConfig(String category, String name2, String defaultValue, String comment) {
        Property prop = config.getOrCreateProperty(category, name2, defaultValue);
        if (comment != null && comment.length() != 0) {
            prop.comment = comment;
        }
        return prop.value;
    }

    @Mod.PreInit
    public void loadConfig(FMLPreInitializationEvent event) {
        Object p;
        config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading config: %s", (Object[])new Object[]{e.toString()});
            e.printStackTrace();
        }
        factory_block_id = this.getBlockConfig("factoryBlockId", factory_block_id, "Factorization Machines.");
        lightair_id = this.getBlockConfig("lightAirBlockId", lightair_id, "WrathFire and invisible lamp-air made by WrathLamps");
        resource_id = this.getBlockConfig("resourceBlockId", resource_id, "Ores and metal blocks mostly");
        debug_light_air = this.getBoolConfig("debugLightAir", "general", debug_light_air, "Render invisible lamp-air");
        gen_silver_ore = this.getBoolConfig("generateSilverOre", "general", gen_silver_ore, null);
        pocket_craft_anywhere = this.getBoolConfig("anywherePocketCraft", "general", pocket_craft_anywhere, "Lets you open the pocket crafting table from GUIs");
        bag_swap_anywhere = this.getBoolConfig("anywhereBagSwap", "general", bag_swap_anywhere, "Lets you use the bag from GUIs");
        String attempt = this.getStringConfig("pocketCraftingActionKeys", "general", pocketActions, "3 keys for: removing (x), cycling (c), balancing (b)");
        if (attempt.length() == 3) {
            pocketActions = attempt;
        } else {
            p = config.getOrCreateProperty("pocketCraftingActionKeys", "general", pocketActions);
            ((Property)p).value = pocketActions;
            ((Property)p).comment = "3 keys for: removing (x), cycling (c), balancing (b)";
        }
        block_item_id_offset = this.getIntConfig("blockItemIdOffset", "misc", block_item_id_offset, "Hopefully you'll never need to change these.");
        render_barrel_item = this.getBoolConfig("renderBarrelItem", "misc", render_barrel_item, null);
        render_barrel_item = this.getBoolConfig("renderBarrelText", "misc", render_barrel_text, null);
        spread_wrathfire = this.getBoolConfig("spreadWrathFire", "smpAdmin", spread_wrathfire, null);
        p = this.getStringConfig("bannedRouterInventoriesRegex", "smpAdmin", "", null);
        if (p != null && ((String)p).length() != 0) {
            try {
                routerBan = Pattern.compile((String)p);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                System.err.println("Factorization: config has invalid Java Regex for banned_router_inventories: " + (String)p);
            }
        }
        if ((entity_relight_task_id = config.getOrCreateIntProperty("entityRelightTask", "general", -1).getInt()) == -1) {
            entity_relight_task_id = ModLoader.getUniqueEntityId();
            Property prop = config.getOrCreateIntProperty("entityRelightTask", "general", entity_relight_task_id);
            prop.value = "" + entity_relight_task_id;
            prop.comment = "This is a Java Regex to blacklist access to TE";
        }
        add_branding = this.getBoolConfig("addBranding", "misc", add_branding, null);
        config.save();
        registry = new Registry();
        registry.makeBlocks();
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)registry);
        MinecraftForge.EVENT_BUS.register((Object)this);
        TickRegistry.registerTickHandler((ITickHandler)registry, (Side)Side.CLIENT);
        TickRegistry.registerTickHandler((ITickHandler)registry, (Side)Side.SERVER);
        registry.registerSimpleTileEntities();
        proxy.makeItemsSide();
        registry.makeItems();
        config.save();
        registry.makeOther();
        registry.makeRecipes();
        registry.setToolEffectiveness();
        proxy.registerKeys();
        proxy.registerRenderers();
        config.save();
    }

    @Mod.PostInit
    public void modsLoaded(FMLPostInitializationEvent event) {
        TileEntityWrathFire.setupBurning();
        registry.addDictOres();
        registry.makeRenderHelperBlock();
    }

    rj getExternalItem(String className, String classField, String description) {
        try {
            Class<?> c = Class.forName(className);
            return (rj)c.getField(classField).get(null);
        }
        catch (Exception err) {
            System.out.println("Could not get " + description);
            return null;
        }
    }

    void putPlayerKey(og player, int key, boolean state) {
        KeyState[] pmap = (KeyState[])this.keyStateMap.get(player);
        if (pmap == null) {
            pmap = new KeyState[3];
            this.keyStateMap.put(player, pmap);
        }
        pmap[key] = state ? KeyState.KEYSTART : KeyState.KEYOFF;
    }

    KeyState getPlayerKeyState(og player, int key) {
        if (player == null) {
            return KeyState.KEYOFF;
        }
        if (key < 0) {
            return ExtraKey.fromInt(key).isActive(player) ? KeyState.KEYON : KeyState.KEYOFF;
        }
        KeyState[] arr = (KeyState[])this.keyStateMap.get(player);
        if (arr == null) {
            this.putPlayerKey(player, 0, false);
            return KeyState.KEYOFF;
        }
        KeyState ret = arr[key];
        if (ret == null) {
            return KeyState.KEYOFF;
        }
        return ret;
    }

    boolean hasPlayerKey(og player, int key) {
        return this.getPlayerKeyState(player, key).isPressed();
    }

    public void updatePlayerKeys() {
        for (KeyState[] states : this.keyStateMap.values()) {
            for (int i = 0; i < states.length; ++i) {
                if (states[i] == KeyState.KEYSTART) {
                    states[i] = KeyState.KEYON;
                }
                if (states[i] != null) continue;
                states[i] = KeyState.KEYOFF;
            }
        }
    }

    public static void logWarning(String format, Object ... data) {
        FMLLog.warning((String)("Factorization: " + format), (Object[])data);
    }

    public static void addBlockToCreativeList(List tab, aig block2) {
        ArrayList a = new ArrayList();
        block2.addCreativeItems(a);
        for (Object o : a) {
            tab.add(o);
        }
    }

    public static void profileStart(String section) {
    }

    public static void profileEnd() {
    }

    public static void brand(List list) {
        if (add_branding) {
            list.add("Factorization");
        }
        if (cheat) {
            list.add("Cheat mode!");
        }
    }

    static {
        factory_block_id = 254;
        lightair_id = 253;
        resource_id = 252;
        block_item_id_offset = -256;
        render_barrel_item = true;
        render_barrel_text = true;
        debug_light_air = false;
        watch_demon_chunk_range = 3;
        entity_relight_task_id = -1;
        gen_silver_ore = true;
        spread_wrathfire = true;
        pocket_craft_anywhere = true;
        bag_swap_anywhere = true;
        pocketActions = "xcb";
        add_branding = false;
        cheat = false;
        ExtraKey_minimum = 0;
    }

    public static enum ExtraKey {
        SNEAK(-1, "sneaking"),
        INAIR(-2, "in the air"),
        RUN(-3, "running");

        int id;
        public String text;

        /*
         * WARNING - void declaration
         */
        private ExtraKey() {
            void text;
            void id;
            this.id = id;
            this.text = text;
            ExtraKey_minimum = Math.min(ExtraKey_minimum, (int)id);
        }

        public static ExtraKey fromInt(int i) {
            for (ExtraKey ek : ExtraKey.values()) {
                if (ek.id != i) continue;
                return ek;
            }
            return INAIR;
        }

        boolean isActive(og player) {
            switch (this) {
                case SNEAK: {
                    return player.af();
                }
                case INAIR: {
                    return player.al;
                }
                case RUN: {
                    return player.ag();
                }
            }
            return false;
        }
    }

    static enum KeyState {
        KEYOFF,
        KEYSTART,
        KEYON;


        boolean isPressed() {
            return this != KEYOFF;
        }
    }
}

