/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.common.BlockFactorization;
import factorization.common.Core;
import factorization.common.FactoryType;
import factorization.common.RenderingCube;
import factorization.common.Texture;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public abstract class FactorizationBlockRender
implements ICoord {
    static aig metal = aig.ap;
    static aig glass = aig.bd;
    protected boolean world_mode;
    protected uz w;
    protected int x;
    protected int y;
    protected int z;
    protected int metadata;
    private static FactorizationBlockRender[] renderMap = new FactorizationBlockRender[255];
    private static FactorizationBlockRender defaultRender;

    public static FactorizationBlockRender getRenderer(int md) {
        FactorizationBlockRender ret = renderMap[md];
        if (ret == null) {
            return defaultRender;
        }
        return ret;
    }

    public FactorizationBlockRender() {
        if (this.getFactoryType() != null) {
            FactorizationBlockRender.renderMap[this.getFactoryType().md] = this;
        } else {
            defaultRender = this;
        }
    }

    abstract void render(avg var1);

    abstract FactoryType getFactoryType();

    void renderSecondPass(avg rb) {
    }

    @Override
    public Coord getCoord() {
        if (!this.world_mode) {
            return null;
        }
        return new Coord((up)Minecraft.x().e, this.x, this.y, this.z);
    }

    public final void renderInWorld(uz w, int wx, int wy, int wz) {
        this.world_mode = true;
        this.w = w;
        this.x = wx;
        this.y = wy;
        this.z = wz;
    }

    public final void renderInInventory() {
        this.world_mode = false;
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public final void setMetadata(int md) {
        this.metadata = md;
    }

    protected void renderNormalBlock(avg rb, int md) {
        BlockFactorization b = Core.registry.factory_rendering_block;
        b.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (this.world_mode) {
            rb.q((aig)b, this.x, this.y, this.z);
        } else {
            Core.registry.factory_rendering_block.fake_normal_render = true;
            rb.a((aig)b, md, 1.0f);
            Core.registry.factory_rendering_block.fake_normal_render = false;
        }
    }

    protected void renderPart(avg rb, int texture, float b1, float b2, float b3, float b4, float b5, float b6) {
        BlockFactorization block2 = Core.registry.factory_rendering_block;
        block2.a(b1, b2, b3, b4, b5, b6);
        if (this.world_mode) {
            Texture.force_texture = texture;
            rb.q((aig)block2, this.x, this.y, this.z);
            Texture.force_texture = -1;
        } else {
            this.renderPartInvTexture(rb, (aig)block2, texture);
        }
        block2.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPartInvTexture(avg renderblocks, aig block2, int texture) {
        ave tessellator = ave.a;
        block2.f();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.b();
        tessellator.b(0.0f, -1.0f, 0.0f);
        renderblocks.a(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 1.0f, 0.0f);
        renderblocks.b(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, -1.0f);
        renderblocks.c(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, 1.0f);
        renderblocks.d(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(-1.0f, 0.0f, 0.0f);
        renderblocks.e(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(1.0f, 0.0f, 0.0f);
        renderblocks.f(block2, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    protected void renderCube(RenderingCube rc) {
        if (!this.world_mode) {
            ave.a.b();
            ForgeHooksClient.bindTexture((String)"/factorization/texture/blocks.png", (int)0);
            GL11.glDisable((int)2896);
        }
        for (int face = 0; face < 6; ++face) {
            RenderingCube.Vector[] vecs = rc.faceVerts(face);
            for (int i = 0; i < vecs.length; ++i) {
                RenderingCube.Vector vec = vecs[i];
                this.vertex(rc, vec.x, vec.y, vec.z, vec.u, vec.v);
            }
        }
        if (!this.world_mode) {
            ave.a.a();
            ForgeHooksClient.unbindTexture();
            GL11.glEnable((int)2896);
        }
    }

    protected void vertex(RenderingCube rc, float x, float y, float z, float u, float v) {
        ave.a.a(1.0f, 1.0f, 1.0f);
        ave.a.a((double)this.x + 0.5 + (double)(x / 16.0f), (double)this.y + 0.5 + (double)(y / 16.0f), (double)this.z + 0.5 + (double)(z / 16.0f), rc.ul + (double)(u / 256.0f), rc.vl + (double)(v / 256.0f));
    }

    public static void renderItemIn2D(int icon_index) {
        float var6 = ((float)(icon_index % 16 * 16) + 0.0f) / 256.0f;
        float var7 = ((float)(icon_index % 16 * 16) + 15.9999f) / 256.0f;
        float var8 = ((float)(icon_index / 16 * 16) + 0.0f) / 256.0f;
        float var9 = ((float)(icon_index / 16 * 16) + 15.9999f) / 256.0f;
        FactorizationBlockRender.renderItemIn2D_DO(ave.a, var7, var8, var6, var9);
    }

    static void renderItemIn2D_DO(ave par1Tessellator, float par2, float par3, float par4, float par5) {
        float var11;
        float var10;
        float var9;
        int var8;
        float var6 = 1.0f;
        float var7 = 0.0625f;
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 0.0f, 1.0f);
        par1Tessellator.a(0.0, 0.0, 0.0, (double)par2, (double)par5);
        par1Tessellator.a((double)var6, 0.0, 0.0, (double)par4, (double)par5);
        par1Tessellator.a((double)var6, 1.0, 0.0, (double)par4, (double)par3);
        par1Tessellator.a(0.0, 1.0, 0.0, (double)par2, (double)par3);
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 0.0f, -1.0f);
        par1Tessellator.a(0.0, 1.0, (double)(0.0f - var7), (double)par2, (double)par3);
        par1Tessellator.a((double)var6, 1.0, (double)(0.0f - var7), (double)par4, (double)par3);
        par1Tessellator.a((double)var6, 0.0, (double)(0.0f - var7), (double)par4, (double)par5);
        par1Tessellator.a(0.0, 0.0, (double)(0.0f - var7), (double)par2, (double)par5);
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(-1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(1.0f, 0.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par2 + (par4 - par2) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.a((double)var11, 1.0, (double)(0.0f - var7), (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 1.0, 0.0, (double)var10, (double)par3);
            par1Tessellator.a((double)var11, 0.0, 0.0, (double)var10, (double)par5);
            par1Tessellator.a((double)var11, 0.0, (double)(0.0f - var7), (double)var10, (double)par5);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, 1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9 + 0.0625f;
            par1Tessellator.a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
            par1Tessellator.a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
        }
        par1Tessellator.a();
        par1Tessellator.b();
        par1Tessellator.b(0.0f, -1.0f, 0.0f);
        for (var8 = 0; var8 < 16; ++var8) {
            var9 = (float)var8 / 16.0f;
            var10 = par5 + (par3 - par5) * var9 - 0.001953125f;
            var11 = var6 * var9;
            par1Tessellator.a((double)var6, (double)var11, 0.0, (double)par4, (double)var10);
            par1Tessellator.a(0.0, (double)var11, 0.0, (double)par2, (double)var10);
            par1Tessellator.a(0.0, (double)var11, (double)(0.0f - var7), (double)par2, (double)var10);
            par1Tessellator.a((double)var6, (double)var11, (double)(0.0f - var7), (double)par4, (double)var10);
        }
        par1Tessellator.a();
    }

    void renderMotor(avg rb, float yoffset) {
        int lead = Core.registry.lead_block_item.c();
        float d = 0.25f;
        float yd = -d + 0.003f;
        this.renderPart(rb, lead, d, d + yd + yoffset, d, 1.0f - d, 1.0f - (d + 0.0f) + yd + yoffset, 1.0f - d);
    }
}

