/*
 * Decompiled with CFR 0.152.
 */
package factorization.client.render;

import factorization.api.Coord;
import factorization.client.render.FactorizationBlockRender;
import factorization.common.FactoryType;
import factorization.common.RenderingCube;
import factorization.common.TileEntitySolarTurbine;
import factorization.common.TileEntityWire;
import factorization.common.WireConnections;
import org.lwjgl.opengl.GL11;

public class BlockRenderSolarTurbine
extends FactorizationBlockRender {
    static final float d = 0.0625f;

    @Override
    void render(avg rb) {
        if (this.world_mode) {
            Coord me = this.getCoord();
            TileEntitySolarTurbine st = (TileEntitySolarTurbine)me.getTE(TileEntitySolarTurbine.class);
            if (st == null) {
                return;
            }
            this.renderSolarTurbine(rb, st.water_level, me);
        } else {
            this.renderSolarTurbine(rb, 0, null);
        }
    }

    @Override
    void renderSecondPass(avg rb) {
        Coord me = this.getCoord();
        TileEntitySolarTurbine st = (TileEntitySolarTurbine)me.getTE(TileEntitySolarTurbine.class);
        if (st == null) {
            return;
        }
        if ((float)st.water_level <= 0.0625f) {
            return;
        }
        int water_height = st.water_level;
        this.renderPart(rb, 7, 0.0625f, 0.001f, 0.0625f, 0.9375f, (0.99f + (float)(water_height / (TileEntitySolarTurbine.max_water / 4))) / 16.0f, 0.9375f);
    }

    void renderSolarTurbine(avg rb, int water_height, Coord me) {
        int glass = 12;
        int water = 7;
        float m = 1.0E-4f;
        this.renderPart(rb, glass, 0.0f + m, 0.0f + m, 0.0f + m, 1.0f - m, 1.0f - m, 1.0f - m);
        if (!this.world_mode) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.5f, (float)0.1f, (float)-0.5f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            BlockRenderSolarTurbine.renderItemIn2D(10);
            GL11.glPopMatrix();
        }
        this.renderMotor(rb, 0.0f);
        if (this.world_mode) {
            TileEntityWire fake_wire = new TileEntityWire();
            fake_wire.k = me.w;
            fake_wire.l = me.x;
            fake_wire.m = me.y;
            fake_wire.n = me.z;
            fake_wire.supporting_side = 0;
            WireConnections con = new WireConnections(fake_wire);
            con.conductorRestrict();
            for (RenderingCube rc : con.getParts()) {
                this.renderCube(rc);
            }
        }
    }

    @Override
    FactoryType getFactoryType() {
        return FactoryType.SOLARTURBINE;
    }
}

