/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

public class DeltaCoord {
    public int x;
    public int y;
    public int z;
    public static DeltaCoord[] directNeighbors = new DeltaCoord[]{DeltaCoord.d(1, 0, 0), DeltaCoord.d(-1, 0, 0), DeltaCoord.d(0, -1, 0), DeltaCoord.d(0, 1, 0), DeltaCoord.d(0, 0, -1), DeltaCoord.d(0, 0, 1)};

    public DeltaCoord() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public DeltaCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DeltaCoord add(DeltaCoord o) {
        return new DeltaCoord(this.x + o.x, this.y + o.y, this.z + o.z);
    }

    public boolean isZero() {
        return this.x == 0 && this.y == 0 && this.z == 0;
    }

    public String toString() {
        return "DeltaCoord(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    private static DeltaCoord d(int x, int y, int z) {
        return new DeltaCoord(x, y, z);
    }

    public double getAngleHorizontal() {
        return Math.atan2(this.z, -this.x);
    }

    public int getFaceSide() {
        if (this.x == 0 && this.z == 0) {
            if (this.y == -1) {
                return 0;
            }
            if (this.y == 1) {
                return 1;
            }
        } else if (this.y == 0 && this.x == 0) {
            if (this.z == -1) {
                return 2;
            }
            if (this.z == 1) {
                return 3;
            }
        } else if (this.y == 0 && this.z == 0) {
            if (this.x == -1) {
                return 4;
            }
            if (this.x == 1) {
                return 5;
            }
        }
        return -1;
    }

    public DeltaCoord reverse() {
        return new DeltaCoord(-this.x, -this.y, -this.z);
    }

    public boolean isSubmissive() {
        return this.x < 0 || this.y < 0 || this.z < 0;
    }

    public boolean equals(DeltaCoord o) {
        return this.x == o.x && this.y == o.y && this.z == o.z;
    }
}

