/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.DeltaCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;

public class Coord {
    public up w;
    public int x;
    public int y;
    public int z;
    private static Random rand = new Random();

    public Coord(up w, int x, int y, int z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Deprecated
    public Coord(up w, aji te) {
        this(w, te.l, te.m, te.n);
    }

    public Coord(aji te) {
        this(te.k, te.l, te.m, te.n);
    }

    public Coord(jn ent) {
        this(ent.p, (int)ent.t, (int)(ent.u + (double)ent.M), (int)ent.v);
    }

    public Coord(up w, double x, double y, double z) {
        this(w, (int)x, (int)y, (int)z);
    }

    public String toString() {
        String ret = "(" + this.x + ", " + this.y + ", " + this.z + ")";
        if (this.w != null) {
            ret = ret + " a " + this.getBlock();
        }
        return ret;
    }

    public int hashCode() {
        return (this.x * 11 % 71 << 7) + this.z * 7 % 479 + this.y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coord) {
            Coord other = (Coord)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.w == other.w;
        }
        return false;
    }

    public Coord copy() {
        return new Coord(this.w, this.x, this.y, this.z);
    }

    public boolean parity() {
        return (this.x + this.y + this.z & 1) == 0;
    }

    public int seed() {
        return (this.x << 4 + this.z << 8) + this.y;
    }

    public DeltaCoord difference(Coord b) {
        return new DeltaCoord(this.x - b.x, this.y - b.y, this.z - b.z);
    }

    public double distance(Coord o) {
        return Math.sqrt(this.distanceSq(o));
    }

    public int distanceSq(Coord o) {
        if (o == null) {
            return 0;
        }
        int dx = this.x - o.x;
        int dy = this.y - o.y;
        int dz = this.z - o.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public int distanceManhatten(Coord o) {
        if (o == null) {
            return 0;
        }
        int dx = this.x - o.x;
        int dy = this.y - o.y;
        int dz = this.z - o.z;
        return Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
    }

    public ArrayList getNeighborsAdjacent() {
        ArrayList<Coord> ret = new ArrayList<Coord>(6);
        for (DeltaCoord d : DeltaCoord.directNeighbors) {
            ret.add(this.add(d));
        }
        return ret;
    }

    public ArrayList getNeighborsDiagonal() {
        ArrayList<Coord> ret = new ArrayList<Coord>(26);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    ret.add(this.add(dx, dy, dz));
                }
            }
        }
        return ret;
    }

    public ArrayList getRandomNeighborsAdjacent() {
        ArrayList ret = this.getNeighborsAdjacent();
        Collections.shuffle(ret);
        return ret;
    }

    public ArrayList getRandomNeighborsDiagonal() {
        ArrayList ret = this.getNeighborsDiagonal();
        Collections.shuffle(ret);
        return ret;
    }

    public Coord getSingleRandomNeighborAdjacent() {
        int r = rand.nextInt(DeltaCoord.directNeighbors.length);
        return this.add(DeltaCoord.directNeighbors[r]);
    }

    public Coord d(int dx, int dy, int dz) {
        return new Coord(this.w, this.x + dx, this.y + dy, this.z + dz);
    }

    public Coord[] getNeighborsInPlane(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return new Coord[]{this.d(-1, 0, 0), this.d(1, 0, 0), this.d(0, 0, -1), this.d(0, 0, 1)};
            }
            case 2: 
            case 3: {
                return new Coord[]{this.d(-1, 0, 0), this.d(1, 0, 0), this.d(0, -1, 0), this.d(0, 1, 0)};
            }
            case 4: 
            case 5: {
                return new Coord[]{this.d(0, 0, -1), this.d(0, 0, 1), this.d(0, -1, 0), this.d(0, 1, 0)};
            }
        }
        return null;
    }

    public Coord[] getNeighborsOutOfPlane(int side) {
        switch (side) {
            case 0: 
            case 1: {
                return new Coord[]{this.d(0, -1, 0), this.d(0, 1, 0)};
            }
            case 2: 
            case 3: {
                return new Coord[]{this.d(0, 0, -1), this.d(0, 0, 1)};
            }
            case 4: 
            case 5: {
                return new Coord[]{this.d(-1, 0, 0), this.d(1, 0, 0)};
            }
        }
        return null;
    }

    public boolean isSubmissiveTo(Coord o) {
        return this.y < o.y || this.x < o.x || this.z < o.z;
    }

    public void setWorld(up newWorld) {
        this.w = newWorld;
    }

    public Coord add(DeltaCoord d) {
        return this.add(d.x, d.y, d.z);
    }

    public Coord add(int x, int y, int z) {
        return new Coord(this.w, this.x + x, this.y + y, this.z + z);
    }

    public void dirty() {
        this.w.d(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public void updateLight() {
        this.w.x(this.x, this.y, this.z);
    }

    public void setTE(aji te) {
        this.w.a(this.x, this.y, this.z, te);
    }

    public Coord towardSide(int side) {
        switch (side) {
            case 0: {
                --this.y;
                break;
            }
            case 1: {
                ++this.y;
                break;
            }
            case 2: {
                --this.z;
                break;
            }
            case 3: {
                ++this.z;
                break;
            }
            case 4: {
                --this.x;
                break;
            }
            case 5: {
                ++this.x;
            }
        }
        return this;
    }

    public aji getTE() {
        return this.w.p(this.x, this.y, this.z);
    }

    public Object getTE(Class clazz) {
        aji te = this.getTE();
        if (clazz.isInstance(te)) {
            return te;
        }
        return null;
    }

    public void rmTE() {
        this.w.q(this.x, this.y, this.z);
    }

    public aig getBlock() {
        return aig.m[this.getId()];
    }

    public int getId() {
        return this.w.a(this.x, this.y, this.z);
    }

    public int getMd() {
        return this.w.g(this.x, this.y, this.z);
    }

    public boolean isAir() {
        return this.w.c(this.x, this.y, this.z);
    }

    public boolean isSolid() {
        aig b = this.getBlock();
        if (b == null) {
            return false;
        }
        return this.getBlock().isBlockNormalCube(this.w, this.x, this.y, this.z);
    }

    @Deprecated
    public boolean isSolidOnSide(int side) {
        return this.w.isBlockSolidOnSide(this.x, this.y, this.z, ForgeDirection.getOrientation((int)side));
    }

    public boolean isSolidOnSide(ForgeDirection side) {
        return this.w.isBlockSolidOnSide(this.x, this.y, this.z, side);
    }

    public boolean blockExists() {
        return this.w.e(this.x, this.y, this.z);
    }

    public boolean isReplacable() {
        aig b = this.getBlock();
        if (b == null) {
            return true;
        }
        return b.isBlockReplaceable(this.w, this.x, this.y, this.z);
    }

    public boolean isTop() {
        return this.w.f(this.x, this.z) == this.y;
    }

    public boolean canBeSeenThrough() {
        if (this.w.c(this.x, this.y, this.z)) {
            return true;
        }
        return aig.o[this.getId()] == 0;
    }

    public boolean canSeeSky() {
        for (int i = this.y + 1; i < this.w.K(); ++i) {
            if (new Coord(this.w, this.x, i, this.z).canBeSeenThrough()) continue;
            return false;
        }
        return true;
    }

    public boolean is(aig b) {
        return this.getId() == b.ca;
    }

    public boolean is(aig b, int md) {
        return this.getId() == b.ca && this.getMd() == md;
    }

    public boolean setId(int id, boolean notify) {
        if (notify) {
            return this.w.e(this.x, this.y, this.z, id);
        }
        return this.w.b(this.x, this.y, this.z, id);
    }

    public boolean setMd(int md, boolean notify) {
        if (notify) {
            this.w.c(this.x, this.y, this.z, md);
            return true;
        }
        return this.w.d(this.x, this.y, this.z, md);
    }

    public boolean setIdMd(int id, int md, boolean notify) {
        if (notify) {
            return this.w.d(this.x, this.y, this.z, id, md);
        }
        return this.w.c(this.x, this.y, this.z, id, md);
    }

    public boolean setId(int id) {
        return this.setId(id, true);
    }

    public boolean setMd(int md) {
        return this.setMd(md, true);
    }

    public boolean setIdMd(int id, int md) {
        return this.setIdMd(id, md, true);
    }

    public boolean setId(aig block2) {
        return this.setId(block2.ca);
    }

    public void writeToNBT(String prefix, an tag) {
        tag.a(prefix + "x", this.x);
        tag.a(prefix + "y", this.y);
        tag.a(prefix + "z", this.z);
    }

    public void readFromNBT(String prefix, an tag) {
        this.x = tag.e(prefix + "x");
        this.y = tag.e(prefix + "y");
        this.z = tag.e(prefix + "z");
    }

    public void mark() {
        this.w.a("reddust", (double)this.x, (double)this.y, (double)this.z, 0.0, 0.0, 0.0);
    }

    public boolean remote() {
        return this.w.K;
    }

    public boolean local() {
        return !this.w.K;
    }
}

