/*
 * Decompiled with CFR 0.152.
 */
package factorization.api;

import factorization.api.Coord;
import factorization.api.IChargeConductor;
import java.util.ArrayList;
import java.util.HashSet;

public class Charge {
    private int charge = 0;
    private static ArrayList frontier = new ArrayList(100);
    private static HashSet visited = new HashSet(125);

    public int getValue() {
        return this.charge;
    }

    public void setValue(int newCharge) {
        this.charge = Math.max(0, newCharge);
    }

    public int addValue(int chargeToAdd) {
        this.setValue(this.charge + chargeToAdd);
        return this.charge;
    }

    public void writeToNBT(an tag, String name2) {
        tag.a(name2, this.charge);
    }

    public void readFromNBT(an tag, String name2) {
        this.setValue(tag.e(name2));
    }

    public void swapWith(Charge other) {
        int a = this.charge;
        int b = other.charge;
        this.setValue(b);
        other.setValue(a);
    }

    public static void update(IChargeConductor te) {
        Coord here = te.getCoord();
        if (here.remote()) {
            return;
        }
        Charge me = te.getCharge();
        if (here.parity()) {
            return;
        }
        for (Coord neighbor : here.getRandomNeighborsAdjacent()) {
            IChargeConductor n = (IChargeConductor)neighbor.getTE(IChargeConductor.class);
            if (n == null) continue;
            me.swapWith(n.getCharge());
            return;
        }
    }

    public static ChargeDensityReading getChargeDensity(IChargeConductor start, int maxDistance) {
        int totalCharge = 0;
        int maxCharge = 0;
        frontier.clear();
        visited.clear();
        frontier.add(start);
        visited.add(start);
        while (frontier.size() > 0) {
            IChargeConductor here = (IChargeConductor)frontier.remove(0);
            Coord hereCoord = here.getCoord();
            int hereCharge = here.getCharge().charge;
            totalCharge += hereCharge;
            maxCharge = Math.max(maxCharge, hereCharge);
            for (Coord neighborCoord : hereCoord.getNeighborsAdjacent()) {
                IChargeConductor neighbor = (IChargeConductor)neighborCoord.getTE(IChargeConductor.class);
                if (neighbor == null || visited.contains(neighbor) || neighborCoord.distanceManhatten(hereCoord) > maxDistance) continue;
                frontier.add(neighbor);
                visited.add(neighbor);
            }
        }
        ChargeDensityReading ret = new ChargeDensityReading();
        ret.totalCharge = totalCharge;
        ret.conductorCount = visited.size();
        ret.maxCharge = maxCharge;
        return ret;
    }

    public static class ChargeDensityReading {
        public int totalCharge;
        public int conductorCount;
        public int maxCharge;
    }
}

