/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.IAchievementHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.core.ForestryCore;
import forestry.core.Proxy;
import forge.IGuiHandler;
import forge.IPacketHandler;
import forge.IPickupHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PluginManager {
    public static ArrayList plugins = new ArrayList();
    public static ArrayList guiHandlers = new ArrayList();
    public static ArrayList packetHandlers = new ArrayList();
    public static ArrayList pickupHandlers = new ArrayList();
    public static ArrayList achievementHandlers = new ArrayList();
    public static ArrayList resupplyHandlers = new ArrayList();

    public static void loadPlugins() {
        PluginManager.loadIncludedPlugins();
        PluginManager.loadExternalPlugins();
    }

    public static void loadIncludedPlugins() {
        block9: {
            try {
                File modLocation = new File(ForestryCore.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                ClassLoader classLoader = ForestryCore.class.getClassLoader();
                if (modLocation.isFile() && (modLocation.getName().endsWith(".jar") || modLocation.getName().endsWith(".zip"))) {
                    ZipEntry entry = null;
                    FileInputStream fileIO = new FileInputStream(modLocation);
                    ZipInputStream zipIO = new ZipInputStream(fileIO);
                    while (true) {
                        if ((entry = zipIO.getNextEntry()) == null) {
                            fileIO.close();
                            break block9;
                        }
                        String entryName = entry.getName();
                        File entryFile = new File(entryName);
                        String pluginName = entryFile.getName();
                        if (entry.isDirectory() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                        PluginManager.addPlugin(classLoader, pluginName);
                    }
                }
                if (modLocation.isDirectory()) {
                    File[] fileList;
                    Package pack = PluginManager.class.getPackage();
                    if (pack != null) {
                        String pluginDir = pack.getName();
                        pluginDir = pluginDir.replace('.', File.separatorChar);
                        modLocation = new File(modLocation, pluginDir);
                    }
                    if ((fileList = modLocation.listFiles()) != null) {
                        for (int i = 0; i < fileList.length; ++i) {
                            String pluginName = fileList[i].getName();
                            if (!fileList[i].isFile() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                            PluginManager.addPlugin(classLoader, pluginName);
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void loadExternalPlugins() {
        try {
            File modLocation = new File(ForestryCore.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            File pluginDir = new File(Proxy.getForestryRoot() + "/mods");
            ClassLoader classLoader = ForestryCore.class.getClassLoader();
            if (!pluginDir.isDirectory()) {
                return;
            }
            File[] fileList = pluginDir.listFiles();
            if (fileList == null) {
                return;
            }
            block2: for (File file : fileList) {
                if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || file.getName().equals(modLocation.getName())) continue;
                ZipEntry entry = null;
                FileInputStream fileIO = new FileInputStream(file);
                ZipInputStream zipIO = new ZipInputStream(fileIO);
                while (true) {
                    if ((entry = zipIO.getNextEntry()) == null) {
                        fileIO.close();
                        continue block2;
                    }
                    String entryName = entry.getName();
                    File entryFile = new File(entryName);
                    String pluginName = entryFile.getName();
                    if (entry.isDirectory() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                    PluginManager.addPlugin(classLoader, pluginName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addPlugin(ClassLoader classLoader, String pluginName) {
        if (pluginName.equals("PluginManager.class")) {
            return;
        }
        String pluginClassName = pluginName.split("\\.")[0];
        Package pack = PluginManager.class.getPackage();
        if (pack != null) {
            pluginClassName = pack.getName() + "." + pluginClassName;
        }
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            if (pluginClass != null) {
                Object obj = pluginClass.newInstance();
                if (!(obj instanceof IPlugin)) {
                    return;
                }
                IPlugin plugin = (IPlugin)obj;
                if (plugin != null) {
                    IResupplyHandler resupplyHandler;
                    IAchievementHandler achievementHandler;
                    IPickupHandler pickupHandler;
                    IPacketHandler packetHandler;
                    ModLoader.getLogger().fine("Found plugin for " + plugin.getDescription());
                    plugins.add(plugin);
                    IGuiHandler guiHandler = plugin.getGuiHandler();
                    if (guiHandler != null) {
                        guiHandlers.add(guiHandler);
                    }
                    if ((packetHandler = plugin.getPacketHandler()) != null) {
                        packetHandlers.add(packetHandler);
                    }
                    if ((pickupHandler = plugin.getPickupHandler()) != null) {
                        pickupHandlers.add(pickupHandler);
                    }
                    if ((achievementHandler = plugin.getAchievementHandler()) != null) {
                        achievementHandlers.add(achievementHandler);
                    }
                    if ((resupplyHandler = plugin.getResupplyHandler()) != null) {
                        resupplyHandlers.add(resupplyHandler);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

